import java.applet.Applet;
import java.awt.*;
import java.awt.event.*;
import java.applet.*;
import java.awt.geom.*;
import java.math.*;

public class Disk {


    public static GeneralPath disk(Complex z,double r, int N) {
	GeneralPath gp=new GeneralPath();
	for(int k=0;k<N;++k) {
	    double t=2.0*Math.PI*k/N;
	    double c=z.x+r*Math.cos(t);
	    double s=z.y+r*Math.sin(t);
	    if(k==0) gp.moveTo((float)(c),(float)(s));
	    if(k!=0) gp.lineTo((float)(c),(float)(s));
	}
	gp.closePath();
	return(gp);
    }


    public static GeneralPath halfDisk(Complex z,double r, int N) {
	GeneralPath gp=new GeneralPath();
	for(int k=0;k<N+1;++k) {
	    double t=1.0*Math.PI*k/N;
	    double c=z.x+r*Math.cos(t);
	    double s=z.y+r*Math.sin(t);
	    if(k==0) gp.moveTo((float)(c),(float)(s));
	    if(k!=0) gp.lineTo((float)(c),(float)(s));
	}
	return(gp);
    }

    public static GeneralPath halfDisk(double a,double b,int N) {
	Complex z=new Complex(.5*(a+b),0);
	double r=Math.abs(a-b)/2.0;
	return(halfDisk(z,r,N));
    }

    public static GeneralPath halfDiskBackwards(Complex z,double r, int N) {
	GeneralPath gp=new GeneralPath();
	for(int k=N;k>=0;--k) {
	    double t=1.0*Math.PI*k/N;
	    double c=z.x+r*Math.cos(t);
	    double s=z.y+r*Math.sin(t);
	    if(k==N) gp.moveTo((float)(c),(float)(s));
	    if(k!=N) gp.lineTo((float)(c),(float)(s));
	}
	return(gp);
    }

    public static GeneralPath halfDiskBackwards(double a,double b,int N) {
	Complex z=new Complex(.5*(a+b),0);
	double r=Math.abs(a-b)/2.0;
	return(halfDiskBackwards(z,r,N));
    }


    public static GeneralPath ideal0(int N) {
	GeneralPath gp=new GeneralPath();
	gp.moveTo(0,2);
	gp.lineTo(0,0);
	gp.append(halfDiskBackwards(0,1,N),true);
	gp.lineTo(1,2);
	gp.closePath();
	return(gp);
    }

    public static GeneralPath ideal(double a,double b,double c,int N) {
	double a1=Math.min(Math.min(a,b),c);
	double c1=Math.max(Math.max(a,b),c);
	double b1=a+b+c-a1-c1;
	GeneralPath gp=halfDiskBackwards(a1,b1,N);
	gp.append(halfDiskBackwards(b1,c1,N),true);
	gp.append(halfDisk(c1,a1,N),true);
	return(gp);
    }

    public static GeneralPath vertical(double r) {
	GeneralPath gp=new GeneralPath();
	gp.moveTo((float)(r),2);
	gp.lineTo((float)(r),0);
	return(gp);
    }

    public static GeneralPath horizontal() {
	GeneralPath gp=new GeneralPath();
	gp.moveTo(0,0);
	gp.lineTo(1,0);
	return(gp);
    }

    public static GeneralPath box() {
	GeneralPath gp=new GeneralPath();
	gp.moveTo(0,0);
	gp.lineTo(1,0);
	gp.lineTo(1,1);
	gp.lineTo(0,1);
	gp.closePath();
	return(gp);
    }
    
}

