import java.applet.Applet;
import java.awt.event.*;
import java.awt.*;






/*Applet 9 is a fancier version of Applet 8.  To
deal with multiple pieces, we make a new class,
the Checker, which is composed of 4 ListenTriangles*/



public class test1 extends Applet {
    PictureCanvas P;    //the auxilliary graphics class
    public void init() {
    setBackground(Color.black);
    P=new PictureCanvas();
    P.resize(500,500);
    add(P);
    }
}


class DBCanvas extends Canvas {
    
    public void update(Graphics g) {
        Graphics g2;
        Image offscreen = null;
        offscreen = createImage(size().width, size().height);
        g2 = offscreen.getGraphics();
        paint(g2);
        g.drawImage(offscreen, 0, 0, this);
	g2.dispose();
	offscreen.flush();
    }
}


class PictureCanvas extends DBCanvas implements MouseListener {

    Checker X[] =new Checker[3];

    PictureCanvas() { 
    Color col1,col2;
    setBackground(new Color(0,0,100));
    addMouseListener(this);
 
    col1=new Color(255,255,100);
    col2=new Color(200,200,80);
    X[0]=new Checker(375,375,25,5,col1,col1,col2,col2,1);

    col1=new Color(255,200,100);
    col2=new Color(200,150,80);
    X[1]=new Checker(125,225,25,10,col1,col1,col2,col2,2);

    col1=new Color(250,100,150);
    col2=new Color(200,80,120);
    X[2]=new Checker(375,225,25,15,col1,col1,col2,col2,2);
  }

    
  public void paint(Graphics g) {  

      /**checkers on the checkerboard*/
      g.drawRect(50,50,400,400);
      for(int i=50;i<=350;i=i+100) {
	  for(int j=50;j<=350;j=j+100) {
	      g.setColor(new Color(100,0,0));
	      g.fillRect(i,j,50,50);
              g.fillRect(i+50,j+50,50,50);
	  }
      }  

      /*checkerboard frame*/ 
      g.setColor(Color.black);
      g.fillRect(0,0,500,50);  
      g.fillRect(0,450,500,50);
      g.fillRect(0,0,50,500);
      g.fillRect(450,0,50,500);
      g.setColor(Color.yellow);
      g.drawRect(50,50,400,400);

      /*the three pieces*/
      for(int jj=0;jj<=2;++jj) X[jj].render(g);

      /*words*/
      g.setFont(new Font("Helvetica",Font.PLAIN,30));
      g.setColor(Color.yellow);
      g.drawString("Rich: Applet 9",150,35);
      g.setFont(new Font("Helvetica",Font.PLAIN,20));
      g.drawString("Click on the bright squares to move them.",60,480);
  }

  public void mousePressed(MouseEvent e) {}
  public void mouseReleased(MouseEvent e) {}
  public void mouseEntered(MouseEvent e) {}
  public void mouseExited(MouseEvent e) {}
  public void mouseClicked(MouseEvent e) {
      Point y=new Point();
      int ins[]=new int[3];
      e.consume();
      y.x=e.getX();
      y.y=e.getY();

      for(int i=0;i<=2;++i) {
      ins[i]=X[i].inside(y);
      X[i]=X[i].move(y);  
      if(ins[i]>0) repaint(X[i].xstart,X[i].ystart,X[i].xmotion,X[i].ymotion);
      }
  }
}

 







class ListenTriangle {

    /**fields**/
    int[] x,y;
    Color C;


    /**methods**/

    /**initialization method**/
    ListenTriangle(int[] x,int[] y,Color C) {
	this.x=x;
	this.y=y;
        this.C=C;
    }
    

    /**some algebra which tells if a point is inside the triangle**/
    int inside(Point p) {     
	double x1,y1,x2,y2;   
	double A1,A2,A3;
	int val;
	x1=p.x-this.x[0];
	y1=p.y-this.y[0];
	x2=p.x-this.x[1];
	y2=p.y-this.y[1];
	A3=x1*y2-y1*x2;
	x1=p.x-this.x[1];
	y1=p.y-this.y[1];
	x2=p.x-this.x[2];
	y2=p.y-this.y[2];
	A1=x1*y2-y1*x2;
	x1=p.x-this.x[2];
	y1=p.y-this.y[2];
	x2=p.x-this.x[0];
	y2=p.y-this.y[0];
	A2=x1*y2-y1*x2;
	val=0;
	if((A1<0)&&(A2<0)&&(A3<0)) val=1;
	if((A1>0)&&(A2>0)&&(A3>0)) val=1;
	return(val);
    }

    /**graphics method**/
    void render(Graphics g) {
	g.setColor(this.C);
	g.fillPolygon(x,y,3);
    }

}














class Checker {
    ListenTriangle n,s,e,w;
    Color cn,cs,ce,cw;
    int x,y,r,pad,piece,xmin,xmax,ymin,ymax,xmotion,ymotion,xstart,ystart;

    Checker(int x,int y,int r,int pad,Color cn,Color cs,Color ce, Color cw,int piece) {
	xmin=x-r+pad;
	xmax=x+r-pad;
	ymin=y-r+pad;
	ymax=y+r-pad;
	int nx[]={xmin,x,xmax};
	int ny[]={ymin,y,ymin};
	int sx[]={xmin,x,xmax};
	int sy[]={ymax,y,ymax};
	int ex[]={xmax,x,xmax};
	int ey[]={ymin,y,ymax};
	int wx[]={xmin,x,xmin};
	int wy[]={ymin,y,ymax};
	this.n=new ListenTriangle(nx,ny,cn);
        this.s=new ListenTriangle(sx,sy,cs);
	this.e=new ListenTriangle(ex,ey,ce);
        this.w=new ListenTriangle(wx,wy,cw);
	this.x=x;
	this.y=y;
	this.r=r;
	this.xstart=x-r;
	this.ystart=y-r;
	this.xmotion=0;
	this.ymotion=0;
	this.piece=piece;
    }

    void render(Graphics g) {
	n.render(g);
	s.render(g);
	e.render(g);
	w.render(g);
    }
    
    int inside(Point x) {
	int value;
	value=0;
	if(this.n.inside(x)==1) value=1;
        if(this.s.inside(x)==1) value=2;
        if(this.e.inside(x)==1) value=3;
        if(this.w.inside(x)==1) value=4;
	return(value);
    }

    Checker move(Point x) {
	int value=inside(x);
        Checker ZZ=this;
	ZZ.xmotion=0;
	ZZ.ymotion=0;

	if((value==1)&&(ZZ.y>100)) 
	    {
	     ZZ.y=ZZ.y-2*ZZ.r;
	     for(int i=0;i<=2;++i)
	       {
		 ZZ.n.y[i]=ZZ.n.y[i]-2*ZZ.r;
                 ZZ.s.y[i]=ZZ.s.y[i]-2*ZZ.r;
                 ZZ.e.y[i]=ZZ.e.y[i]-2*ZZ.r;
                 ZZ.w.y[i]=ZZ.w.y[i]-2*ZZ.r;
	       }
	     ZZ.xstart=ZZ.x-ZZ.r;
	     ZZ.ystart=ZZ.y-ZZ.r;
	     ZZ.xmotion=2*ZZ.r;
	     ZZ.ymotion=4*ZZ.r;
	    }

	if((value==2)&&(ZZ.y<400))
	    {
	    ZZ.y=ZZ.y+2*ZZ.r;
	    for(int i=0;i<=2;++i)
	       {
		 ZZ.n.y[i]=ZZ.n.y[i]+2*ZZ.r;
                 ZZ.s.y[i]=ZZ.s.y[i]+2*ZZ.r;
                 ZZ.e.y[i]=ZZ.e.y[i]+2*ZZ.r;
                 ZZ.w.y[i]=ZZ.w.y[i]+2*ZZ.r;
	       }
	     ZZ.xstart=ZZ.x-ZZ.r;
	     ZZ.ystart=ZZ.y-3*ZZ.r;
	     ZZ.xmotion=2*ZZ.r;
	     ZZ.ymotion=4*ZZ.r;
	    }

	if((value==3)&&(ZZ.x<400))
	    {
	    ZZ.x=ZZ.x+2*ZZ.r;
	    for(int i=0;i<=2;++i)
	       {
		 ZZ.n.x[i]=ZZ.n.x[i]+2*ZZ.r;
                 ZZ.s.x[i]=ZZ.s.x[i]+2*ZZ.r;
                 ZZ.e.x[i]=ZZ.e.x[i]+2*ZZ.r;
                 ZZ.w.x[i]=ZZ.w.x[i]+2*ZZ.r;
	       }
	     ZZ.xstart=ZZ.x-3*ZZ.r;
	     ZZ.ystart=ZZ.y-ZZ.r;
	     ZZ.xmotion=4*ZZ.r;
	     ZZ.ymotion=2*ZZ.r;
	    }

	if((value==4)&&(ZZ.x>100))
	    {
	    ZZ.x=ZZ.x-2*ZZ.r;
	    for(int i=0;i<=2;++i)
	       {
		 ZZ.n.x[i]=ZZ.n.x[i]-2*ZZ.r;
                 ZZ.s.x[i]=ZZ.s.x[i]-2*ZZ.r;
                 ZZ.e.x[i]=ZZ.e.x[i]-2*ZZ.r;
                 ZZ.w.x[i]=ZZ.w.x[i]-2*ZZ.r;
	       }
	     ZZ.xstart=ZZ.x-ZZ.r;
	     ZZ.ystart=ZZ.y-ZZ.r;
	     ZZ.xmotion=4*ZZ.r;
	     ZZ.ymotion=2*ZZ.r;
	    }
	return(ZZ);
    }



}
