import java.applet.Applet;
import java.awt.*;
import java.awt.event.*;
import java.awt.geom.*;



public class test1 extends Applet {
	      PixCanvas B;
	      public void init() {
		  B=new PixCanvas();
		  B.resize(800,700);
		  B.setBackground(Color.black);
		  this.add(B);
		  setBackground(Color.black);
	      }
}




class PixCanvas extends DBCanvas implements MouseListener, MouseMotionListener {
    Canvas pix;
    int l;
    ListenTriangle[] T=new ListenTriangle[120000];
    Color[] COL=new Color[100];
    int length;
    int border;
    int color;

    PixCanvas() {
	addMouseListener(this);
	addMouseMotionListener(this);
	int i;
	pix=new Canvas();
	this.pix=pix;
	this.l=0;
	color=1;
	T[0]=new ListenTriangle();
	T[0]=T[0].triangle0();

	COL[1]=Color.red;
        COL[2]=Color.yellow;
        COL[3]=Color.blue;
	COL[4]=COL[1];
        COL[5]=COL[2];
        COL[6]=COL[3];
	border=0;length=6;
	T=T[0].sub(T,COL,0,0);


    }



    public void paint(Graphics gfx) {

      Graphics2D g=(Graphics2D) gfx;
      g.setRenderingHint(RenderingHints.KEY_ANTIALIASING,
                         RenderingHints.VALUE_ANTIALIAS_ON);

        g.setFont(new Font("Helvetica",Font.PLAIN,40));
        g.setColor(Color.yellow);
        g.drawString("Rich: Applet 15",10,40);
        g.setFont(new Font("Helvetica",Font.PLAIN,15));
        g.setColor(Color.white);
        g.drawString("Click/drag the mouse over the triangle(s)",10,70);
        g.drawString("to barycentrically subdivide",10,90);

	/*options*/
	g.setColor(Color.yellow);
	g.drawString("black outline?",20,117);
        g.drawString("refine",20,147);
        g.drawString("reset",20,177);
        g.drawString("change colors",20,207);

        g.setColor(Color.red);
	g.fillRect(130,100,20,20);
	g.setColor(Color.orange);   
        if(border==0) g.drawRect(130,100,20,20);
        g.setColor(Color.red);
	g.fillRect(130,130,20,20);
	g.setColor(Color.orange);
	g.drawRect(130,130,20,20);
        g.setColor(Color.red);
	g.fillRect(130,160,20,20);
	g.setColor(Color.orange);
	g.drawRect(130,160,20,20);
        g.setColor(Color.red);
	g.fillRect(130,190,20,20);
	g.setColor(Color.orange);
	g.drawRect(130,190,20,20);



	for(int i=1;i<=length;++i)	{
           if(T[i].dead==0) T[i].render(g,border);
	}
    }

    void refine() {
	int temp=length;
	if(temp<20000) {
	    for(int i=1;i<=length;++i) {
            T=T[i].sub(T,COL,i,temp);
	    temp=temp+6;
	    }
	    length=temp;
	}
    }

    void restart() {
	length=6;
            this.T=T[0].sub(T,COL,0,0);
    } 

    void colorChange() {

	int temp=0;
	if(this.color==1) {
        COL[1]=Color.red;
        COL[2]=Color.yellow;
        COL[3]=Color.orange;
	COL[4]=COL[1];
        COL[5]=COL[2];
        COL[6]=COL[3];
	temp=2;
	}

	if(this.color==2) {
        COL[1]=Color.black;
        COL[2]=Color.white;
        COL[3]=Color.red;
	COL[4]=COL[1];
        COL[5]=COL[2];
        COL[6]=COL[3];
	temp=3;
	}

	if(this.color==3) {
        COL[1]=Color.red;
        COL[2]=Color.yellow;
        COL[3]=Color.blue;
	COL[4]=COL[1];
        COL[5]=COL[2];
        COL[6]=COL[3];
	temp=1;
	}
	color=temp;


    }


    public void mouseReleased(MouseEvent e) {}
    public void mousePressed(MouseEvent e) {}
    public void mouseMoved(MouseEvent e) {}
    public void mouseEntered(MouseEvent e) {}
    public void mouseExited(MouseEvent e) {}



    public void mouseClicked(MouseEvent e) {

	Point y=new Point();
	int i;
	int val;
	e.consume();
	y.x=e.getX();
	y.y=e.getY();
	  val=T[0].locate(y,T,length);

	  if(val>=0) {
	    T=T[0].sub(T,COL,val,length);
	    length=length+6;
	    repaint(T[val].minx(),T[val].miny(),T[val].widx(),T[val].widy());
	    T[val].dead=1;
	  }

        if((y.x>130)&&(y.x<150)&&(y.y>100)&&(y.y<120)) {
	    border=1-border;repaint();
	}

        if((y.x>130)&&(y.x<150)&&(y.y>130)&&(y.y<150)) {
	    refine(); repaint();
	}

        if((y.x>130)&&(y.x<150)&&(y.y>160)&&(y.y<180)) {
	    restart(); repaint();
	}

        if((y.x>130)&&(y.x<150)&&(y.y>190)&&(y.y<210)) {
	    colorChange(); repaint();
	}
    }


    public void mouseDragged(MouseEvent e) {

	Point y=new Point();
	int i;
	int val;
	e.consume();
	y.x=e.getX();
	y.y=e.getY();
	  val=T[0].locate(y,T,length);

	  if(val>=0) {
	    T=T[0].sub(T,COL,val,length);
	    length=length+6;
	    repaint(T[val].minx(),T[val].miny(),T[val].widx(),T[val].widy());
	    T[val].dead=1;
	  }

    }




}





class DBCanvas extends Canvas {
    
    public void update(Graphics g) {
        Graphics g2;
        Image offscreen = null;
        offscreen = createImage(size().width, size().height);
        g2 = offscreen.getGraphics();
        paint(g2);
        g.drawImage(offscreen, 0, 0, this);
	g2.dispose();
	offscreen.flush();
    }
}





class ListenTriangle {
    double x1,x2,x3;
    double y1,y2,y3;
    int dead;
    Color C;

    ListenTriangle() {
      this.x1=x1;
      this.x2=x2;
      this.x3=x3;
      this.y1=y1;
      this.y2=y2;
      this.y3=y3;
      this.C=C;
      this.dead=dead;
    }
    
    int inside(Point p)
    {
	double v1x,v1y,v2x,v2y;
	double A1,A2,A3;
	int val;
	v1x=p.x-this.x1;
	v1y=p.y-this.y1;
	v2x=p.x-this.x2;
	v2y=p.y-this.y2;
	A3=v1x*v2y-v1y*v2x;
	v1x=p.x-this.x2;
	v1y=p.y-this.y2;
	v2x=p.x-this.x3;
	v2y=p.y-this.y3;
	A1=v1x*v2y-v1y*v2x;
	v1x=p.x-this.x3;
	v1y=p.y-this.y3;
	v2x=p.x-this.x1;
	v2y=p.y-this.y1;
	A2=v1x*v2y-v1y*v2x;
	val=0;
	if((A1<0)&&(A2<0)&&(A3<0)) val=1;
	if((A1>0)&&(A2>0)&&(A3>0)) val=1;
	return(val);
    }




    void render(Graphics g,int border) {
	    g.setColor(this.C);
	    Polygon P=new Polygon();
	    int x[]={(int)(this.x1),(int)(this.x2),(int)(this.x3)};
	    int y[]={(int)(this.y1),(int)(this.y2),(int)(this.y3)};
	    P.xpoints=x;
	    P.ypoints=y;
	    P.npoints=3;
	    g.fillPolygon(P);
	    g.setColor(Color.black);
	    if(border==0)            g.drawPolygon(P);

    }

    ListenTriangle triangle0() {
	ListenTriangle L=new ListenTriangle();
	L.x1=10.0;
	L.x2=400.0;
	L.x3=790.0;
	L.y1=590.0;
	L.y2=10.0;
	L.y3=590.0;
	L.C=Color.white;
	L.dead=0;
	return(L);
    }

    ListenTriangle sub1(ListenTriangle L, Color C) {
	ListenTriangle M=new ListenTriangle();
	M.x1=L.x1;
        M.y1=L.y1;
	M.x2=.5*L.x1+.5*L.x2;
        M.y2=.5*L.y1+.5*L.y2;
	M.x3=L.x1/3.0+L.x2/3.0+L.x3/3.0;
        M.y3=L.y1/3.0+L.y2/3.0+L.y3/3.0;
	M.C=C;
	M.dead=0;
	return(M);
    }

    ListenTriangle sub2(ListenTriangle L, Color C) {
	ListenTriangle M=new ListenTriangle();
	M.x1=L.x1;
        M.y1=L.y1;
	M.x2=.5*L.x1+.5*L.x3;
        M.y2=.5*L.y1+.5*L.y3;
	M.x3=L.x1/3.0+L.x2/3.0+L.x3/3.0;
        M.y3=L.y1/3.0+L.y2/3.0+L.y3/3.0;
	M.C=C;
	M.dead=0;
	return(M);
    }

    ListenTriangle sub3(ListenTriangle L, Color C) {
	ListenTriangle M=new ListenTriangle();
	M.x1=L.x3;
        M.y1=L.y3;
	M.x2=.5*L.x1+.5*L.x3;
        M.y2=.5*L.y1+.5*L.y3;
	M.x3=L.x1/3.0+L.x2/3.0+L.x3/3.0;
        M.y3=L.y1/3.0+L.y2/3.0+L.y3/3.0;
	M.C=C;
	M.dead=0;
	return(M);
    }

    ListenTriangle sub4(ListenTriangle L, Color C) {
	ListenTriangle M=new ListenTriangle();
	M.x1=L.x3;
        M.y1=L.y3;
	M.x2=.5*L.x2+.5*L.x3;
        M.y2=.5*L.y2+.5*L.y3;
	M.x3=L.x1/3.0+L.x2/3.0+L.x3/3.0;
        M.y3=L.y1/3.0+L.y2/3.0+L.y3/3.0;
        M.C=C;
	M.dead=0;
	return(M);
    }

    ListenTriangle sub5(ListenTriangle L, Color C) {
	ListenTriangle M=new ListenTriangle();
	M.x1=L.x2;
        M.y1=L.y2;
	M.x2=.5*L.x2+.5*L.x3;
        M.y2=.5*L.y2+.5*L.y3;
	M.x3=L.x1/3.0+L.x2/3.0+L.x3/3.0;
        M.y3=L.y1/3.0+L.y2/3.0+L.y3/3.0;
        M.C=C;
	M.dead=0;
	return(M);
    }

    ListenTriangle sub6(ListenTriangle L, Color C) {
	ListenTriangle M=new ListenTriangle();
	M.x1=L.x2;
        M.y1=L.y2;
	M.x2=.5*L.x2+.5*L.x1;
        M.y2=.5*L.y2+.5*L.y1;
	M.x3=L.x1/3.0+L.x2/3.0+L.x3/3.0;
        M.y3=L.y1/3.0+L.y2/3.0+L.y3/3.0;
        M.C=C;
	M.dead=0;
	return(M);
    }

    int locate(Point p,ListenTriangle T[],int n) {
	int i,val,test;
	val=-1;
	for(i=0;i<=n;++i) {
	    test=T[i].inside(p);
	    if((test==1)&&(T[i].dead==0)) val=i;
	}
	return(val);
    }

    ListenTriangle[] sub(ListenTriangle[] T,Color COL[],int val,int n) {
	ListenTriangle S[];
	int i,nn;
	S=T;
	S[n+1]=T[val].sub1(T[val],COL[1]);
        S[n+2]=T[val].sub2(T[val],COL[2]);
        S[n+3]=T[val].sub3(T[val],COL[3]);
        S[n+4]=T[val].sub4(T[val],COL[4]);
        S[n+5]=T[val].sub5(T[val],COL[5]);
        S[n+6]=T[val].sub6(T[val],COL[6]);
	return(S);
    }

    int minx() {
	double x=1000.0;
	if(x>this.x1) x=this.x1;
        if(x>this.x2) x=this.x2;
        if(x>this.x3) x=this.x3;
	return((int)(x));
    }

    int miny() {
	double y=1000.0;
	if(y>this.y1) y=this.y1;
        if(y>this.y2) y=this.y2;
        if(y>this.y3) y=this.y3;
	return((int)(y));
    }


    int maxx() {
	double x=-1000.0;
	if(x<this.x1) x=this.x1;
        if(x<this.x2) x=this.x2;
        if(x<this.x3) x=this.x3;
	return((int)(x));
    }

    int maxy() {
	double y=-1000.0;
	if(y<this.y1) y=this.y1;
        if(y<this.y2) y=this.y2;
        if(y<this.y3) y=this.y3;
	return((int)(y));
    }

    int widx() {
	return(this.maxx()-this.minx());
    }

    int widy() {
	return(this.maxy()-this.miny());
    }


}

    
