import java.applet.Applet;
import java.awt.event.*;
import java.awt.*;
import java.awt.geom.*;


public class CombinatorialTriangle extends ListenTriangle {
    int parity;
    int[] a=new int[3];
    int[] b=new int[3];
    int[] c=new int[3];
    int[][] d=new int[3][2];
    int[][] e=new int[2][2];


    public CombinatorialTriangle() {}
    public CombinatorialTriangle(int[] a,int[] b,int[] c,int[][] d,int[][] e,int parity) {
      this.a=a;
      this.b=b;
      this.c=c;
      this.d=d;
      this.e=e;
      this.parity=parity;
    }

    /**c[0] describes the digit*/
    /**c[1] describes the top       vertex value*/
    /**c[2] describes the bottom vertex value*/
    /**b[0] b[1] b[2] describe the hexagonal coordinates for the wordpath*/
    /**d is derived from b and describes the turning angles of the edges*/
    /**e is used to compute the spines*/

    public static CombinatorialTriangle copy(CombinatorialTriangle X) {
	CombinatorialTriangle T=new CombinatorialTriangle();
	for(int i=0;i<3;++i) {
	    T.a[i]=X.a[i];
	    T.b[i]=X.b[i];
	    T.c[i]=X.c[i];
	}
	for(int i=0;i<3;++i) {
	    for(int j=0;j<2;++j) {
		T.d[i][j]=X.d[i][j];
	    }}

	T.parity=X.parity;
	return(T);
    }

    public static CombinatorialTriangle combinatorialInit(int[] j) {
	CombinatorialTriangle T=new CombinatorialTriangle();
	T.a[0]=0;
	T.a[1]=0;
	T.a[2]=0;
        T.b[(j[1]+0)%3]=0;
        T.b[(j[1]+1)%3]=-1;   
        T.b[(j[1]+2)%3]=+1;
        T.c[0]=j[1];
        T.c[1]=1;
        T.c[2]=1;
	T.parity=1;
	return(T);
    }



    /**reflects in the jth edge for j=0,1,2*/

    public CombinatorialTriangle combinatorialReflect(int[] j,int i) {
      CombinatorialTriangle S=new CombinatorialTriangle();
  
      int q=2;
      if(i%2==1) q=-2;
      int temp=(j[1]-1)%3;
      if(temp<0) temp=temp+3;

      S=new CombinatorialTriangle();
      S.history=j[1];
      S.b[(j[1]+0)%3]=this.b[(j[1]+0)%3];
      S.b[(j[1]+1)%3]=this.b[(j[1]+1)%3]+q;
      S.b[(j[1]+2)%3]=this.b[(j[1]+2)%3]-q;
      S.c[0]=j[1];
      S.c[2]=this.c[2];
      S.c[1]=this.c[1];

      int d=j[1]-j[0];
      if(d<1) d=d+3;
      int e=(i+d)%2;
      if(i>0) ++S.c[e+1];
      S.parity=-this.parity;

      for(int sp=0;sp<3;++sp) {
	  S.a[sp]=0;
          if((j[1]!=sp)&&(j[2]!=sp)) S.a[sp]=1;
          if((j[1]==sp)&& (j[0]!=j[2])) S.a[sp]=1;
      }

      for(int sp=0;sp<3;++sp) {
        int[] m=new int[3];
        m[sp]=S.b[sp];
        m[(sp+1)%3]=S.b[(sp+1)%3]+S.parity;
        m[(sp+2)%3]=S.b[(sp+2)%3]-S.parity;
        S.d[sp][0]=-(m[2]-m[0])/3;
        S.d[sp][1]=-(m[2]-m[1])/3;
      }
      return(S);
    }
    
    public void print() {
	System.out.println("combinatorial data");
	System.out.println(this.b[0]+" "+this.b[1]+" "+this.b[2]);
	System.out.println(this.c[0]+" "+this.c[1]+" "+this.c[2]);
    }

    
    public  static CombinatorialTriangle[] unfold(String W) {
        
        CombinatorialTriangle[] T1=new CombinatorialTriangle[1001];
        String S=new String();
        int n=W.length();
        
        if(n>1) {
            S=W.substring(0,1);
            int[] m=Spine.getTriple(W,0);
            T1[0]=CombinatorialTriangle.combinatorialInit(m);
            
            for(int i=0;i<=n;++i) {
                m=Spine.getTriple(W,i);
                T1[i+1]=T1[i].combinatorialReflect(m,i);
            }
        }
	T1[0].c[0]=W.length();
        return(T1);
    }


}