import java.applet.Applet;
import java.awt.event.*;
import java.awt.*;
import java.awt.geom.*;






/*This is the control panel canvas.  It is
  the most complicated part of the applet.*/


public class ControlCanvas extends DBCanvas implements MouseListener {
    ListenSquare[] L=new ListenSquare[16];
    ListenSquare[] M=new ListenSquare[290];
    ListenSquare[] V=new ListenSquare[10];
    ListenTriangle[] A=new ListenTriangle[3];
    PictureCanvas P;
    int select;
    double overfill,shift;
    int mouse3;
    WordIcon WI;

  public ControlCanvas(PictureCanvas P) { 
      this.P=P;
      overfill=1.0;
      mouse3=0;
      addMouseListener(this);
      setBackground(new Color(80,0,80));
      Color col2=Color.yellow;
      defineControls();
      defineVertexBoxes();
      defineSeries0(col2);
      defineSeries1(col2);
      defineSeries2(col2);
      defineSeries3(col2);
      defineSeries4(col2);
      defineSpecialPolygons(new Color(50,100,255));
      WI=new WordIcon(133,361,188,107,"",1);
  }


  public void paint(Graphics gfx) {   


      Graphics2D g=(Graphics2D) gfx;

      g.setRenderingHint(RenderingHints.KEY_ANTIALIASING,
                         RenderingHints.VALUE_ANTIALIAS_ON);

   drawTiles(g);

   g.setColor(Color.black);
   g.fillRect(131,342,193,128);
   g.setColor(new Color(200,0,200));
   g.drawRect(131,342,193,128);
   WI.W=P.U.W;
   if(L[15].on==1) iconRender(g);
   if(L[15].on==0) wordRender(g);


   int index=P.getIndex();
   if(index>0) drawVertices(-66,60,index,g);  
   drawControls(g);
   drawMouse(g);
  drawScalingConsole(0,350,g);   //clipping is done here


  }




       public void iconRender(Graphics2D g) {
            Color C1=new Color(60,0,0);
            Color C2=new Color(60,0,0);
            Color C3=new Color(255,0,0);
            Color C4=Color.yellow;
            Color C5=Color.yellow;  
            Color C6=new Color(0,0,60);
            Color C7=new Color(0,0,60);
            Color C8=new Color(0,0,255); 
            Color C9=new Color(0,60,0);
            Color C10=new Color(0,60,0);
            Color C11=new Color(0,255,0);
	    WI.pathRender(g,C1,C2,C3,C4,C5,C6,C7,C8,C9,C10,C11);
	}

       public void wordRender(Graphics2D g) {
	   String aA=WI.W;   
	   int len=aA.length();
           g.setColor(Color.white);
           g.setFont(new Font("Helvetica",Font.PLAIN,12));
	   Integer Len=new Integer(len);
	   g.drawString(Len.toString(),134,357);

           g.setFont(new Font("Monospaced",Font.PLAIN,10));
	   int a=133;
	   int b=377;
	   for(int i=0;i<len;++i) {
	       int j=i+1;
	       if(i%4==0) a=a+3;
	       String AA=aA.substring(i,j);
	       g.drawString(AA,a,b+1);
	       if(j%32==0) {b=b+12;a=133;}
	       if(j%32!=0) a=a+5;
	   }
	}



  public void mousePressed(MouseEvent e) {}   
  public void mouseReleased(MouseEvent e) {}
  public void mouseEntered(MouseEvent e) {}
  public void mouseExited(MouseEvent e) {}
  public void mouseClicked(MouseEvent e) {
      Point X=new Point();
      e.consume();
      X.x=e.getX();
      X.y=e.getY();

      if(overfill>1) shiftUnfold(X);

      int test=whichControl(X);
      if(test==15) L[15].on=1-L[15].on;
      if((test==13)||(test==14)) changeMouse(test);
      if((test<13)&&(test>=7)) changeUnfold(test);
      if((test==5)||(test==6)) changeSelect(test);
      if(test==4) doReset();

      if((test>=1)&&(test<=3)) changeScaling(test);

      if(test!=4) {
        int test2=select;
        if(test==0)  test2=whichPolygon(X);
        if(test2>=1) select=test2;

        if(select>=1) {
	   int test3=whichVertex(X);
           if(test3>=0) V[test3].on=1;
           if(select>=1) P.selectFit(test3);
	}
      }

      P.repaint();
      P.W.repaint();
      P.U.repaint();
      repaint();
  }


    public void shiftUnfold(Point X) {
      if(A[1].inside(X)==1) shift=shift-500;
      if(A[2].inside(X)==1) shift=shift+500;
      if(shift<0) shift=0;
      if(shift>990*overfill-990) shift=990*overfill-990;
    }



   public int whichVertex(Point X) {
      int nv=P.P[select].n;
      int test3=-1;
      for(int i=0;i<nv;++i) {
	  V[i].on=0;
	  if(V[i].inside(X)==1) test3=i;
      }
      return(test3);
   }


    

  public int whichPolygon(Point X) {
      int test2=0;

      for(int i=1;i<=P.N;++i) {
	  if(M[i].inside(X)==1) test2=i;
      }  
      //switching 1 and 3
      int temp=test2;
      if(test2==1) temp=3;
      if(test2==3) temp=1;
      test2=temp;



      //highlight selection
      if(test2>=1) {
      for(int i=1;i<=P.N;++i)  M[i].on=0;
      M[test2].on=1;
      P.C.shift=0;
      }

      //turn off vertices
      for(int j=0;j<8;++j) V[j].on=0;
      return(test2);
  }


  public int whichControl(Point X) {
      int test=0;
      for(int i=1;i<=15;++i) {
	  if(L[i].inside(X)==1) test=i;
      }
      return(test);
  }

    public void changeUnfold(int test) {
      if(test==7) {P.U.show=1-P.U.show;L[7].on=1-L[7].on;}
      if(test>=8) {
	  for(int j=8;j<=12;++j) L[j].on=0;
	  L[test].on=1;
	  P.U.mode=test-7;
	  P.C.shift=0;
      }
    }


    public void changeMouse(int test) {
	L[13].on=0;
	L[14].on=0;
	L[test].on=1;
	if(test==13) {
            mouse3=0;
	    P.mode[1]=1;
	    P.mode[2]=0;
	    P.mode[3]=0;
	    L[1].on=1;
	    L[2].on=0;
	    L[3].on=0;
	}
	if(test==14) mouse3=1;
    }





    public void changeSelect(int test) {

       L[test].on=1-L[test].on;
       P.mode[test]=1-P.mode[test];



       if((test==6)&&(L[6].on==0)) {
	  L[5].on=0;
	  P.mode[5]=0;
       }


       if((test==5)&&(L[5].on==1)) {
	  L[6].on=1;
	  P.mode[6]=1;
	  if(select>=7) P.selectFit(-1);
       }


       if(L[6].on==1) {
           L[1].on=1;
	   L[2].on=0;
	   L[3].on=0;
           L[4].on=0;  
           P.mode[2]=0;
	   P.mode[3]=0;
	   P.mode[4]=0;
       }

    }



    public void changeScaling(int test) {
	if(mouse3==0) {
	  L[1].on=0;
          L[2].on=0;
          L[3].on=0;
          L[5].on=0;
	  P.mode[1]=0;
          P.mode[2]=0;
          P.mode[3]=0;
          P.mode[5]=0;

	  L[test].on=1;
	  P.mode[test]=1;
	}
    }



      public void doReset() {
	  P.A=1;P.Bx=0;P.By=0;P.S=0;
	  P.U.XPOS=0.5;
	  P.U.YPOS=0.5;
	  P.XPOS=256;
	  P.YPOS=256;
          P.mode[3]=0;P.mode[2]=0;
	  overfill=1;
	  P.U.overfill=0;
	  shift=0;
      }





    public void wordLengthDraw(Graphics2D g,String S,int x,int y) {
        g.setFont(new Font("Helvetica",Font.PLAIN,20)); 
	int n=S.length(); 
	Integer I=new Integer(0);
	g.setColor(Color.white);
	g.drawString(I.toString(n),x,y);
   }



   public void drawMouse(Graphics g) {

  for(int i=13;i<=15;++i) L[i].render(g,new Color(0,0,255));
  if(mouse3==0) {
      for(int i=1;i<=3;++i) L[i].render(g,new Color(0,0,255));
  }

 g.setColor(Color.white);
      g.setFont(new Font("Helvetica",Font.PLAIN,12)); 
      g.drawString("button",211,488);
      g.drawString("mouse",211,500);
      g.drawString("1",196,487);
      g.drawString("3",196,504); 
      if(mouse3==0) {
        g.drawString("+ ",268,494);
        g.drawString("0",287,494);
        g.drawString("-",306,494);
      }
   }




   public void drawControls(Graphics g) {
       g.setColor(Color.black);
       g.fillRect(3,472,320,39);
       g.setColor(new Color(255,0,255));
       g.drawRect(3,472,320,39);
   
      for(int i=1;i<=3;++i) L[i].render(g,new Color(130,0,130));
      for(int i=5;i<=6;++i) L[i].render(g,new Color(130,0,130));
      for(int i=7;i<=12;++i) L[i].render(g,new Color(0,100,100));
    
      g.setFont(new Font("Helvetica",Font.PLAIN,10));  
      g.setColor(Color.white);
      g.drawString("select tile",72, 503);
      g.drawString("fit",104, 486);
      g.drawString("show path",9, 486);

      if(overfill>1) {
      A[1].render(g,Color.black,new Color(0,200,200));
      A[2].render(g,Color.black,new Color(0,200,200));
      }

    
   }




 public void drawTiles(Graphics g) {
     Color CC=new Color(200,0,200);
     ListenSquare[] X=new ListenSquare[10];
        X[1]=new ListenSquare(3,5,125,56,CC);   
        X[2]=new ListenSquare(3,66,125,51,CC);  
        X[3]=new ListenSquare(3,122,125,51,CC); 
        X[4]=new ListenSquare(3,178,125,51,CC);   
        X[5]=new ListenSquare(3,234,125,51,CC);  
        X[6]=new ListenSquare(3,290,125,50,CC);
	X[7]=new ListenSquare(131,5,94,44,CC);	
        X[8]=new ListenSquare(228,5,96,335,CC);   
        X[9]=new ListenSquare(131,52,94,288,CC); 	
	for(int i=1;i<=9;++i) X[i].render(g,new Color(200,0,20));
   g.setFont(new Font("Helvetica",Font.PLAIN,10));  
	g.setColor(Color.white);

     Integer II=new Integer(select);
   if((select>0)&&(select<=221)) {
     g.drawString("interior tiles",140,65);
     g.drawString("vertices of P"+II.toString(),230,18);
   }

   if(select>=222) {
     g.drawString("interior tiles",140,65);
     g.drawString("vertices of tile "+II.toString(),230,18);
   }



   g.drawString("interior tiles",140,65);
   g.drawString("...",106,133);
   g.drawString("...",106,148);
   g.drawString("...",106,303);
   g.drawString("...",106,318);
   g.drawString("P1",85,57);
   g.drawString("P1",85,113);
   g.drawString("covers P3",52,169);
   g.drawString("covers P4",52,225);
   g.drawString("covers P5",52,281);
   g.drawString("covers P6",52,337);


     for(int i=1;i<=6;++i) {if(M[i].on==0) M[i].renderRed(g,M[i].C);}
     for(int i=7;i<=221;++i) {if(M[i].on==0) M[i].renderMagenta(g,M[i].C);}
     for(int i=222;i<=268;++i) {if(M[i].on==0) M[i].renderCyan(g,M[i].C);}
     for(int i=1;i<=6;++i) {if(M[i].on==1) M[i].renderRed(g,M[i].C);}     
     for(int i=7;i<=221;++i) {if(M[i].on==1) M[i].renderMagenta(g,M[i].C);}  
     for(int i=222;i<=268;++i) {if(M[i].on==1) M[i].renderCyan(g,M[i].C);}


   //labels
   g.setFont(new Font("Helvetica",Font.PLAIN,12)); 
   g.setColor(Color.white);


 }

   public void drawVertices(int x,int y,int ind, Graphics g) {

    int nn=P.P[ind].n;
    int tt=P.P[ind].type;
    Integer I=new Integer(0);

    for(int i=0;i<nn;++i) V[i].render2(g);

    g.translate(x,y);
    g.setFont(new Font("Helvetica",Font.PLAIN,10)); 

    for(int i=0;i<nn;++i) {  

	  if(tt==1) {
	    g.setColor(Color.white);
            g.drawString(I.toString(P.P[ind].k1[i]),300,254-38*i);
	    g.drawString(I.toString(P.P[ind].n1[i]),312,267-38*i);
	    g.setColor(new Color(200,0,200));
	    g.drawLine(300,257-38*i,330,257-38*i);
            g.drawString("2",306,273-38*i); 

	    g.translate(52,0);
	    g.setColor(Color.white);
            g.drawString(I.toString(P.P[ind].k2[i]),300,254-38*i);
	    g.drawString(I.toString(P.P[ind].n2[i]),312,267-38*i);
	    g.setColor(new Color(200,0,200));
	    g.drawLine(300,257-38*i,330,257-38*i);
            g.drawString("2",306,273-38*i);
	    g.translate(-52,0);
	  }

	  if(tt==2) {
            g.setColor(Color.white);
            g.drawString(I.toString(P.P[ind].k1[i]),300,254-38*i);
	    g.drawString(I.toString(P.P[ind].n1[i]),300,267-38*i);
	    g.setColor(new Color(200,0,200));
	    g.drawLine(300,257-38*i,330,257-38*i);

	    g.translate(52,0);
            g.setColor(Color.white);
            g.drawString(I.toString(P.P[ind].k2[i]),300,254-38*i);
	    g.drawString(I.toString(P.P[ind].n2[i]),300,267-38*i);
	    g.setColor(new Color(200,0,200));
	    g.drawLine(300,257-38*i,330,257-38*i);
	    g.translate(-52,0);
	  }

	  if(tt==3) {
	     g.setColor(Color.white);
	     P.U.shortDoubleRender(P.P[ind].x[i]/512.0,g,282,256-38*i);
	     g.translate(50,0);
	     P.U.shortDoubleRender(P.P[ind].y[i]/512.0,g,282,256-38*i);
	     g.translate(-50,0);
	  }
    }


    g.setFont(new Font("Helvetica",Font.PLAIN,12));

    if(tt==3) {
       g.setColor(new Color(255,0,255));
       g.drawString("Vertices are",300,32); 
       g.drawString("not rational",300,47);  
       g.drawString("multiples",300,62); 
       g.drawString("of Pi/2.",300,77); 
    }

    g.translate(-x,-y);
   }

   

   public void drawScalingConsole(int x,int y,Graphics g) {


    g.setFont(new Font("Helvetica",Font.PLAIN,10));


      L[4].render(g,new Color(0,50,225));

      g.setColor(new Color(50,150,255));
      g.setColor(Color.white);
      g.drawString("reset",70,486);
      if(L[15].on==0) g.drawString("mode 2: word",175,355);
      if(L[15].on==1) g.drawString("mode 1: hexpath",175,355);

      if(overfill>1) {
       int lim =(int)(317/overfill);
       int lim2=(int)(317*shift/(overfill*980));
       g.setColor(Color.white);
       g.drawRect(3+lim2,509,lim,0);
      }


       g.translate(x,y-8);



      /*scale level*/
      g.setColor(new Color(100,0,100));
      for(int i=-3;i<=20;++i) {
	  g.drawRect(-8,19+5*i,5,5);
      }
      g.fillRect(-8,19,5,5);
      g.setColor(Color.white);
      g.fillRect(-8,19+5*P.S,5,5);


      /*small copy of PictureCanvas*/
      int X1[]={0,0,114,128};
      int Y1[]={128,114,0,0};
      int X2[]={0,0,128};
      int Y2[]={128,0,0};
      int X3[]={64,0,128};
      int Y3[]={64,0,0};


      for(int i=0;i<4;++i) Y1[i]=128-Y1[i];
      for(int i=0;i<3;++i) Y2[i]=128-Y2[i];
      for(int i=0;i<3;++i) Y3[i]=128-Y3[i];

      g.setColor(new Color(60,0,60));
      g.fillRect(0,0,128,128);


      g.setColor(new Color(40,0,110));
      g.fillPolygon(X2,Y2,3);  
      g.setColor(new Color(0,200,200));
      g.drawPolygon(X2,Y2,4); 



      g.setColor(Color.black);
      g.fillPolygon(X1,Y1,4);  
      g.setColor(new Color(0,200,200));
      g.drawPolygon(X1,Y1,4); 



      g.setColor(new Color(40,0,110));
      g.fillPolygon(X3,Y3,3);  
      g.setColor(new Color(0,200,200));
      g.drawPolygon(X3,Y3,4); 



      /*draw view window*/
      g.clipRect(0,0,129,129);
      g.setColor(new Color(200,0,200));

      g.drawRect(0,0,128,128);
      double x1=0;
      double y1=0;
      double r=128;
      x1=(x1-P.Bx/4)/P.A;
      y1=(y1-P.By/4)/P.A;
      r=r/P.A;
      g.setColor(new Color(50,255,50));
      g.drawRect((int)(x1),(int)(y1),(int)(r),(int)(r));


      g.translate(-x,-y+8);
 
      }





    public void  defineVertexBoxes () {
      for(int i=0;i<=7;++i) 
      V[i]=new ListenSquare(231,301-38*i,90,35,new Color(255,0,255));
    }


      public void defineControls() {
        Color col2=new Color(50,150,255);
        select=0;

      
        L[4]=new ListenSquare(62,474,35,16,col2);  //reset
      
        L[15]=new ListenSquare(160,346,11,11,col2);  //word mode
	L[15].on=1;

        col2=new Color(200,0,200);
        L[5]=new ListenSquare(101,474,19,16,col2);  //fit
        L[6]=new ListenSquare(62,492,58,15,col2);  //select tile


        col2=new Color(0,200,200);
        L[7]=new ListenSquare(5,474,55,16,col2);  //show path button

	for(int i=0;i<=4;++i) {
        L[8+i]=new ListenSquare(6+10*i,494,10,10,col2);
	}

        col2=new Color(0,0,255);
	L[13]=new ListenSquare(190,474,16,16,col2); //mouse choice
	L[14]=new ListenSquare(190,492,16,16,col2); //mouse choice
	L[13].on=1;
        L[2]=new ListenSquare(262,481,16,16,col2);  //zoom
        L[1]=new ListenSquare(281,481,16,16,col2); //zoom
        L[3]=new ListenSquare(300,481,16,16,col2); //zoom
        L[1].on=1;  
        L[8].on=1;

        A[1]=new ListenTriangle();
        A[1].z[0].x=5;
        A[1].z[0].y=12;
        A[1].z[1].x=20;
        A[1].z[1].y=20;
        A[1].z[2].x=20;
        A[1].z[2].y=4;

        A[2]=new ListenTriangle();
        A[2].z[0].x=41;
        A[2].z[0].y=12;
        A[2].z[1].x=26;
        A[2].z[1].y=20;
        A[2].z[2].x=26;
        A[2].z[2].y=4;

	Complex z=new Complex(130.0,479.0);
	A[1]=A[1].scale(z,1.0);
	A[2]=A[2].scale(z,1.0);


      }


    //boundary markings  


      public void defineSpecialPolygons(Color col) {  
        for(int i=1;i<=6;++i) {
	   M[i]=new ListenSquare(108,-10+56*i,12,col);
	}

	//not used
	M[0]=new ListenSquare(-1,-1,0,0,Color.white);

      }


    //generic tiles

    public void defineSeries0(Color col) {  
      int a=0;
      int b=0;
      for(int i=-8;i<=18;++i) {
	  a=(int)(Math.floor(i/8.0));
	  b=i-a*8;
	   M[i+15]=new ListenSquare(134+11*b,21+11*a,11,col);
      }

      for(int i=16;i<=213;++i) {
	  a=(int)(Math.floor(i/8.0));
	  b=i-a*8;
	   M[i+14]=new ListenSquare(134+11*b,50+11*a,11,col);
      }
    }



      //Pi/4 series of tiles
   public void defineSeries1 (Color col) {
      M[222]=new ListenSquare(8,202,24,col);
      for(int i=1;i<=3;++i) {
      M[222+i]=new ListenSquare(-4+12*i,181,12,col);
      }
      for(int i=0;i<=2;++i) {
      M[225+i]=new ListenSquare(8+12*i,193,12,col);
      }
   }



      //Pi/5 series of tiles
   public void defineSeries2(Color col) {
      for(int i=0;i<=1;++i) {
      M[227+i]=new ListenSquare(8,256+12*i,12,col);
      }
   
   }



      //Pi/6 series of tiles
   public void defineSeries3(Color col) {
      for(int i=0;i<=9;++i) {
      M[249+i]=new ListenSquare(8+9*i,297,9,col);
      }

      for(int i=0;i<=9;++i) {
      M[259+i]=new ListenSquare(8+9*i,312,9,col);
      }
   
   }



    //0 series of tiles
    public void defineSeries4(Color col) {
      for(int i=0;i<=9;++i) {
      M[229+i]=new ListenSquare(8+9*i,127,9,col);
      }

      for(int i=0;i<=9;++i) {
      M[239+i]=new ListenSquare(8+9*i,142,9,col);
      }
    }
    




}


