import java.applet.Applet;
import java.awt.event.*;
import java.awt.*;


/**this class keeps track of how a 
  given line segment intersects
  the bounding box.  The box is set to
  have height and width 512*/



public class IntersectData {
    Vector3[] V=new Vector3[5];
    int n;

    public IntersectData() {
	this.V[1]=new Vector3(0,0);
	this.V[2]=new Vector3(0,0);
	this.n=0;
    }

    public IntersectData getIntersectData(Vector3 A,Vector3 B) {
	IntersectData I=new IntersectData();
	Vector3 NW=new Vector3(0.0000000001,0.0000000001);
	Vector3 NE=new Vector3(512.000000001,0.0000000001);	
        Vector3 SE=new Vector3(512.000000001,512.000000001);
	Vector3 SW=new Vector3(0.00000000001,512.000000001);
	Vector3 N=NW.getIntersect(A,B,NE,NW);
	Vector3 S=SE.getIntersect(A,B,SE,SW);
	Vector3 E=NE.getIntersect(A,B,NE,SE);
	Vector3 W=SW.getIntersect(A,B,SW,NW);


	int count=0;


	if(N.n==1) {
	    ++count;
	    I.V[count]=N;
	    I.V[count].side=3;
	}


	if(S.n==1) {
	    ++count;
	    I.V[count]=S;
	    I.V[count].side=7;
	}


	if(E.n==1) {
	    ++count;
	    I.V[count]=E;
	    I.V[count].side=1;
	}

	if(W.n==1) {
	    ++count;
	    I.V[count]=W;
	    I.V[count].side=5;
	}
	if(count>2) {I.n=-1;return(I);}

	I.n=count;
	if((count==2)&&(I.V[1].t>I.V[2].t)) {
	    I.V[0]=new Vector3(I.V[2].x,I.V[2].y);
	    I.V[0].side=I.V[2].side;
	    I.V[2]=new Vector3(I.V[1].x,I.V[1].y);
            I.V[2].side=I.V[1].side;
	    I.V[1]=new Vector3(I.V[0].x,I.V[0].y);
            I.V[1].side=I.V[0].side;
	}
	return(I);
    }
}


