import java.applet.Applet;
import java.awt.event.*;
import java.awt.*;

public class PictureCanvas extends DBCanvas implements MouseListener {

    ControlCanvas C;
    ExplainCanvas W;
    UnfoldCanvas U;
    Deg100Data D;
    Deg100Polygon[] P;  
    Deg100Polygon D100;
    int[] mode=new int[20];
    double A,Bx,By; //scaling Ax+B
    int N,S,XPOS,YPOS;


  public PictureCanvas() { 
    addMouseListener(this);
    setBackground(new Color(50,0,50));
    P=new Deg100Polygon[270];
    for(int i=2;i<=8;++i) mode[i]=0;
    A=1;
    Bx=0;
    By=0;
    S=0;

    this.W=W;
    D=new Deg100Data();
    N=D.N;
    for(int i=1;i<=D.N;++i) P[i]=D.P[i];
  }


    public PictureCanvas addCanvas(ControlCanvas C,ExplainCanvas W,UnfoldCanvas U) {
	PictureCanvas Q=this;
	Q.C=C;
	Q.W=W;
	Q.U=U;
	return(Q);
    }



    public int getIndex() {
	int test=0;
	for(int i=1;i<=N;++i) {
	    if(P[i].on==1) test=i;
	}
	return(test);
    }


  public void paint(Graphics gfx) {   
         /**draw Deg100Polygons**/


      Graphics2D g=(Graphics2D) gfx;

      g.setRenderingHint(RenderingHints.KEY_ANTIALIASING,
                         RenderingHints.VALUE_ANTIALIAS_ON);


      for(int i=1;i<=6;++i) P[i].render=1;

      //drawing the polygons
      for(int i=N;i>=1;--i) 	{
                P[i].render(g,A,Bx,By);
      }
      for(int i=N;i>=N-41;--i) 	{
                P[i].render(g,A,Bx,By);
      }

      for(int i=N;i>=N-19;--i) 	{
                P[i].render(g,A,Bx,By);
      }

      for(int i=1;i<=N;++i) 	{
      if(P[i].on==1) P[i].render(g,A,Bx,By);}

      //frame + cursor

      g.setColor(new Color(255,0,255));
      g.drawRect(0,0,511,511);
      g.setColor(new Color(255,255,0));
      g.fillRect(XPOS-2,512-YPOS-2,4,4);

      }


    public void Button3(int button) {

	if(C.mouse3==1) {
	if(button==1) {
	    mode[1]=0;
	    mode[2]=1;
	    mode[3]=0;
	}
	if(button==2) {
	    mode[1]=1;
	    mode[2]=0;
	    mode[3]=0;
	}
	if(button==3) {
	    mode[1]=0;
	    mode[2]=0;
	    mode[3]=1;
	}
	}
    }

  /**mouse event methods**/
  public void mousePressed(MouseEvent e) {}   //same remarks as for applet 4
  public void mouseReleased(MouseEvent e) {}
  public void mouseEntered(MouseEvent e) {}
  public void mouseExited(MouseEvent e) {}
  public void mouseClicked(MouseEvent e) {


      Point X=new Point();
      Point RX=new Point();  //reflected point
      e.consume();

      X.x=e.getX();
      X.y=e.getY();
      RX.x=e.getX();
      RX.y=512-e.getY();



      XPOS= RX.x;
      YPOS= RX.y;
      double u=Math.sqrt(2.0);

      int button=0;
      if(e.getButton()==MouseEvent.BUTTON1) button=1;
      if(e.getButton()==MouseEvent.BUTTON2) button=2;
      if(e.getButton()==MouseEvent.BUTTON3) button=3;

      Button3(button);


      if((S<20)&&(mode[2]==1)) {
	  A=u*A;
	  ++S;
	  Bx=u*Bx-(u-1)*X.x;
	  By=u*By-(u-1)*X.y;
      }


      if((S>-3)&&(mode[3]==1)) {
	  A=A/u;
	  --S;
	  Bx=(Bx+(u-1)*X.x)/u;
	  By=(By+(u-1)*X.y)/u;
      }




      if(mode[6]==1) {
        int t=0;
        Color col=new Color(80,170,255);


	/*having multiple lines like this gives the
          effect of ordering the tiles somewhat.*/

        for(int i=7;i>=1;--i) {
	  if((P[i].type>0)&&(P[i].inside(X,A,Bx,By))==1) t=i;
	}

        for(int i=N;i>=7;--i) {
	  if((P[i].type>0)&&(P[i].inside(X,A,Bx,By))==1) t=i;
	}


        for(int i=N;i>=N-41;--i) {
	  if((P[i].type>0)&&(P[i].inside(X,A,Bx,By))==1) t=i;
	}


        for(int i=N;i>=N-9;--i) {
	  if((P[i].type>0)&&(P[i].inside(X,A,Bx,By))==1) t=i;
	}


        for(int i=N;i>=1;--i) {
	  if((P[i].on==1)&&(P[i].inside(X,A,Bx,By)==1)) t=i;
	}

        if(t>0) {
	    C.select=t;
	    for(int j=0;j<8;++j) C.V[j].on=0;
	    selectFit(-1);
	}}

      if(mode[5]==0) {
      U.XPOS=(X.x-Bx)/(512*A);
      U.YPOS=1-(X.y-By)/(512*A);
      }

      repaint();
      C.repaint();
      W.repaint();
      U.repaint();
  }






   public void selectFit(int vv) {
       int t=C.select;

       U.W=P[t].W;
       for(int i=1;i<=N;++i) {
       C.M[i].on=0;
       P[i].on=0;
       }
       C.M[t].on=1;
       P[t].on=1;

       /*AX,AY computes the average*/
       /*mx,my,Mx,My computes bounding box */

            double AX=0;
	    double AY=0;  
            double ss=0;
	    double tt=0;

	if(mode[5]==1) {
	    double mx=1000000;
	    double my=1000000;
	    double Mx=-1000000;
	    double My=-1000000;
	    double xx=0;
	    double yy=0;
	    double MM=0;
	  

	    for(int q=0;q<P[t].n;++q) {
	    ss=P[t].x[q];
	    tt=512-P[t].y[q];
	    if(mx>ss) mx=ss;
	    if(Mx<ss) Mx=ss;
	    if(my>tt) my=tt;
	    if(My<tt) My=tt;
	    }

	    MM=(Mx-mx);
	    if(MM<My-my) MM=My-my;
	    MM=2.0*Math.log(MM)/Math.log(2);
	    MM=Math.floor(17-MM);
	    if(MM>20) MM=20;
	    xx=(Mx+mx)/2;
	    yy=(My+my)/2;
	    S=(int)(MM);
	    A=Math.pow(2.0,MM/2.0);
	    Bx=-A*xx+256.0;
	    By=-A*yy+256.0;

	    /*point selection*/
	    AX=0;
	    AY=0;

	    if(vv==-1) {
            for(int q=0;q<P[t].n;++q) {
	    ss=P[t].x[q];
	    tt=P[t].y[q];
	    AX=AX+ss/512.0;
	    AY=AY+tt/512.0; }
            AX=AX/P[t].n;
	    AY=AY/P[t].n; 
	    }

	    if(vv>=0) {
	    AX=P[t].x[vv]/512.0;
	    AY=P[t].y[vv]/512.0;
	    }
	    /*end point selection*/

	    U.XPOS=AX;
	    U.YPOS=AY;
	    XPOS=(int)(512*A*AX+Bx);
	    YPOS=(int)(512*A*(1-AY)+By);
	    YPOS=512-YPOS;
	}

	if((mode[5]==0)&&(vv>=0)) {
            AX=P[t].x[vv]/512.0;
	    AY=P[t].y[vv]/512.0;
            U.XPOS=AX;
	    U.YPOS=AY;
	    XPOS=(int)(512*A*AX+Bx);
            YPOS=(int)(512*A*(1-AY)+By);
	    YPOS=512-YPOS;
	}

   }
}


