import java.applet.Applet;
import java.awt.event.*;
import java.awt.*;
import java.awt.geom.*;



/*This class draws the unfolding of a word relative
  to a triangle.  It is the analog of the unfold
  window in McBilliards.*/


public class UnfoldCanvas extends DBCanvas {
    ListenTriangle[] T=new ListenTriangle[301];
    PictureCanvas P;
    int mode,yes,show;
    double overfill,t1,t2,XPOS,YPOS;
    String W;

   public UnfoldCanvas(PictureCanvas P) { 
   this.P=P;
   for(int i=0;i<=300;++i) T[i]=new ListenTriangle();
   W="";
   XPOS=0.5;
   YPOS=0.5;
   mode=1;
   show=0;
   overfill=1;
   yes=0;
   t1=0;
   t2=0;
  }


    public void paint (Graphics gfx) {

      Graphics2D g=(Graphics2D) gfx;

      g.setRenderingHint(RenderingHints.KEY_ANTIALIASING,
                         RenderingHints.VALUE_ANTIALIAS_ON);

	doUnfold();
	g.translate(0,-25);
	drawUnfold(g);
	g.translate((int)(P.C.shift),0);
	drawBilliardPath(g);
	g.translate(0,25);
    }




      public void drawBilliardPath(Graphics g) {
	if((t1>0.000000001)&&(yes*show==1)) {
	    g.setColor(new Color(255,150,0));
	    g.drawLine(0,(int)(t1),1040,(int)(t1));
	    g.drawLine(0,(int)(t2),1040,(int)(t2));
	}
      }


      public void drawUnfold(Graphics2D g) {
	int n=W.length();
	g.translate((int)(-P.C.shift),0);
	Color C1=new Color(0,50,50);
	Color C2=new Color(0,200,200);

	for(int i=1;i<=n;++i)	{
	    T[i].renderSmooth(g,C1,C2);
	}

	/*first and last edge*/
	if(n>1) {
	  String S=W.substring(0,1);
	  int nn=-1;
          if(S.compareTo("1")==0) nn=0;
	  if(S.compareTo("2")==0) nn=1;
	  if(S.compareTo("3")==0) nn=2;
          T[1].edgeRenderSmooth(g,nn,Color.yellow);
	  T[n].edgeRenderSmooth(g,nn,Color.yellow);
	}
      }









     public void drawCoords(Graphics g) {
        g.setFont(new Font("Helvetica",Font.PLAIN,12));
	g.setColor(new Color(255,0,255));
	g.drawString("x Pi/2",910,18);  
	g.setColor(Color.white);
        g.setFont(new Font("Helvetica",Font.PLAIN,10));
	doubleRender(XPOS,g,760,12);
	doubleRender(YPOS,g,760,23);
     }


    public void wordRender(String W,Graphics g) {
	g.setColor(Color.black);
	g.fillRect(1,0,1098,26);
	g.setColor(new Color(100,0,100)); 
 	g.drawRect(1,0,1098,26);


        g.setFont(new Font("Helvetica",Font.PLAIN,20));  
	g.setColor(Color.white);
	int start=0;
	int stop=0;

	int n=W.length();
        g.setFont(new Font("Helvetica",Font.PLAIN,10)); 
	g.setColor(Color.white);
	if (n<=116)	g.drawString(W,4,12);


	if (n>116) {
	String W1=W.substring(1,116);
	String W2=W.substring(117,n);
	g.drawString(W1,4,11);
	g.drawString(W2,4,22); }
    }


    /*unfold routines*/

   public  ListenTriangle[] rawUnfold(ListenTriangle A,String W) {
	ListenTriangle[] T1=new ListenTriangle[300];
	for(int i=0;i<=299;++i) T1[i]=new ListenTriangle();
	T1[0]=A;
	int n=W.length();
	int digit=-1;
	String S=new String();
	if(n>0) {
	for(int i=0;i<n;++i) {
	  S=W.substring(i,i+1);
	  if(S.compareTo("1")==0) digit=0;
	  if(S.compareTo("2")==0) digit=1;
	  if(S.compareTo("3")==0) digit=2;
	  T1[i+1]=T1[i].reflect(digit);
	}}
	return(T1);
    }



    public ListenTriangle[] rotateHorizontal(ListenTriangle[] T1,int n) {
	Complex z=new Complex();
	ListenTriangle[] T2=new ListenTriangle[300];
	z=z.minus(T1[0].z[0],T1[n].z[0]);
	z=z.unit(z);
	z.x=-z.x;
	if(n>0) {
	    for(int i=0;i<=n;++i) T2[i]=T1[i].rotate(z); }
	return(T2);
    }



    /**this routine fits the object in the bounding box*/

   public ListenTriangle[] fit(double X,double Y,ListenTriangle[] T2,int n,int mode) {

	double mx=1000000;
	double my=1000000;
	double Mx=-1000000;
	double My=-1000000;

	for(int i=1;i<=n;++i) {
	  for(int j=0;j<=2;++j) {
	    if(mx>T2[i].z[j].x) mx=T2[i].z[j].x;
	    if(my>T2[i].z[j].y) my=T2[i].z[j].y;
	    if(Mx<T2[i].z[j].x) Mx=T2[i].z[j].x;
	    if(My<T2[i].z[j].y) My=T2[i].z[j].y;
	  }
	}

	ListenTriangle[] T3=new ListenTriangle[300];
	double s=X/(Mx-mx);
	double ss=Y/(My-my);

	overfill=1;

	if(mode==1) {
	  if(s>ss) s=ss;
	  Complex z1=new Complex(-s*mx+10,Y-s*(My+my)/2.0);
	  for(int i=0;i<=n;++i) 	    T3[i]=T2[i].scale(z1,s);
	}

	if(mode>=2) {
	    if(mode==3) ss=2.0*ss;
	    if(mode==4) ss=4.0*ss;
	    if(mode==5) ss=8.0*ss;
	  Complex z1=new Complex(-ss*mx+10,Y-ss*(My+my)/2.0);
	  for(int i=0;i<=n;++i) 	    T3[i]=T2[i].scale(z1,ss);
	  if(ss>s) overfill=ss/s;
	}

	P.C.overfill=overfill;
	return(T3);
   }





  public void getCorridor(ListenTriangle[] T3,int n) {
      Corridor C=new Corridor();
      C.compute(W,T3,n);
      double top=C.t1;
      double bot=C.t2;
	yes=0;
	t1=C.t1;
	t2=C.t2;
	if(C.t1>C.t2) {yes=1;}
  }








  public void doUnfold() {
      Complex z=new Complex(XPOS,YPOS);
      int q=P.getIndex();
      if(q>=7) {
	String W=P.P[q].W;
	int n=W.length(); 
	ListenTriangle[] T1=rawUnfold(T[0].init(z),W);
	ListenTriangle[] T2=rotateHorizontal(T1,n);
	ListenTriangle[] T3=new ListenTriangle[300];
        T3=fit(980,93,T2,n,mode);
	getCorridor(T3,n);
	for(int i=0;i<=n;++i)  T[i]=T3[i];
      }
  }



    public Complex[] rawPath(String W) {

	Complex[] V=new Complex[300];
	String S=new String();
	double pi=Math.PI;
	double arg1=pi/6+pi/2;
	double arg2=arg1+2*pi/3;
	double arg3=arg2+2*pi/3;

	Complex v1=new Complex(Math.cos(arg1),Math.sin(arg1));
	Complex v2=new Complex(Math.cos(arg2),Math.sin(arg2));
	Complex v3=new Complex(Math.cos(arg3),Math.sin(arg3));
	Complex v4=new Complex(0,0);
	Complex v5=new Complex(0,0);
	Complex vv=new Complex(0,0);

	int n=W.length();
	for(int i=0;i<n;++i) {
	 S=W.substring(i,i+1);
         if(S.compareTo("1")==0) {vv.x=v1.x;vv.y=v1.y;}
	 if(S.compareTo("2")==0) {vv.x=v2.x;vv.y=v2.y;}
	 if(S.compareTo("3")==0) {vv.x=v3.x;vv.y=v3.y;}

	 if(i%2==1) {vv.x=-vv.x;vv.y=-vv.y;}
	 v4.x=v4.x+vv.x;
	 v4.y=v4.y+vv.y;
	 V[i]=new Complex(v4.x,v4.y);
	}
	V[n]=new Complex(V[0].x,V[0].y);
	return(V);
    }




    public Complex[] getLocation(Complex[] V,int n) {
	double mx,my,Mx,My;
      mx=1000000;
      my=1000000;
      Mx=-1000000;
      My=-1000000;
      for(int i=0;i<n;++i) {
	if(mx>V[i].x) mx=V[i].x;
	if(Mx<V[i].x) Mx=V[i].x;
	if(my>V[i].y) my=V[i].y;
	if(My<V[i].y) My=V[i].y;
      }
      Complex[] Z=new Complex[2];
      Z[0]=new Complex(Mx-mx,My-my);
      Z[1]=new Complex((Mx+mx)/2.0,(My+my)/2.0);
      return(Z);
    }



    public void pathRender(String W,Graphics2D g,int x,int y) {
	int n=W.length();
	g.setColor(Color.yellow);
        g.translate(x,y);
	g.setColor(Color.black);
	g.fillRect(-89,-84,166,171);
	g.setColor(new Color(255,0,255));
	g.drawRect(-89,-84,166,171);

        g.setFont(new Font("Helvetica",Font.PLAIN,20));  
	Integer I=new Integer(0);
	g.setColor(Color.white);
	g.drawString(I.toString(n),-85,83);


	if(n>0) {
	Complex[] V=rawPath(W);
	Complex[] Z=getLocation(V,n);
	double size=Z[0].x;
	if(size<Z[0].y) size=Z[0].y;
	size=155/size;

	double xx=Z[1].x;
	double yy=Z[1].y;
	g.setColor(Color.yellow);
	float x1,y1,x2,y2;

	GeneralPath path=new GeneralPath();
	x1=(float)((V[0].x-xx)*size-5.0);
	y1=(float)((V[0].y-yy)*size+5.0);
            path.moveTo(x1,y1);

	for(int i=0;i<n;++i) {
	    x2=(float)((V[i+1].x-xx)*size-5.0);
	    y2=(float)((V[i+1].y-yy)*size+5.0);
            path.lineTo(x2,y2);
	}
            g.draw(path);
	}
        g.translate(-x,-y);
    }




    void doubleRender(double d,Graphics g,int x,int y) {
	double[] e=new double[12];
	int[] n=new int[12];
        Integer I=new Integer(0);
	e[0]=d;
	n[0]=(int)(e[0]);
	g.drawString(I.toString(n[0]),x+10,y);
        g.fillOval(x+18,y-2,2,2);
	for(int i=1;i<=10;++i) {
	    e[i]=10.0*(e[i-1]-n[i-1]);
	    n[i]=(int)(e[i]);
	    g.drawString(I.toString(n[i]),x+15+7*i,y);
	}
    }


    void shortDoubleRender(double d,Graphics g,int x,int y) {
	double[] e=new double[11];
	int[] n=new int[10];
        Integer I=new Integer(0);
	e[0]=d;
	n[0]=(int)(e[0]);
	//g.drawString(I.toString(n[0]),x+10,y);
        g.fillOval(x+18,y-2,2,2);
	for(int i=1;i<=8;++i) {
	    e[i]=10.0*(e[i-1]-n[i-1]);
	    n[i]=(int)(e[i]);
	    if(i<=4)  g.drawString(I.toString(n[i]),x+15+7*i,y);
	    if(i>4)  g.drawString(I.toString(n[i]), x+-13+7*i,y+12);
	}
    }









}

