import java.applet.Applet;
import java.awt.event.*;
import java.awt.*;


public class Vector3 {
    double x,y,z,t;
    int n,side;


    public void print() {
	System.out.println(this.x+" "+this.y+" "+this.z);
    }


    public Vector3() {
	this.x=0;
	this.y=0;
	this.z=0;
    }

    public Vector3(double x,double y,double z) {
	this.x=x;
	this.y=y;
	this.z=z;
    }

    public Vector3(double x,double y) {
	this.x=x;
	this.y=y;
	this.z=1.0;
    }



    public Vector3 cross(Vector3 V,Vector3 W) {
	Vector3 X=new Vector3();
	X.x=V.y*W.z-V.z*W.y;
        X.y=V.z*W.x-V.x*W.z;
        X.z=V.x*W.y-V.y*W.x;
	return(X);
    }

    public Vector3 normalize() {
	Vector3 X=this;
	X.x=x/z;
	X.y=y/z;
	X.z=1.0;
	return(X);
    }



    public double planarDist(Vector3 V,Vector3 W) {
	double t;
	t=0;
	t=t+(V.x-W.x)*(V.x-W.x);
	t=t+(V.y-W.y)*(V.y-W.y);
	t=Math.sqrt(t);
	return(t);
    }




    public Vector3 getIntersect(Vector3 A,Vector3 B,Vector3 C,Vector3 D) {
	double t;
	Vector3 X=new Vector3();
	Vector3 E=X.cross(A,B);
	Vector3 F=X.cross(C,D);
	Vector3 G=X.cross(E,F);
	if(G.z==0) {
             G.x=0;G.y=0;G.z=1;
	}

	Vector3 u=G.normalize();
	double d1,d2,d3;
	u.n=1;
	d1=u.planarDist(u,A);
	d2=u.planarDist(u,B);
	d3=u.planarDist(A,B);

	u.t=d1/d3;
	if((d1>d3)||(d2>d3)) u.n=0;
	d1=u.planarDist(u,C);
	d2=u.planarDist(u,D);
	d3=u.planarDist(C,D);
	if((d1>d3)||(d2>d3)) u.n=0;
	if(u.n==0) u.t=0;
	return(u);
    }
}









