import java.applet.Applet;
import java.awt.event.*;
import java.awt.*;
import java.awt.geom.*;



/**This class draws the hexagonal path associated to
  a word.  The bounding box is specified just like
  one specifies the box for a rectangle.  The actual
  path is fit into the box exactly and then scaled down
  5% so as to have leave a small border.  The current
  max length of the word is 1000*/

public class hexPath {

    /**this routine draws the raw path, without
       any scaling.*/

    public static Complex[] rawPath(String W) {

	Complex[] V=new Complex[1000];
	String S=new String();
	double pi=Math.PI;
	double arg1=pi/6+pi/2;
	double arg2=arg1+2*pi/3;
	double arg3=arg2+2*pi/3;

	Complex v1=new Complex(Math.cos(arg1),Math.sin(arg1));
	Complex v2=new Complex(Math.cos(arg2),Math.sin(arg2));
	Complex v3=new Complex(Math.cos(arg3),Math.sin(arg3));
	Complex v4=new Complex(0,0);
	Complex v5=new Complex(0,0);
	Complex vv=new Complex(0,0);

	int n=W.length();
	for(int i=0;i<n;++i) {
	 S=W.substring(i,i+1);
         if(S.compareTo("1")==0) {vv.x=v1.x;vv.y=v1.y;}
	 if(S.compareTo("2")==0) {vv.x=v2.x;vv.y=v2.y;}
	 if(S.compareTo("3")==0) {vv.x=v3.x;vv.y=v3.y;}

	 if(i%2==1) {vv.x=-vv.x;vv.y=-vv.y;}
	 v4.x=v4.x+vv.x;
	 v4.y=v4.y+vv.y;
	 V[i]=new Complex(v4.x,v4.y);
	}
	V[n]=new Complex(V[0].x,V[0].y);
	return(V);
    }


    /**this routine finds the bounding box of the raw path, and
       also computes the center of the b.box*/

    public static Complex[] getLocation(Complex[] V,int n) {
	double mx,my,Mx,My;
      mx=1000000;
      my=1000000;
      Mx=-1000000;
      My=-1000000;
      for(int i=0;i<n;++i) {
	if(mx>V[i].x) mx=V[i].x;
	if(Mx<V[i].x) Mx=V[i].x;
	if(my>V[i].y) my=V[i].y;
	if(My<V[i].y) My=V[i].y;
      }
      Complex[] Z=new Complex[2];
      Z[0]=new Complex(Mx-mx,My-my);
      Z[1]=new Complex((Mx+mx)/2.0,(My+my)/2.0);
      return(Z);
    }



    /**here is the main routine*/

    public static void pathRender(String W,Graphics2D g,int x,int y,int w,int h,Color C) {
        g.translate(x,y);
	g.setColor(Color.black);
	g.fillRect(0,0,w,h);
	g.setColor(new Color(255,0,255));
        g.drawRect(0,0,w,h);
	int n=W.length();


	if(n>0) {
	Complex[] V=rawPath(W);
	Complex[] Z=getLocation(V,n);
	double size=Z[0].x;
	if(size<Z[0].y) size=Z[0].y;
	int bb=w;
	if(bb>h) bb=h;
	size=bb/size;
	size=size*.95;

	double xx=Z[1].x;
	double yy=Z[1].y;
	g.setColor(C);
	float x1,y1,x2,y2;

	GeneralPath path=new GeneralPath();
	x1=(float)((V[0].x-xx)*size+w/2);
	y1=(float)((V[0].y-yy)*size+h/2);
            path.moveTo(x1,y1);

	for(int i=0;i<n;++i) {
	    x2=(float)((V[i+1].x-xx)*size+w/2);
	    y2=(float)((V[i+1].y-yy)*size+h/2);
            path.lineTo(x2,y2);
	}
            g.draw(path);
	}
        g.translate(-x,-y);
    }



}


