/*
 * SpaceTestApplet.java
 *
 * Created on October 29, 2005, 9:27 AM
 */

import java.awt.*;
import java.awt.event.*;
import java.applet.*;
import java.awt.geom.*;

import java.io.*;
import java.util.*;

/**
 *
 * @author  pat
 */
public class A2 extends Applet {
    
    Manager M;
    BasicSearchCanvas BSC;
    CoordinateCanvas CC;
    ColorSelectorCanvas CS;
    MouseCanvas MC;
    PlotCanvas PC;
    PatTitleCanvas PTC;
    PopupListCanvas PLC;
    SpaceCanvas SC;
    SpaceControlCanvas SCC;
    WordDisplayOnDemand WD;
    ExplainOnDemand EOD;
    RationalCanvas R;

    
    public void init(){
        // this allows us to detect the TAB key
        setFocusTraversalKeys(KeyboardFocusManager.FORWARD_TRAVERSAL_KEYS, 
        Collections.EMPTY_SET);
        
        setBackground(new Color(0,0,150));
        
        M=new Manager();
        
        BSC=new BasicSearchCanvas(M);
        BSC.setSize();
        
        CC=new CoordinateCanvas(M);
        
        CS=new ColorSelectorCanvas(M,60,240);
        CS.setSize(60,240);
        
        MC=new MouseCanvas(M);
        MC.setSize(61,120);
        
        PC=new PlotCanvas(M);
        PC.setSize();
        
        PLC=new PopupListCanvas(M);
        PLC.setSize();

	R=new RationalCanvas(M);
	R.setSize(60,208);
        
        PatTitleCanvas PTC=new PatTitleCanvas(M);
        
        SC=new SpaceCanvas(M);
        //SC.setSize(getWidth()-61,getHeight()-2*PTC.getSize().height);
        
        SCC= new SpaceControlCanvas(SC,M);
        SCC.setSize();

        
        WD=new WordDisplayOnDemand(M);
        EOD=new ExplainOnDemand(M);
        
        Container C1=new Container();
        C1.setSize(61, getHeight());
        C1.setLayout(new BorderLayout(0,5));
        C1.add(CS,BorderLayout.NORTH);
        C1.add(MC,BorderLayout.SOUTH);

	Container C3=new Container();
        C3.setSize(61, getHeight());
        C3.setLayout(new BorderLayout(0,5));
        C3.add(R,BorderLayout.NORTH);


        
        Container North=new Container();
        North.setSize(getWidth()-61, PTC.getHeight());
        North.setLayout(new FlowLayout(FlowLayout.LEFT,0,0));
        North.add(CC);
        North.add(PTC);  
        North.add(PLC);        
        North.add(PC);
        
        Container South=new Container();
        South.setSize(getWidth()-61, PTC.getHeight());
        South.setLayout(new FlowLayout(FlowLayout.LEFT,0,0));
        South.add(SCC);	
        South.add(BSC);
        South.add(PC);
        
        Container C2=new Container();
        C2.setSize(getWidth()-61, getHeight());
        C2.setLayout(new BorderLayout(0,0));
        C2.add(North,BorderLayout.NORTH);
        C2.add(SC,BorderLayout.CENTER);
        C2.add(South,BorderLayout.SOUTH);

        
        setLayout(new BorderLayout(0,0));
        add(C1,BorderLayout.EAST);
        add(C2,BorderLayout.CENTER);
        add(C3,BorderLayout.WEST);
    }
    
    private static class WinList implements WindowListener{
        Frame F;
        public WinList(Frame F){
            this.F=F;
        }
        
        public void windowActivated(java.awt.event.WindowEvent windowEvent) {
        }
        
        public void windowClosed(java.awt.event.WindowEvent windowEvent) {
        }
        
        public void windowClosing(java.awt.event.WindowEvent windowEvent) {
            F.dispose();
            System.exit(0);
        }
        
        public void windowDeactivated(java.awt.event.WindowEvent windowEvent) {
        }
        
        public void windowDeiconified(java.awt.event.WindowEvent windowEvent) {
        }
        
        public void windowIconified(java.awt.event.WindowEvent windowEvent) {
        }
        
        public void windowOpened(java.awt.event.WindowEvent windowEvent) {
        }
    }
    
    /**
     * @param args the command line arguments
     */
    public static void main(String[] args) {
        A2 a=new A2();
        a.setSize(640,480);
        Frame F=new Frame("Web McBilliards");
        F.setBackground(new Color(0,0,50));
        F.addWindowListener(new WinList(F));
        a.init();
        F.add(a);
        F.pack();
        F.setVisible(true);
    }
    
}
