import java.applet.Applet;
import java.awt.event.*;
import java.awt.*;


public class BoxAnalyzerCanvas extends DBCanvas implements MouseListener {
    UnfoldCanvas U;
    ListenSquare[][] L=new ListenSquare[2][2000];
    ListenSquare FLIP,O0,O1;
    ListenSquare I;
    Integer[][] R=new Integer[4][2000];
    Integer [][] R0=new Integer[2][100];
    ListenSquare[][] L0=new ListenSquare[2][100];
    int N,N0,N1,N00,N01;
    int space;
    int[] top;
    int[] bot;
    double radius;
    int mode;
    int offset0,offset1;
    DyadicTile DT; // the current box tile
    
    public BoxAnalyzerCanvas(UnfoldCanvas U) {
        this.U=U;
	mode=0;
	offset0=0;  
	offset1=0;
        N=0;
        radius=0;
	I=new ListenSquare(0,0,12,12,Color.white);
	FLIP=new ListenSquare(18,4,16,16,Color.white);
	O0=new ListenSquare(42,6,12,12,Color.white);
	O0.on=1;
	O1=new ListenSquare(60,6,12,12,Color.white);
	O1.on=1;
	FLIP.on=1;
        setBackground(new Color(0,80,0));
        setSize(100,24);
        addMouseListener(this);
        DT=null;
        if (U==null) {
            System.out.println("U should not be null.");
        }
    }
    
    public void paint(Graphics gfx) {
        Graphics2D g=(Graphics2D) gfx;
        Dimension D=this.getSize();
        g.setRenderingHint(RenderingHints.KEY_ANTIALIASING,
        RenderingHints.VALUE_ANTIALIAS_ON);
        g.setColor(Color.white);
	I.infoRender(g);
	FLIP.render(g,new Color(0,100,100));
	O0.render(g,new Color(0,0,200));
        O1.render(g,new Color(0,0,80));

        g.setFont(new Font("Monospaced",Font.PLAIN,10));
        
        if (DT!=null) { // draw this iff DT has been defined.
            leaderRender(g);
            recordRender(g);
        }
        g.setColor(Color.white);
        g.drawRect(0,0,D.width-1,D.height-1);
    }
    
    
    public void colorsOff(int q) {
        for(int i=1;i<N0;++i) L[0][i].on=0;
        for(int i=1;i<N1;++i) L[1][i].on=0;
        if(q!=2) for(int i=1;i<N00;++i) L0[0][i].on=0;
        if(q!=1) for(int i=1;i<N01;++i) L0[1][i].on=0;
    }
    
    
    
    
    public void mouseClicked(MouseEvent e) {
        e.consume();
        Point X=new Point();
        X.x=e.getX();
        X.y=e.getY();
        int v1=0;
        int v2=0;
        if(FLIP.inside(X)==1) {mode=1-mode;setUp();}

        if(O0.inside(X)==1) {
	    if(N0>1) offset0=R[0][1].intValue();
            setUp();
	}
        if(O1.inside(X)==1) {
	       if(N1>1) offset1=R[2][1].intValue();
	       System.out.println(offset1);
               setUp();
	}

	if(I.inside(X)==1) document();

        for(int i=1;i<N0;++i) {
            if(L[0][i].inside(X)==1) {
                colorsOff(0);
                L[0][i].on=1;
                v1=R[0][i].intValue();
                v2=R[1][i].intValue();
                U.UC.v1[1]=1;
                U.UC.v1[2]=top[v1];
                U.UC.v1[3]=v1;
                U.UC.v1[4]=Spine.coordsToType(U.CT[top[v1]],1);
                U.UC.v2[1]=1;
                U.UC.v2[2]=top[v2];
                U.UC.v2[3]=v2;
                U.UC.v2[4]=Spine.coordsToType(U.CT[top[v2]],1);
                U.UC.spineFunction();
                U.repaint();
                U.UC.repaint();
            }
        }
        
        
        
        for(int i=1;i<N1;++i) {
            if(L[1][i].inside(X)==1) {
                colorsOff(0);
                L[1][i].on=1;
                v1=R[2][i].intValue();
                v2=R[3][i].intValue();
                U.UC.v1[1]=2;
                U.UC.v1[2]=bot[v1];
                U.UC.v1[3]=v1;
                U.UC.v1[4]=Spine.coordsToType(U.CT[bot[v1]],2);
                U.UC.v2[1]=2;
                U.UC.v2[2]=bot[v2];
                U.UC.v2[3]=v2;
                U.UC.v2[4]=Spine.coordsToType(U.CT[bot[v2]],2);
                U.UC.spineFunction();
                U.repaint();
                U.UC.repaint();
            }
        }
        
        
        for(int i=1;i<N00;++i) {
            if(L0[0][i].inside(X)==1) {
                colorsOff(1);
                L0[0][i].on=1;
                v1=R0[0][i].intValue();
                U.UC.v1[1]=1;
                U.UC.v1[2]=top[v1];
                U.UC.v1[3]=v1;
                U.UC.v1[4]=Spine.coordsToType(U.CT[top[v1]],1);
                U.UC.spineFunction();
                U.repaint();
                U.UC.repaint();
            }
        }
        
        for(int i=1;i<N01;++i) {
            if(L0[1][i].inside(X)==1) {
                colorsOff(2);
                L0[1][i].on=1;
                v2=R0[1][i].intValue();
                U.UC.v2[1]=2;
                U.UC.v2[2]=bot[v2];
                U.UC.v2[3]=v2;
                U.UC.v2[4]=Spine.coordsToType(U.CT[bot[v2]],2);
                U.UC.spineFunction();
                U.repaint();
                U.UC.repaint();
            }
        }
        
        
        
        
        
        repaint();
        
    }
    
    
    
    public void mouseEntered(MouseEvent e) {}
    public void mouseExited(MouseEvent e) {}
    public void mousePressed(MouseEvent e) {}
    public void mouseReleased(MouseEvent e) {}
    
    public void leaderRender(Graphics g) {
        int space0=82;
        String s0=new String();
        
        for(int i=1;i<N00;++i) {
            L0[0][i].render2(g,new Color(0,0,200),new Color(220,0,220));
            s0=R0[0][i].toString();
            g.drawString(s0,space0,22);
            space0=space0+5*s0.length()+5;
        }
        
        int space1=82;
        String s1=new String();
        for(int i=1;i<N01;++i) {
            L0[1][i].render2(g,new Color(0,0,80),new Color(220,0,220));
            s1=R0[1][i].toString();
            g.drawString(s1,space1,10);
            space1=space1+5*s1.length()+5;
        }
    }
    
    
    
    public void recordRender(Graphics g) {
	if(mode==0) recordRender0(g);
	if(mode==1) recordRender1(g);
    }

    
    
    
    public void recordRender0(Graphics g) {
        int space0=space+15;
        String s0=new String();
        String s1=new String();
        for(int i=1;i<N0;++i) {
            L[0][i].render2(g,new Color(0,0,200),new Color(220,0,220));
            s0=R[0][i].toString();
            s1=R[1][i].toString();
            g.drawString(s0,space0,11);
            g.drawString(s1,space0,21);
            space0=space0+5*Math.max(s0.length(),s1.length())+5;
        }
	space0=space0+7;
        for(int i=1;i<N1;++i) {
            L[1][i].render2(g,new Color(0,0,80),new Color(220,0,220));
            s0=R[2][i].toString();
            s1=R[3][i].toString();
            g.drawString(s0,space0,11);
            g.drawString(s1,space0,21);
            space0=space0+5*Math.max(s0.length(),s1.length())+5;
        }
    }


    
    public void recordRender1(Graphics g) {
        int space0=space+15;
        String s0=new String();
        String s1=new String();
        for(int i=1;i<N1;++i) {
            L[1][i].render2(g,new Color(0,0,80),new Color(220,0,220));
            s0=R[2][i].toString();
            s1=R[3][i].toString();
            g.drawString(s0,space0,11);
            g.drawString(s1,space0,21);
            space0=space0+5*Math.max(s0.length(),s1.length())+5;
        }
	space0=space0+7;        
        for(int i=1;i<N0;++i) {
            L[0][i].render2(g,new Color(0,0,200),new Color(220,0,220));
            s0=R[0][i].toString();
            s1=R[1][i].toString();
            g.drawString(s0,space0,11);
            g.drawString(s1,space0,21);
            space0=space0+5*Math.max(s0.length(),s1.length())+5;
        }
    }



    
    
    
    public  int[] completeList(int ii) {
        int count,OLD,NEW;
        int[] n=new int[U.CT[0].c[0]];
        count=0;
        OLD=1;
        
        for(int i=1;i<=U.CT[0].c[0];++i) {
            NEW=U.CT[i].c[ii];
            if(NEW>OLD) {
                OLD=NEW;
                ++count;
                n[count]=i-1;
            }
        }
        
        if(2*count<U.CT[0].c[0]) {
            ++count;
            n[count]=U.CT[0].c[0];
        }
        
        n[0]=U.CT[0].c[0]/2;
        return(n);
    }
    
    
    
    public void update(){
        if (U==null) {
            System.out.println("Error: UnfoldCanvas is non-existent!");
            return;
        }
        if (U.ST==null) {
            System.out.println("Error: Tile is non-existent!");
            return;
        }
        if (U.ST.getClass().getName()=="DyadicTile") { // is this tile dyadic?
            DT=(DyadicTile)(U.ST); // convert the tile to a dyadic tile
            U.UC.F.dyadic=DT.dyadic_size;
        } else {
            System.out.println("Error: Tile isn't a DyadicTile!");
            DT=null;
            return;
        }
        top=completeList(1);
        bot=completeList(2);
	setUp();
        getRadius();
        repaint();
    }

    	public void setUp() {
          space=setLeaders();
          setRecord(space+15);
	}
    
    public void getRadius() {
        U.dyadic=DT.dyadic_size;
    }
    
    
    
    public int setLeaders() {
        int space0=82;
        int space1=82;
        int count0=1;
        int count1=1;
        int size0;
        int size1;
        Color col0=new Color(0,0,0);
        Color col1=new Color(0,0,0);
        
        int[][] r=DT.record;
        N=r[0][0];
        String s0=new String();
        String s1=new String();
        
        for(int i=1;i<=N;++i) {
            if(r[0][i]==i) {
                R0[0][count0]=new Integer(i);
                s0=R0[0][count0].toString();
                size0=5*s0.length()+5;
                col0=new Color(0,0,180);
                L0[0][count0]=new ListenSquare(space0-2,12,size0,12,col0);
                space0=space0+size0;
                ++count0;
            }
        }
        N00=count0;
        
        for(int i=1;i<=N;++i) {
            if(r[1][i]==i) {
                R0[1][count1]=new Integer(i);
                s1=R0[1][count1].toString();
                size1=5*s1.length()+5;
                col1=new Color(0,0,240);
                L0[1][count1]=new ListenSquare(space1-2,0,size1,12,col1);
                space1=space1+size1;
                ++count1;
            }
        }
        N01=count1;
        if(space0<space1) return(space1);
        return(space0);
    }
    
    public void setRecord(int space) {
	System.out.println("mode "+mode);
	if(mode==0) setRecord0(space);
	if(mode==1) setRecord1(space);
    }

    
    public void setRecord0(int space) {
        int space0=space;
        int space1=space;
        int count0=1;
        int count1=1;
        int size0;
        int size1;
        Color col0=new Color(0,0,0);
        Color col1=new Color(0,0,0);
        
        int[][] r=DT.record;
        N=r[0][0];
        String s0=new String();
        String s1=new String();
        String s2=new String();
        String s3=new String();
        
	int ii=offset0;
        for(int i=1;i<=N;++i) {
	    ii=i+offset0;
	    if(ii>N) ii=ii-N;
            if((r[0][ii]!=ii)&&(r[0][ii]!=0)) {
                R[0][count0]=new Integer(ii);
                R[1][count0]=new Integer(r[0][ii]);
                s0=R[0][count0].toString();
                s1=R[1][count0].toString();
                size0=5*Math.max(s0.length(),s1.length())+5;
                col0=new Color(0,0,180);
                L[0][count0]=new ListenSquare(space0-2,0,size0,24,col0);
                space0=space0+size0;
                ++count0;
            }
        }
        N0=count0;
	ii=offset1;
        space0=space0+7;
        for(int i=1;i<=N;++i) {
	    ii=i+offset1;
	    if(ii>N) ii=ii-N;
            if((r[1][ii]!=ii)&&(r[1][ii]!=0)) {
                R[2][count1]=new Integer(ii);
                R[3][count1]=new Integer(r[1][ii]);
                s2=R[2][count1].toString();
                s3=R[3][count1].toString();
                size1=5*Math.max(s2.length(),s3.length())+5;
                col1=new Color(0,0,180);
                L[1][count1]=new ListenSquare(space0-2,0,size1,24,col1);
                space0=space0+size1;
                ++count1;
            }
        }
        N1=count1;
    }
    
    
    
    public void setRecord1(int space) {
        int space0=space;
        int space1=space;
        int count0=1;
        int count1=1;
        int size0;
        int size1;
        Color col0=new Color(0,0,0);
        Color col1=new Color(0,0,0);
        
        int[][] r=DT.record;
        N=r[0][0];
        String s0=new String();
        String s1=new String();
        String s2=new String();
        String s3=new String();

	int ii=offset1;
        for(int i=1;i<=N;++i) {
	    ii=i+offset1;
	    if(ii>N) ii=ii-N;
            if((r[1][ii]!=ii)&&(r[1][ii]!=0)) {
                R[2][count1]=new Integer(ii);
                R[3][count1]=new Integer(r[1][ii]);
                s2=R[2][count1].toString();
                s3=R[3][count1].toString();
                size0=5*Math.max(s2.length(),s3.length())+5;
                col1=new Color(0,0,180);
                L[1][count1]=new ListenSquare(space0-2,0,size0,24,col1);
                space0=space0+size0;
                ++count1;
            }
        }  
	N1=count1;
	ii=offset0;
	space0=space0+7;
        for(int i=1;i<=N;++i) {
	    ii=i+offset0;
	    if(ii>N)ii=ii-N;
            if((r[0][ii]!=ii)&&(r[0][ii]!=0)) {
                R[0][count0]=new Integer(ii);
                R[1][count0]=new Integer(r[0][ii]);
                s0=R[0][count0].toString();
                s1=R[1][count0].toString();
                size0=5*Math.max(s0.length(),s1.length())+5;
                col0=new Color(0,0,180);
                L[0][count0]=new ListenSquare(space0-2,0,size0,24,col0);
                space0=space0+size0;
                ++count0;
            }
        }
        N0=count0;
    }
    
    public void document() {
	U.M.setExplain("This window allows the user to survey the main calculations which are done by our tile plotters. You should probably read about the elimination algorithm works, in the tile plotter documentation, before reading the explanation here.  \n\nIn brief, the elimination algorithm starts with a dyadic square and a list of top and bottom vertices. The algorithm then matches the various top vertices against each other, eliminating the vertices which lose the matches. Likewise for the bottom vertices.  At the end of the eliminations, all the top vertices are matched against all the bottom vertices in a playoff round. \n\nThis window shows a record of the matches played.  At the very left the top squares show the winners of the top elimination and the bottom squares show the winners of the bottom elimination.  To the right of these boxes are a list of rectangles.  Each rectangle lists a match played during the eliminations.  If you click on one of these rectangles you can see which vertices are involved in the match. By looking at the unfolding window you can see that one vertex lies above the other one throughout the dyadic square.  We prove this rigorously in three steps:\n\n1. we compute the gradient of the defining function at the center of the box;\n\n2. we bound the variation of the gradient across the box by computing absolute bounds on the second derivatives\n\n 3. we evaluate the defining function at either at a vertex of the dyadic square or at the vertex of a square having twice the area.\n\nThe numbers displayed along the bar across the function window show the various quantities which go into the proof.\n\nThe controls at the extreme left side of this window allow you to permute the various match listings. These buttons are useful if there are too many matches to fit on the screen.");
    }    
    
}
