/*
 * CoordinateCanvas.java
 *
 * Created on November 10, 2005, 10:18 AM
 */

import java.awt.*;
import java.awt.event.*;

/**
 *
 * @author  pat
 */
public class CoordinateCanvas extends DBCanvas
implements HearingParameter, MouseListener, FocusListener, KeyListener {
    Manager M;
    
    ListenString[] Z;
    
    ListenString doc;
    int selected=-1;
    
    static final int padding=4;
    
    // colors
    static final Color buttonBg=new Color(255,80,255);
    static final Color buttonFg=Color.black;
    
    
    /** Creates a new instance of CoordinateCanvas */
    public CoordinateCanvas(Manager M) {
        this.M=M;
        M.hearParameter(this);
        
        setBackground(new Color(100,0,100));
        
        setFont(new Font("Monospaced", Font.PLAIN, 12));
        Z=new ListenString[2];
        
        double x=padding,y=padding;
        Z[0]=new ListenString("0.123456", this);
        Z[0].setLeft(x);
        Z[0].setTop(y);
        Z[0].setColors(buttonFg,buttonBg);
        //Z[0].showBorder=false;
        
        x=Z[0].getRight()+padding;
        doc=new ListenString("?",this);
        doc.setLeft(x);
        doc.setTop(y);
        doc.setColors(buttonFg,buttonBg);
        
        x=padding;
        y=Z[0].getBottom()+padding;
        Z[1]=new ListenString("0.123456", this);
        Z[1].setLeft(x);
        Z[1].setTop(y);
        Z[1].setColors(buttonFg,buttonBg);
        //Z[1].showBorder=false;
        
        setSize((int)(doc.getRight()+padding),(int)(Z[1].getBottom()+padding));
        parameterChanged();
        
        addMouseListener(this);
        addFocusListener(this);
        addKeyListener(this);
    }
    
    public void paint(Graphics gfx) {
        Graphics2D g=(Graphics2D) gfx;
        
        g.setRenderingHint(RenderingHints.KEY_ANTIALIASING,
        RenderingHints.VALUE_ANTIALIAS_ON);
        //g.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING,
        //RenderingHints.VALUE_TEXT_ANTIALIAS_OFF);
        
        Z[0].render(g);
        Z[1].render(g);
        doc.render(g);
        
        Dimension D=getSize();
        g.setColor(new Color(255,155,0));
        g.drawRect(0,0,D.width-1,D.height-1);
    }
    
    public void parameterChanged() {
        double x=(int)(M.getX()*1000000)/1000000.0;
        double y=(int)(M.getY()*1000000)/1000000.0;
        if (x==1){
            x=0.999999;
        }
        if (y==1){
            y=0.999999;
        }
        if (x==0)
            Z[0].str="0.";
        else
            Z[0].str=Double.toString(x);
        if (y==0)
            Z[1].str="0.";
        else
            Z[1].str=Double.toString(y);
        repaint();
    }
    
    public void updateColors(){
        Z[1].setColors(buttonFg,buttonBg);
        Z[0].setColors(buttonFg,buttonBg);
        if (selected!=-1) {
            Z[selected].setColors(buttonFg,Color.white);
        }
    }
    
    public void deselect() {
        selected=-1;
        Z[1].setColors(buttonFg,buttonBg);
        Z[0].setColors(buttonFg,buttonBg);
    }
    
    public void mouseClicked(MouseEvent e) {
        if (doc.contains(e.getX(),e.getY())){
            M.setExplain("These numbers represent the angles of the triangle that correspond to the point in the parameter space. Two of the angles of the triangle can be described as 90 degrees times the top and bottom numbers.");
            return;
        }
        for (int i=0; i<2; i++) {
            if (Z[i].contains(e.getX(),e.getY())){
                if (selected!=i)
                    selected=i;
                else
                    selected=-1;
                updateColors();
                repaint();
                return;
            }
        }
    }
    
    public void mouseEntered(MouseEvent e) {
    }
    
    public void mouseExited(MouseEvent e) {
    }
    
    public void mousePressed(MouseEvent e) {
    }
    
    public void mouseReleased(MouseEvent e) {
    }
    
    public void focusGained(java.awt.event.FocusEvent focusEvent) {
    }
    
    public void focusLost(java.awt.event.FocusEvent focusEvent) {
        deselect();
        repaint();
    }
    
    public void keyPressed(KeyEvent e) {
    }
    
    public void keyReleased(KeyEvent E) {
    }
    
    public void keyTyped(KeyEvent e) {
        if (e.getKeyChar()==KeyEvent.VK_TAB) {
            selected=(selected+1)%2;
            updateColors();
            repaint();
            return;
        }
        if (selected!=-1) {
            if (e.getKeyChar()==KeyEvent.VK_ENTER) {
                deselect();
                repaint();
                return;
            }
            String str=Z[selected].str;
            if (e.getKeyChar()==KeyEvent.VK_BACK_SPACE) {
                if (str.length()>2)
                    str=str.substring(0,str.length()-1);
            }
            if (e.getKeyChar()==KeyEvent.VK_DELETE) {
                str="0.";
            }
            int ch=(int)(e.getKeyChar()-'0');
            if ((ch>=0)&&(ch<10)){
                if (str.length()<8) {
                    str=str+e.getKeyChar();
                }
            }
            //System.out.println("x="+x+" temp="+temp);
            if (str!=Z[selected].str) {
                Z[selected].str=str;
                M.setParameter(Double.parseDouble(Z[0].str), Double.parseDouble(Z[1].str));
            }
        }
    }
    
}
