import java.applet.Applet;
import java.awt.event.*;
import java.awt.*;
import java.awt.geom.*;

/*This is a basic class for a rectangular button button*/

public class Deg100Document {
    Manager M;

    public Deg100Document(Manager M) {
	this.M=M;
    }

    public void P1Explain() {
	M.setExplain("This is specialized documentation for the Degree 100 window. Click on the question mark to get an overview.\n\n\n\nP1 is a neighborhood of the degenerate right triangle whose small angle is 0.  This polygon is covered by an infinite union of orbit tiles. The 20 data boxes contain the starts of the two infinite series of tiles which cover P1. These tiles are treated analytically in Rich's papers. The computational part of the proof only uses the 6 polygons P1,...,P6, and the magenta boxes, which have another 221 polygons");
    }

    public void P2Explain() {
	M.setExplain("This is specialized documentation for the Degree 100 window. Click on the question mark to get an overview.\n\n\n\nP2 is the set of acute triangles whose big angle is at least 569/1024 radians.  This number just slightly exceeds 100 degrees.  We could have made P2 be the region consisting in triangles whose big angle is at least 100 degrees, but we take this slightly smaller region because its vertices have dyadic rational coordinates.");
    }

    public void P3Explain() {
	M.setExplain("This is specialized documentation for the Degree 100 window. Click on the question mark to get an overview.\n\n\n\nP3 is the set of triangles whose second angle is bigger than the first angle.  By symmetry we do not need to consider this region of parameter space.");
    }

    public void P4Explain() {
	M.setExplain("This is specialized documentation for the Degree 100 window. Click on the question mark to get an overview.\n\n\n\nP4 is a neighborhood of the right triangle whose small angle is Pi/4.  This region is covered by the orbit tiles associated to the 5 data boxes shown.  We treat these data boxes analytically in the paper.  They cannot be treated numerically without some special effort, because they all have Pi/4 as a vertex, a fact which we cannot tell numerically.  (We can only get close.) These tiles are treated analytically in Rich's papers. The computational part of the proof only uses the 6 polygons P1,...,P6, and the magenta boxes, which have another 221 polygons");
    }


    public void P5Explain() {
	M.setExplain("This is specialized documentation for the Degree 100 window. Click on the question mark to get an overview.\n\n\n\nP5 is a neighborhood of the right triangle whose small angle is Pi/5.  This region is covered by the orbit tiles associated to the 2 data boxes shown.  We treat these data boxes analytically in the paper.  They cannot be treated numerically without some special effort, because they all have Pi/5 as a vertex, a fact which we cannot tell numerically.  (We can only get close.) These tiles are treated analytically in Rich's papers.  The computational part of the proof only uses the 6 polygons P1,...,P6, and the magenta boxes, which have another 221 polygons.");
    }



    public void P6Explain() {
	M.setExplain("This is specialized documentation for the Degree 100 window. Click on the question mark to get an overview.\n\n\n\nP6 is a neighborhood of the right triangle whose small angle is Pi/6.  This polygon is covered by an infinite union of orbit tiles. The 20 data boxes contain the starts of the two infinite series of tiles which cover P6.  These tiles are treated analytically in Rich's papers. The computational part of the proof only uses the 6 polygons P1,...,P6, and the magenta boxes, which have another 221 polygons");
    }








    public void locateButton() {
	M.setExplain("This is specialized documentation for the Degree 100 window.  Click on the question mark to get the overview of this window.\n\n\n\nLocate button:\n\nWhen this button is on and you click on the data box B(W), the parameter on the main McBilliards window is set to the center of mass of the polgon P(W).  This point always represents a triangle for which W describes a periodic billiard path.  You can best appreciate this feature by opening up the unfolding window and comparing the effect of clicking on the data boxes with the mode on and off. The unfolding window has its own documentation, so you can learn about what it does if you don't already know.");
    }



    public void verifyButton() {

	M.setExplain("This is specialized documentation for the Degree 100 window.  Click on the question mark to get the overview of this window.\n\n\n\nVerify button:\n\nThe documentation here assumes that you have already read the documentation for the plot mode button.  As with the plot button, this button has 4 modes.  The 4 modes exactly parallel the modes for the plot button, so we will not detail them here.  We will discuss\n\n1. verify tile\n\nin detail.  When tthis mode active, and you click on a data box B(W), McBilliards verifies computationally that the given polygon P(W) is contained in the orbit tile O(W).  This mode (and all the others) only works for tiles in Group I and II.  We will first explain how things for the tiles in Group I and then discuss the mode subtle Group II at the end.\n\nAssume B(W) is one of the data tiles in Group I. McBilliards verifies that P(W) is contained in O(W) by producing a finite covering of P(W) by dyadic squares such that each dyadic square is contained in O(W).  Once these squares are plotted, you can access them one at a time as follows:\n\nA. On the plot component of the main console set the plot mode to 'verify'\n\nB. On the plot component of the main console set the plot style to 'local'.\n\nC. On the plot component of the main console click on the rightmost button so that it is black (rather than magenta.)\n\nD. Click on the square of interest to you and push plot.\n\nBy following these steps, you replot the square of interest to you, in a color of your choice. This square remembers all the information necessary to reconstruct the proof that it lies in the orbit tile.  To appreciate the extra information stored in the square, you should really open up the unfolding window and play around with the bottom most window.  This window will have a number of little numbered squares in it, and you should click them. To find out what these numbered squares mean, you should do 3 things:\n\nE. Read the documentation for the packing mode of the plotter.\n\nF.Read the documentation for the verify mode of the plotter.(This is a copy of the verify mode performed here.)\n\nRead the documentation for the unfolding window, especially the bottom-most component, and then play around with the bottom component.");
    }



    public void plotButton() {
	String s1="This is specialized documentation for the Degree 100 window.  Click on the question mark to get the overview of this window.\n\n\n\nPlot button:\n\nThis button has 6 modes:\n\n1. plot tile: When you click on the data box  B(W) the polygon P(W) is plotted on the main window.\n\n2. plot neighbors: Say that two tiles are neighbors if they intersect. This mode plots the selected tile in yellow and all its neighbors in blue. This feature is only active for the computational (magenta) tile boxes and the polygons P1,...,P6 residing in the 6 red boxes.  To best appreciate this feature you should turn on the fit button on the main console.  Then you will see the yellow tile fit to the screen and completely surrounded by its blue neighbors.  Using this mode, together with the fit button, you can check that our tiles cover the parameter space, as claimed in the paper. \n\n3. plot group: Each tile belongs to a group of tiles.  When you click on a tile, the entire group is plotted.  We'll say more about the nature of the groups below.\n\n 4. plot all dyadic: When you click on any tile, all the computational tiles are plotted.  These are the tiles P1,...,P221. Coindicentally, these are precisely the tiles whose vertices all have dyadic rational coordinates. The remaining tiles, namely the ones indexed by the cyan boxes,  are present to illuatrate how P1,P4,P5,P6 are covered by orbit tiles.\n\n5. global clear: If you click on any box, it clears the main plotting screen.\n\n6. plot off: no action taken.\n\n\n\nHere is a more detailed discussion about the groups. There are 8 groups,namely:\n\n";

	s1=s1+"Sa: These are the words W such that P(W) is contained in the interior of the parameter space of obtuse triangles.  There are about 200 words in this group and they are sorted according to wordlength. The remaining groups consist of tiles which touch the boundary of the parameter space (the right angle line) which represents right triangles. \n\nSb. These are polygons which abut the right angled line but otherwise are generic.  There are 23 of these. The S families are the tiles we treat numerically in our proof.  They cover the set S-P1-P4-P5-P6, where S is the 100 degree strip and P1,P4,P5,P6 are small dyadic neighborhoods of points on the right angled line. You can learn about these neighborhoods by clicking on them and reading the documentation.\n\n";


	s1=s1+"P1a and P1b: these are 2 groups of 10 tiles, both the starts of infinite families of tiles.  The entire infinite union covers the polygon P1.  No finite union of orbit tiles covers P1.\n\n";

	s1=s1+"P4: These 5 polygons cover a the polygon P4\n\n";

        s1=s1+"P5: These 2 polygons cover the polygon P5\n\n";

        s1=s1+"P6a and P6b: these are 2 groups of 10 tiles, both the starts of infinite families of tiles.  The entire infinite covers the polygon P6.  No finite union of orbit tiles covers P6.\n\n";

	s1=s1+"You can see the polygons P1-P6 plotted by clicking on them with the plot button on mode 1.  They are treated just like any of the other polygons, except that we don't verify that every point in them has a periodic billiard path.  This is done in the papers. (For P2 and P3 we don't need to do this, because they are outside the region of interest to us.  They are present just to demarkate the region of interest.)  All the groups except Sa and Sb are handled analytically in Rich's papers.  The tiles Sa and Sb are treated with a rigorous computer-aided proof which you can survey using McBilliards.  (You are surveying it.)";
	M.setExplain(s1);
    }












    public void boundary() {
	M.setExplain("This is specialized documentation for the Degree 100 window.  Click on the question mark to get the overview of this window.\n\n\n\nExcluded regions component:\n\nThese three buttons store 3 polygons whose complement is the region of interest to us.\n\n1. The first polygon represents the set of triangles whose big angle is greater than 100 degrees.\n\n2. The second polygon represents the set of acute and right triangles.  All acute triangles have a periodic billiard path of length 3, the Fagnano curve.  All right triangles have a periodic billiard path of length 6.\n\n3.By symmetry it suffices to consider triangles whose first angle not larger than the second angle. The third polygon consists of those points representing triangles whose first angle is larger than the second angle.\n\nIf you click on these buttons with the plot mode set to `plot tile' you can see them plotted on the main window.");
    }


    public void wordDisplay() {
        M.setExplain("This is specialized documentation for the Degree 100 window.  Click on the question mark to get the overview of this window.\n\n\n\nWord display component:\n\nThis display has two modes which you toggle with the little button in the top left corner. Each word is some string in the digits 1,2,3.  One mode of this display just prints out the digits of the word. The other mode prints out the word hexpath, which is a combinatorial representation of the word.\n\n To display the hexpath we draw a certain hexagonal path in the plane.  The path is made by dividing the three kinds of edges in the hexagonal grid into types depending on the direction of the edge, and then following these edges according to the digits in the word.  The fact that the paths are all closed indicates that the words we are considering are all stable:  They describe periodic billiard paths in open sets of triangles.  The word display can be one of three colors:\n\nBlue: The word describes a billiard path which starts out perpendicular to one of the sides of the triangle.  The word is essentially a palindrome.\n\nGreen: The word is the square of an odd word.\n\nRed: All other words.\n\nThis same method of representing words is used when to display the output of our searches.  Compare also the word window popup.");    }
    
    


    public void vertexDisplay() {
        M.setExplain("This is specialized documentation for the Degree 100 window.  Click on the question mark to get the overview of this window.\n\n\n\nVertex display component:\n\nRecall from the main documentation that each of the little data boxes in the left two columns contains a word W and a rational polygon P(W).  With 10 exceptions, P(W) has the property that every point in the polygon has a periodic billiard path whose combinatorics is described by W\n\nWhen you click on one of the data boxes this window will show the coordinates of the vertices. Iif you click on one of these displayed coordinates, the cursor in the McBilliards plotting window will move to that point. You can use this option most effectively if you:\n\nA. select the 'fit' option on the main McBilliards console\n\nC. select the 'plot tile' mode on the 100 Degree window\n\nC. turn off the 'verify' mode on the 100 Degree window. \n\nOn B and C are the default settings. Here are some facts about our polyons:\n\n1.Each polygon is convex and has at most 8 vertices. \n\n2. With 42 exceptions, all the vertices have dyadic rational coordinates.  The maximum numerator is 2^17. As for the exceptions: 2 of the exceptions correspond to the Pi/5 point. The other 40 exceptions are the starts of the 4 infinite families shown at the bottom right corner of the 100 Degree window. These words are all treated analytically in Rich's papers.\n\n3. From amongst the 42 non-dyadic polygons, 10 polygons do not have rational vertices.  These 10 exceptions are the same ones mentioned above. In each of these 10 cases we plotted O(W) numerically and let P(W) be the convex hull of the vertices of O(W). The tile O(W) is slightly nonconvex and so it does not quite contain P(W).  However, the error is vanishingly small.  Also, as we already mentioned, Rich treats all these tiles analytically in the papers. The plot here is just for the purposes of illustration.  The actual vertices of O(W) in these cases are irrational multiples of Pi. The exceptional tiles do not overlap at the right angled line, and so it is impossible to take a rational approximation.  In our proof we just have to deal with these irrational vertices.");
    }
    
    



    public void summary() {
	M.setExplain("This window illustrates Rich's theorem that a triangle has a periodic billiard provided that all its angles are at most 100 degrees.  Here we will give a rough summary of the features of the window.  Whenever you click on one of the buttons on the window, some additional documentation will appear.\n\n Before we get started, we need a bit of terminology. For any word W, the set O(W) denotes the set of points in parameter space for which W described a periodic billiard path.  We call O(W) an orbit tile.  For each relevant W we select a polygonal approximation P(W) which is contained in O(W). We call P(W) a rational approximation, because its vertices are rational.  To prove our theorem we show that the set of obtuse triangles with large angle between 90 and 100 degrees is contained in a union of sets of the form P(W).\n\n Each little square on the left side is what we call a data box.  Each data box B(W)  contains a word W and the coordinates for P(W).  When you click on B(W) you see a combinatorial representation W. You also see the coordinates of the vertices of P(W) listed on the right. By setting the plot mode appropriately you see P(W) plotted on the main McBilliards window.   \n\n The data boxes are divided into two types.  The cyan ones are computational and the magenta ones are analytic.  If you set the verify mode appropriately and you click on a computational data box B(W) you can plot a finite covering of P(W) by dyadic rational squares, each of which is guaranteed to lie in O(W).  This gives a proof, modulo roundoff error, that P(W) is contained in O(W).  The analytic boxes are treated analytically in Rich's papers.  The computations are redone, using interval arithmetic, in the C version of McBilliards which is available from Rich's website.\n\n For any of the words in the data boxes, either computational or analytic, you can use the main plotters on McBilliards to see what O(W) looks like. Typically P(W) is a close inner approximation to O(W) but sometimes P(W) is much smaller.  In general, once you select a data box, McBilliards knows about the word and you can manipulate it just as you would manipulate a word you get from a search.\n\n This ends our rough tour of the window.  Once again, you can get more detailed information as you click various parts of the window.");
	    }





    }