import java.applet.Applet;
import java.awt.event.*;
import java.awt.*;
import java.awt.geom.*;

//drawing routines for the dyadic plotter
public class DyadicPlotHandler {


    public static DyadicTile plotSolid(String W,DyadicSquare[] IN,int IN_N,DyadicSquare[] DEF,int DEF_N,Complex[][] CORNER,int[] corner,Color C) {
        PolygonChopper PC=new PolygonChopper(W);
        double[] x=new double[4];
        Area A=new Area();
        SmallPolygon X=new SmallPolygon();
        
        if (IN_N+DEF_N==0) {
            return null;
        }
        
        for(int i=0;i<IN_N;++i) {
            A.add(new Area(IN[i].toGeneralPath()));
        }
        
        for(int i=0;i<DEF_N;++i) {
            X=PC.chopSquare(DEF[i]);
            if(X.N>2) A.add(new Area(X.toGeneralPath()));
        }
        
        for(int i=0;i<=2;++i) {
            if(corner[i]==1) {
                X=new SmallPolygon(CORNER[i],3);
                A.add(new Area(X.toGeneralPath()));
            }
        }
        
        return (new DyadicTile(W, A, C));
    }
    
    
    
    
    
    public static DyadicTile plotBoxes(String W,DyadicSquare[] IN,int IN_N,DyadicSquare[] DEF,int DEF_N,Complex[][] CORNER,int[] corner,Color C) {
        PolygonChopper PC=new PolygonChopper(W);
        double[] x=new double[4];
        GeneralPath gp=new GeneralPath();
        SmallPolygon X=new SmallPolygon();
        
        if (IN_N+DEF_N==0) {
            return null;
        }

        for(int i=0;i<IN_N;++i) {
            gp.append(IN[i].toGeneralPath(), false);
        }
        
        for(int i=0;i<DEF_N;++i) {
            X=PC.chopSquare(DEF[i]);
            if(X.N>2) gp.append(X.toGeneralPath(),false);
        }
        
        for(int i=0;i<=2;++i) {
            if(corner[i]==1) {
                X=new SmallPolygon(CORNER[i],3);
                gp.append(X.toGeneralPath(),false);
            }
        }
        
        return (new DyadicTile(W, gp, C));
    }






    public static DyadicTile coverPlotSolid(String W,DyadicSquare[] IN,int IN_N,DyadicSquare[] DEF,int DEF_N,Complex[][] CORNER,int[] corner,Color C) {
        PolygonChopper PC=new PolygonChopper(W);
        double[] x=new double[4];
        Area A=new Area();
        SmallPolygon X=new SmallPolygon();
        
        if (IN_N+DEF_N==0) {
            return null;
        }
        
        for(int i=0;i<IN_N;++i) {
            A.add(new Area(IN[i].toGeneralPath()));
        }
        
        for(int i=0;i<DEF_N;++i) {
            A.add(new Area(DEF[i].toGeneralPath()));
        }
        
        for(int i=0;i<=2;++i) {
            if(corner[i]==1) {
                X=new SmallPolygon(CORNER[i],3);
                A.add(new Area(X.toGeneralPath()));
            }
        }
        
        return (new DyadicTile(W, A, C));
    }
    
    
    
    
    
    public static DyadicTile coverPlotBoxes(String W,DyadicSquare[] IN,int IN_N,DyadicSquare[] DEF,int DEF_N,Complex[][] CORNER,int[] corner,Color C) {
        PolygonChopper PC=new PolygonChopper(W);
        double[] x=new double[4];
        GeneralPath gp=new GeneralPath();
        SmallPolygon X=new SmallPolygon();
        
        if (IN_N+DEF_N==0) {
            return null;
        }

        for(int i=0;i<IN_N;++i) {
            gp.append(IN[i].toGeneralPath(), false);
        }
        
        for(int i=0;i<DEF_N;++i) {
            gp.append(DEF[i].toGeneralPath(), false);
        }
        
        for(int i=0;i<=2;++i) {
            if(corner[i]==1) {
                X=new SmallPolygon(CORNER[i],3);
                gp.append(X.toGeneralPath(),false);
            }
        }
        
        return (new DyadicTile(W, gp, C));
    }


    public static DyadicTile medianPlotSolid(String W,VertexPair V0,DyadicSquare INIT,DyadicSquare[] IN,int IN_N,DyadicSquare[] DEF,int DEF_N,Complex[][] CORNER,int[] corner,Color C) {
        PolygonChopper PC=new PolygonChopper(W);
        double[] x=new double[4];
        Area A=new Area();
        SmallPolygon X=new SmallPolygon();
        
        if (IN_N+DEF_N==0) {
            return null;
        }
        
	Complex zz=new Complex(.421875,.421875);

        for(int i=0;i<IN_N;++i) {
	    X=PC.medianChopSquare(V0,IN[i]);
            if(X.N>2) A.add(new Area(X.toGeneralPath()));
        }
        
        for(int i=0;i<DEF_N;++i) {
            X=PC.chopSquare(DEF[i]);
	    X=PC.medianChopPolygon(V0,X,DEF[i]);
            if(X.N>2) A.add(new Area(X.toGeneralPath()));
        }
        
        for(int i=0;i<=2;++i) {
            if(corner[i]==1) {
                X=new SmallPolygon(CORNER[i],3);
		INIT.printPlayers();
		X=PC.medianChopPolygon(V0,X,INIT);
                if(X.N>2) A.add(new Area(X.toGeneralPath()));
            }
        }
        
        return (new DyadicTile(W, A, C));
    }
    
    
    
    
    
    public static DyadicTile medianPlotBoxes(String W,VertexPair V0,DyadicSquare INIT,DyadicSquare[] IN,int IN_N,DyadicSquare[] DEF,int DEF_N,Complex[][] CORNER,int[] corner,Color C) {
        PolygonChopper PC=new PolygonChopper(W);
        double[] x=new double[4];
        GeneralPath gp=new GeneralPath();
        SmallPolygon X=new SmallPolygon();
        
        if (IN_N+DEF_N==0) {
            return null;
        }

        for(int i=0;i<IN_N;++i) {  
        X=PC.medianChopSquare(V0,IN[i]);
        if(X.N>2) gp.append(X.toGeneralPath(),false);
        }
        
        for(int i=0;i<DEF_N;++i) {
        X=PC.chopSquare(DEF[i]);
	X=PC.medianChopPolygon(V0,X,DEF[i]);  
        if(X.N>2) gp.append(X.toGeneralPath(),false);
        }
        
        for(int i=0;i<=2;++i) {
            if(corner[i]==1) {
                X=new SmallPolygon(CORNER[i],3);	
                X=PC.medianChopPolygon(V0,X,INIT);
                if(X.N>2) gp.append(X.toGeneralPath(),false);
            }
        }
        
        return (new DyadicTile(W, gp, C));
    }


}