/*
 * BLikeTile.java
 *
 * Created on December 8, 2005, 7:43 AM
 */

import java.awt.*;
import java.awt.geom.*;
import java.util.TreeSet;

/**
 * This class stores and manipulates data for the dyadic tiles.
 *
 *
 * @author  pat
 */
public class DyadicTile implements Tile {
    public String W;  // the word
    public Shape P;   // stores the tile outline
    public Color C;   // color of the tile   
    int record_active, dyadic_size;
    public int[][] record;
    public int boxes;
    public int depth;
    public int time;
    public int[][] exceptions=new int[20][2];
    Complex Z;
    
    public DyadicTile() {}
    public DyadicTile(String W, Shape P, Color C){
        this.W=W;
        this.P=P;
        this.C=C;
    }
    
    public DyadicTile(DyadicTile T) {
        W=T.W;
        P=T.P;
        C=T.C;
    }
    
// This turned out not to be useful    
//    /** Construct the union of two dyadic tiles. This takes the word and the
//     * color of the first tile, and unions the two tile shapes together. */
//    public static DyadicTile union(DyadicTile tile1, DyadicTile tile2){
//        if (tile1==null) {
//            if (tile2==null)
//                return null;
//            return new DyadicTile(tile2);
//         }
//        if (tile2==null) {
//            return new DyadicTile(tile1);
//        }        
//        Area A=new Area(tile1.P);
//        A.add(new Area(tile2.P));        
//        return new DyadicTile(tile1.W, A, tile1.C);
//   }
    
    public String getStringWord() {
        return W;
    }
    
    public boolean isPaintable() {
        return true;
    }
    
    public boolean isSaveable() {
        return true;
    }
    
    
    public void paint(Graphics2D g, AffineTransform T) {
        g.setColor(C);
        g.fill(T.createTransformedShape(P));
        g.setColor(Color.black);
        g.draw(T.createTransformedShape(P));
    }
    
    public void paintSelected(Graphics2D g, AffineTransform T) {
        g.setColor(C);
        g.fill(T.createTransformedShape(P));
        g.setColor(Color.white);
        g.setStroke(new BasicStroke((float)1.0));
        g.setColor(Color.white);
        g.draw(T.createTransformedShape(P));
        g.setStroke(new BasicStroke((float)1.0));
    }
    
    public String saveString() {
        return
        "START DyadicTile\n"+
        "word "+W+"\n"+
        "END";
    }
    
    public Rectangle2D getBounds() {
        return P.getBounds2D();
    }
    
    public boolean contains(double x, double y) {
        return P.contains(x,y);
    }
    
    public void setColor(Color C) {
        this.C=C;
    }
    
}
