import java.applet.Applet;
import java.awt.event.*;
import java.awt.*;
import java.awt.geom.*;

public class ExplainCanvas extends DBCanvas 
implements MouseListener, HearingExplain {
    
    String[] S=new String[200];
    String[] P=new String[100];
    int paragraphs;
    int linecount;
    String MAIN;
    ListenSquare F;
    Manager M;
    IntegerSelector I1,I2,I3,I4;
    Integer[] J=new Integer[200];
    ListenSquare L;
    
    
    
    public ExplainCanvas(Manager M) {
        // add the manager
        this.M=M;
        // make it listen for new documentation
        M.hearExplain(this);
        
        addMouseListener(this);
        setBackground(Color.black);
        I1=new IntegerSelector(185,5,40,20,50,25,200,10);
        I2=new IntegerSelector(25,5,40,20,0,0,199,1);
        I4=new IntegerSelector(105,5,40,20,1,1,20,1);
        I3=new IntegerSelector(265,5,40,20,12,8,22,1);
        for(int i=0;i<=199;++i) J[i]=new Integer(i);
        L=new ListenSquare(2,2,12,12,Color.black);
        L.on=1;
        paragraphs=0;
        setup();
    }
    
    
    
    public int wordBreak(String A,int n) {
        String AA=new String();
        for(int i=n;i>0;--i) {
            AA=A.substring(i,i+1);
            if(AA.compareTo(" ")==0) return(i);
        }
        return(n);
    }
    
    
    public void findBreaks(String A) {
        int count=0;
        int pos1=0;
        String AA=new String();
        for(int i=0;i<A.length();++i) {
            AA=A.substring(i,i+1);
            if(AA.compareTo("\n")==0) {
                P[count]=A.substring(pos1,i);
                ++count;
                pos1=i;
            }
        }
        P[count]=A.substring(pos1,A.length());
        ++count;
        paragraphs=count;
    }
    
    
    
    public void paragraphDisplay(String A,int n) {
        
        int L=A.length();
        String AA=new String();
        int pos1=0;
        int pos2=0;
        int count=0;
        int LL=L;
        while(LL>0) {
            pos2=pos1+n;
            if(pos2>=L) {
                S[count+linecount]=A.substring(pos1,L);
                LL=0;
            }
            
            if(pos2<L) {
                pos2=wordBreak(A,pos2);
                S[count+linecount]=A.substring(pos1,pos2);
                ++count;
                LL=LL-(pos2-pos1);
                pos1=pos2;
            }
        }
        linecount=linecount+count+1;
    }
    
    
    
    
    
    public void display(int n) {
        for(int i=0;i<=199;++i) S[i]="";
        findBreaks(MAIN);
        linecount=0;
        for(int i=0;i<paragraphs;++i) {
            paragraphDisplay(P[i],n);
        }
    }
    
    
    
    public void paint(Graphics gfx) {
        
        
        Graphics2D g=(Graphics2D) gfx;
        
        g.setRenderingHint(RenderingHints.KEY_ANTIALIASING,
        RenderingHints.VALUE_ANTIALIAS_ON);
        
        L.infoRender(g);
        I1.render(g,Color.red,Color.white,Color.red);
        I2.render(g,new Color(50,100,255),Color.white,new Color(100,150,255));
        I3.render(g,new Color(0,255,0),Color.white,new Color(0,220,0));
        I4.render(g,new Color(0,0,220),Color.white,new Color(50,100,255));
        
        g.setFont(new Font("Helvetica",Font.PLAIN,I3.val));
        int space=I3.val+3;
        display(I1.val);
        Dimension D=this.getSize();
        for(int i=0;i<=199;++i) {
            
            if(45+space*i<D.height-space+5) {
                g.setColor(new Color(100,150,255));
                g.drawString(J[i+I2.val].toString(),5,45+space*i);
                g.setColor(Color.white);
                g.drawString(S[i+I2.val],35,45+space*i);
            }
        }
        
        g.setColor(Color.white);
        g.drawRect(0,0,D.width-1,D.height-1);
        
    }
    
    
    
    
    
    
    public void mousePressed(MouseEvent e) {}
    public void mouseReleased(MouseEvent e) {}
    public void mouseEntered(MouseEvent e) {}
    public void mouseExited(MouseEvent e) {}
    public void mouseClicked(MouseEvent e) {
        Point X=new Point();
        e.consume();
        X.x=e.getX();
        X.y=e.getY();
        I1.modify(X);
        I2.modify(X);
        I3.modify(X);
        I4.modify(X);
        I2.step=I4.val;
        if(L.inside(X)==1) setup();
        repaint();
    }
    
    public void setup() {
        I2.val=0;
        MAIN="Web McBilliards\n\nby Pat Hooper and Rich Schwartz\n\n This applet is a web-based version of our program McBilliards.  Ths purpose of this applet is to let the user explore periodic billiard paths in triangles.  The window you are currently reading is the info window. You scroll the text using the light blue arrow keys above\n\nVarious parts of the applet have little boxes with question marks in them.  If you click on these info boxes, this window will document the corresponding part of the appet. \n\n We already mentioned that you can scroll the text by clicking on the light blue arrow keys.  Here are some other control features of this window:\n \n You can change the scroll amount by clicking on the darker blue arrow keys.\n \n You can change the width of the text by clicking on the red arrow keys.\n \n You can change the font size by clicking on the green arrow keys.";
    }
    
    
    /** Display documenation for the string doc. This is part of the 
     * HearingExplain implementation. */
    public void setExplain(String doc) {
        I2.val=0;
        MAIN=doc;
        repaint();
    }
    
}

