/*
 * ExternNewtonPlot.java
 *
 * Created on November 4, 2005, 2:43 PM
 */

import java.io.*;
import java.lang.*;
import java.awt.geom.GeneralPath;
import java.awt.Color;
import java.util.*;

/**
 *
 * @author  pat
 */
public class ExternSearch extends Thread {
    private BasicSearcher bs;
    private Complex tri; // coordinates for triangle
    private int depth;
    private String cmd;
    
    /** Creates a new instance of ExternNewtonPlot,
     * and runs the plot (not as a thread).
     */
    private ExternSearch(Complex z, int depth, BasicSearcher BS) {
        this.bs=BS;
        this.tri=z;
        this.depth=depth;
    }
    
    public static ExternSearch SlalomSearch(Complex z, int depth, BasicSearcher BS){
        ExternSearch ESS=new ExternSearch(z,depth,BS);
        ESS.cmd="External/java_helper C2/slalom";
        ESS.start();
        return ESS;
    }
    
    /** Returns true if the ExternNewtonPlot should be runnable without errors */
    public static boolean canRunSlalom(){
        SecurityManager SM=System.getSecurityManager();
        if (SM==null) {
            //System.out.println("No SecurityManager Present!");
        } else {
            try {
                System.getSecurityManager().checkExec("External/java_helper");
            } catch (Throwable t) {
                //t.printStackTrace();
                return false;
            }
        }
        if (! (new File("External/C2/slalom")).exists()){
            System.out.println("Warning: External program \"slalom\" not compiled. "+
            "This will disable some features.");
            return false;
        }
        //System.out.println("SecurityManager allows execution.");
        return true;
    }

    public static ExternSearch PalindromeSearch(Complex z, int depth, BasicSearcher BS){
        ExternSearch ESS=new ExternSearch(z,depth,BS);
        ESS.cmd="External/java_helper C2/pal_search";
        ESS.start();
        return ESS;
    }
    
    /** Returns true if the ExternNewtonPlot should be runnable without errors */
    public static boolean canRunPalindrome(){
        SecurityManager SM=System.getSecurityManager();
        if (SM==null) {
            //System.out.println("No SecurityManager Present!");
        } else {
            try {
                System.getSecurityManager().checkExec("External/java_helper");
            } catch (Throwable t) {
                //t.printStackTrace();
                return false;
            }
        }
        if (! (new File("External/C2/pal_search")).exists()){
            System.out.println("Warning: External program \"pal_search\" not compiled. "+
            "This will disable some features.");
            return false;
        }
        //System.out.println("SecurityManager allows execution.");
        return true;
    }

        public static ExternSearch OddSquareSearch(Complex z, int depth, BasicSearcher BS){
        ExternSearch ESS=new ExternSearch(z,depth,BS);
        ESS.cmd="External/java_helper C2/odd_sqr_srch";
        ESS.start();
        return ESS;
    }
    
    /** Returns true if the ExternNewtonPlot should be runnable without errors */
    public static boolean canRunOddSquare(){
        SecurityManager SM=System.getSecurityManager();
        if (SM==null) {
            //System.out.println("No SecurityManager Present!");
        } else {
            try {
                System.getSecurityManager().checkExec("External/java_helper");
            } catch (Throwable t) {
                //t.printStackTrace();
                return false;
            }
        }
        if (! (new File("External/C2/odd_sqr_srch")).exists()){
            System.out.println("Warning: External program \"odd_sqr_srch\" not compiled. "+
            "This will disable some features.");
            return false;
        }
        //System.out.println("SecurityManager allows execution.");
        return true;
    }
    
    /** Start the search! It will return the results to the HearingSpaceTile.
     * If the plot is unsuccessful it will return null to the HearingSpaceTile. */
    public void run(){
        try {
            {   // start the search
                Process P=Runtime.getRuntime().exec(cmd);
                Writer out = new BufferedWriter(new OutputStreamWriter(P.getOutputStream()));
                out.write(""+tri.x+"\n");
                out.write(""+tri.y+"\n");
                out.write(""+depth+"\n");
                out.flush();
                
                P.waitFor();
                
                BufferedReader in=new BufferedReader(new InputStreamReader(P.getInputStream()));
                String line;
                LinkedList list=new LinkedList();
                while ((line=in.readLine())!=null) {
                    //System.out.println(line);
                    list.add(line);
                }
                String[] results=new String[list.size()];
                int i=0;
                for (ListIterator it=list.listIterator(); it.hasNext();i++)
                    results[i]=(String)(it.next());
                bs.doneBasicSearch(new BasicSearchResults(results,tri));
            }
        } catch (InterruptedException e) {
            // search canceled by call to interrupt()
            bs.doneBasicSearch(null);
        } catch (Throwable t) {
            t.printStackTrace();
            bs.doneBasicSearch(null);
        }
    }
}
