

/*BASIC DRAWING ROUTINE*/


/* this routine starts with
   z, a center point for the tile
   q, a complex number representing a direction
   and then finds a complex number z' 
   such that z'-z is a multiple of q.
   The point lies on the boundary
   of the unit square.  */


complex extrapolate(q,z)
     complex q,z;
{
  complex sq[5];
  complex bdy[5];
  complex u;
  double t;  
  complex w;

  u=unit(z);
  u=times(u,convert(2.0,0));

  sq[1]=convert(0.0,0.0);
  sq[2]=convert(1.0,0.0);
  sq[3]=convert(1.0,1.0);
  sq[4]=convert(0.0,1.0); 

  if((z.x>=0)&&(z.y>=0)) {
    bdy[1]=intersect(q,sq[3],plus(q,u),sq[4]);
    bdy[2]=intersect(q,sq[3],plus(q,u),sq[2]);
  }

  if((z.x>=0)&&(z.y<=0)) {
    bdy[1]=intersect(q,sq[1],plus(q,u),sq[2]);
    bdy[2]=intersect(q,sq[3],plus(q,u),sq[2]);
  }

  if((z.x<=0)&&(z.y<=0)) {
    bdy[1]=intersect(q,sq[1],plus(q,u),sq[2]);
    bdy[2]=intersect(q,sq[1],plus(q,u),sq[4]);
  }

  if((z.x<=0)&&(z.y>=0)) {
    bdy[1]=intersect(q,sq[3],plus(q,u),sq[4]);
    bdy[2]=intersect(q,sq[1],plus(q,u),sq[4]);
  }  
    t=fabs(bdy[1].x-.5);
    if(t<=.5) return(bdy[1]);
    return(bdy[2]);
}


/*find edge from center point.*/

int inside_tile(w,q)
     word w;
     complex q;
{
  triangle_list J;
  J=apply(w,triangle_make(q));
  return(strong_test(J));
}


complex find_edge2(w,z,step,e)
     word w;
     complex z;    //center point
     complex step; //direction
     double e;     //tolerance for error
{
  complex q[5];
  triangle_list J;
  int test;
  q[1]=z;
  q[3]=extrapolate(z,step);
  while(dist(q[1],q[3])>e)
    {  
      q[2]=interpolate(q[1],q[3]);
      test=inside_tile(w,q[2]);
      if(test==0) q[3]=q[2];
      if(test==1) q[1]=q[2];
    }
  return(q[2]);
}



complex find_edge(w,z,step,e)
     word w;
     complex z;    //center point
     complex step; //direction
     double e;     //tolerance for error
{
  complex q[5];
  triangle_list J;
  int test;
  unfold U;
  q[1]=z;
  q[3]=extrapolate(z,step);
  U=edge_structure(w);
  while(dist(q[1],q[3])>e)
    {  
      q[2]=interpolate(q[1],q[3]);
      U=assign_geometry(U,q[2]);
      test=corridor_test(U);
      if(test==0) q[3]=q[2];
      if(test==1) q[1]=q[2];
    }
  return(q[2]);
}


/*the basic routine works by incrementing step
  so that it gives d evenly spaced points on
  the unit circle.  For each of these points, 
  the previous routines are invoked to 
  find the edge of the tile in the direction
  of step. */

void basic_draw(file,w,z,d) 
  FILE *file;
  word w;
  complex z;
  int d;
{
  int i;
  double ii;
  complex step,zz;
  word ww;

  ww=start_with_three(w);

  for(i=1;i<=d;++i)
    {   
      ii=2.0*Pi*i/d;
      step=convert(cos(ii),sin(ii));
      zz=find_edge(ww,z,step,.0000000001);
      tcl_cpt2(file,zz);
    }
}



