

/*tests performed on words*/



 /*balance test:
   in geometric terms, this routine tests whether the
   combinatorial path determined by the word is a
   closed loop.*/

int balance(J)
     triangle_list J;
{
  int i,a,b,c,m1,m2;
  if(J.l%2==1) return(1);
  a=0;
  b=0;
  c=0;
  for(i=1;i<=J.l/2;++i)
    {
      m1=J.T[2*i-1].history;
      m2=J.T[2*i-0].history;
      if((m1==1)&&(m2==2)) ++a;
      if((m1==2)&&(m2==3)) ++b;
      if((m1==3)&&(m2==1)) ++c;
      if((m1==2)&&(m2==1)) --a;
      if((m1==3)&&(m2==2)) --b;
      if((m1==1)&&(m2==3)) --c;
    }
  if((a==b)&&(b==c)) return(0);
  return(1);
  /*0 is good*/
}




/* lexi_test
   This checks to make sure a word has no subwords which come earlier
   lexicographically. This eliminates checking cyclic reorderings.
   The way it works:
   w.lex refers to a subword, w', starting at w.lex and running until 
   the end of w. Specifically w.lex is chosen so that w' agrees with
   w at least up to letter w.l-1, then it may be larger or may be bigger:
   (eg: in example if w=123121, w.lex=4 and w fails the test because
        w'=121 comes before w lexigraphically.
	however if w=12313, w.lex=4, then w passes the test and
        w.lex is changed to 6, because the null word is the longest subword
        running till the end of the word, which agrees with w for all time.)
    lexi_test also checks the inverse word.
*/

int lexi_test(w)
     word w;
{
  int i;
  // subword test:
  if (w.n[w.l]<w.n[w.l-w.lexi+1]) return(0); // bad fails test
  if (w.n[w.l]>w.n[w.l-w.lexi+1]) w.lexi=w.l+1;  
  // inverse subword test:
  i=1;
  while ((i<=w.l/2)&&(w.n[w.l+1-i]==w.n[i])) 
    {
      i=i+1;
      if (w.n[w.l+1-i]<w.n[i]) return(0);
    }
    return(w.lexi); 
  /*0 is bad*/
}





/* geometric tests*/

/*when a triangle is unfolded according to a word,
it makes a kind of strip.  This next routine picks
out the vertices along this strip.  When i is odd,
the endpoint is on the left side.  When i is even
the endpoint is on the right side.  These vertices
are then used, in the routines weak_test and strong_test,
to decide whether or not the word
is a closed orbit for the particular triangle*/



complex vertex(k,T,i)
     int k;
     triangle T;
     int i;
{
  complex z1,z2;
  int h;
  h=T.history;
  if(i%2==1) 
    {
    if(h==1) 
      {
       z1=T.z2;
       z2=T.z3;
      }
    if(h==2) 
      {
       z1=T.z3;
       z2=T.z1;
      }
    if(h==3) 
      {
       z1=T.z1;
       z2=T.z2;
      }
    }

  if(i%2==0) 
    {
    if(h==1) 
      {
       z1=T.z3;
       z2=T.z2;
      }
    if(h==2) 
      {
       z1=T.z1;
       z2=T.z3;
      }
    if(h==3) 
      {
       z1=T.z2;
       z2=T.z1;
      }
    }
  if(k==1) return(z1);
  if(k==2) return(z2);
  return(z1);
}




/*the weak test can be described as follows. 
Each word determines a kind of strip of triangles.
This strip has left vertices and right vertices.
Suppose L is the line joining the first and last
left vertex.  Suppose r is some right vertex.
If the word in question is the prefix of a
good word then r should be to the right of L.  
This is tested by computing the signed area
of the triangle made by L and r.  It should be positive.
The same test then is applied, with the roles
of right and left reversed.*/




int weak_test(J)
     triangle_list J;
{
complex z1,z2,z3,z4,z5,z6;
int l,i;
l=J.l;
 if(l%2==1) return(1);
 z1=vertex(1,J.T[1],1);
 z2=vertex(2,J.T[1],1);
 z3=vertex(1,J.T[l],l);
 z4=vertex(2,J.T[l],l);
 for(i=2;i<l;++i)
   {
     z5=vertex(1,J.T[i],i);
     z6=vertex(2,J.T[i],i);
     if(area(z6,z1,z3)<=0.0) return(0);
     if(area(z5,z2,z4)>=0.0) return(0);
   }
 return(1);
}


/*the strong test checks that the word represents a
closed billiard path on the triangle.  Given a balanced
word, the strip of triangles has the first and last
edges parallel.  Suppose the strip is (real) affinely
normalized so that these edges are horizontal.  Then
the strong test checks that the x-coordinates of all
the left vertices are less than the x-coordinates of
all the right vertices.  This is sufficient.*/

int strong_test(J)
     triangle_list J;
{

 complex z1,z3,z5,z6;
 int h1,l,i;
 double test,max,min;

 if(balance(J)!=0) return(0); 
 l=J.l;
 h1=J.T[1].history;

 if(h1==1) 
   {
     z1=J.T[1].z2;
     z3=J.T[l].z2;
   }

 if(h1==2) 
   {
     z1=J.T[1].z3;
     z3=J.T[l].z3;
   }

 if(h1==3) 
   {
     z1=J.T[1].z1;
     z3=J.T[l].z1;
   }

 max=-10000.0;
 min=10000.0;

 for(i=1;i<=l;++i)
   {
     z5=vertex(1,J.T[i],i);
     z6=vertex(2,J.T[i],i);
     test=area(z1,z3,z5);
     if(max<test) max=test; 
     test=area(z1,z3,z6);
     if(min>test) min=test;
     }
 /*1 is good*/ 
 if(max<min) return(1);
 return(0);

}





