 
triangle reflect(i,j,T)
     int i;
     int j;
     triangle T;
{
  complex z[12];
  triangle S;
  int sign;

 
  sign=2;
  if(i%2==1) sign=-2;



  if(j==1) 
    {
      z[1]=T.z1;
      z[2]=T.z2;
      z[3]=T.z3;
      S.a1=T.a1;
      S.a2=T.a2+sign;
      S.a3=T.a3-sign;
    }
  if(j==2) 
    {
      z[1]=T.z2;
      z[2]=T.z3;
      z[3]=T.z1;
      S.a2=T.a2;
      S.a3=T.a3+sign;
      S.a1=T.a1-sign;
    }

 if(j==3) 
    {
      z[1]=T.z3;
      z[2]=T.z1;
      z[3]=T.z2;  
      S.a3=T.a3;
      S.a1=T.a1+sign;
      S.a2=T.a2-sign;
    }


 z[4]=minus(z[1],z[2]);
 z[5]=conjugate(z[4]);	
 z[6]=minus(z[3],z[2]);
 z[7]=conjugate(z[6]);
 z[8]=divide(z[6],z[7]);
 z[9]=times(z[5],z[8]);
 z[10]=plus(z[9],z[2]);
 S.z1=T.z1;
 S.z2=T.z2;
 S.z3=T.z3;
 if(j==1) S.z1=z[10];
 if(j==2) S.z2=z[10];
 if(j==3) S.z3=z[10];
 S.history=j;
 return(S);
}


triangle_list apply(W,T)
     word W;
     triangle T;
{
  int i;
  triangle_list J;
  J.T[0]=T;
  for(i=1;i<=W.l;++i)
    {
      J.T[i]=reflect(i,W.n[i],J.T[i-1]);
    }
  J.l=W.l;
  return(J);
}


triangle assign_labels(k,S)
     int k;
     triangle S;
{
  triangle T;
  T=S;

 if(k==1) {
    T.a1=0;
    T.a2=1;
    T.a3=-1;
  }
  if(k==2) {
    T.a1=-1;
    T.a2=0;
    T.a3=1;
  }
  if(k==3) {
    T.a1=1;
    T.a2=-1;
    T.a3=0;
  }
  return(T);
}


int vertex_type(z0,T)
     complex z0;
     triangle T;
{
  int type;
  type=0;
  if(dist(T.z1,z0)<.00000001) type=1;
  if(dist(T.z2,z0)<.00000001) type=2;
  if(dist(T.z3,z0)<.00000001) type=3;
  return(type);
}


complex get_endpoint(k,X)
     int k;
     triangle_list X;
{
  complex z1,z2,z3,z4;
  int history,len;
  len=X.l;
  history=X.T[1].history;

  if(history==1) 
   {
     z1=X.T[1].z2;
     z3=X.T[len].z2;
     z2=X.T[1].z3;
     z4=X.T[len].z3;
   }

  if(history==2) 
   {
     z1=X.T[1].z3;
     z3=X.T[len].z3;
     z2=X.T[1].z1;
     z4=X.T[len].z1;
   }

  if(history==3) 
   {
     z1=X.T[1].z1;
     z3=X.T[len].z1;
     z2=X.T[1].z2;
     z4=X.T[len].z2;
   }

  if(k==1) return(z1);
  if(k==2) return(z2);
  if(k==3) return(z3);
  return(z4);
}



double get_corridor(k,X) 
     int k;
     triangle_list X;
{
  complex z1,z2,z3,z4,z5,z6;
  int i;
  double max,min,test;

  z1=get_endpoint(1,X);
  z2=get_endpoint(2,X);
  z3=get_endpoint(3,X);
  z4=get_endpoint(4,X);

  max=-10000.0;
  min=10000.0;

  for(i=1;i<X.l;++i)
   {
     z5=vertex(1,X.T[i],i);
     z6=vertex(2,X.T[i],i);
     test=area(z1,z3,z5)/fabs(area(z1,z2,z3));
     if(max<test) max=test; 
     test=area(z1,z3,z6)/fabs(area(z1,z2,z3));
     if(min>test) min=test;
   }
  if(k==2) return(min);
  return(max); 
}

complex get_corridor_center(X)
     triangle_list X;
{
  complex z1,z2,z7;
  double d1,d2,d3;
  z1=get_endpoint(1,X);
  z2=get_endpoint(2,X);

  d1=get_corridor(1,X);
  d2=get_corridor(2,X);


  d3=0.5;
  z7.x=d3*z1.x+(1.0-d3)*z2.x;
  z7.y=d3*z1.y+(1.0-d3)*z2.y;
  return(z7);
}


double get_width(X)
     triangle_list X;
{
  double d1,d2,d3,d4;
  d1=norm(minus(X.T[1].z1,X.T[1].z2));
  d2=norm(minus(X.T[1].z2,X.T[1].z3));
  d3=norm(minus(X.T[1].z3,X.T[1].z1));
  d4=d1;
  if(d2>d4) d4=d2;
  if(d3>d4) d4=d3;
  return(d4);
}


/*this routine begins with a word and a triangle
  and draws the unfolding.*/

void tcl_unfold(file,w,TT)
     word w;
     triangle TT;
     FILE *file;
{
  triangle_list X;
  triangle U;
  complex z1,z2,z3,z4,z5,z6,z7,z8,direction,center,anchor;
  int i,history,l,v1,v2;
  double test,max,min,ii,scale;
  triangle T;
  int leader1,leader2;

  T=assign_labels(w.n[1],TT);

  X=apply(w,T);
  l=X.l;  
  history=X.T[1].history;

  z1=get_endpoint(1,X);
  z2=get_endpoint(2,X);
  z3=get_endpoint(3,X);
  z4=get_endpoint(4,X);
  direction=unit(minus(z1,z3));
  scale=get_width(X);
  direction.x=.2*get_width(X)*direction.x;
  direction.y=.2*get_width(X)*direction.y;
  center=get_corridor_center(X);
  center=divide(center,direction); 

  /*draw triangles*/
  for(i=1;i<=X.l;++i) {
    U.z1=divide(X.T[i].z1,direction);
    U.z2=divide(X.T[i].z2,direction);
    U.z3=divide(X.T[i].z3,direction);
    U.z1=minus(U.z1,center);
    U.z2=minus(U.z2,center);
    U.z3=minus(U.z3,center);
    U.a1=X.T[i].a1;
    U.a2=X.T[i].a2;
    U.a3=X.T[i].a3;
    tcl_tri(2,file,U,1);
  }

  /*draw corridor*/
    ii=get_corridor(1,X);
    ii=1.0-ii;
    z7.x=ii*z1.x+(1.0-ii)*z2.x;
    z7.y=ii*z1.y+(1.0-ii)*z2.y;
    z8.x=ii*z3.x+(1.0-ii)*z4.x;
    z8.y=ii*z3.y+(1.0-ii)*z4.y;
    z7=divide(z7,direction);
    z8=divide(z8,direction);  
    z7=minus(z7,center);
    z8=minus(z8,center);
    tcl_spt(file,z7,z8,2);

    ii=get_corridor(2,X);
    ii=1.0-ii;
    z7.x=ii*z1.x+(1.0-ii)*z2.x;
    z7.y=ii*z1.y+(1.0-ii)*z2.y;
    z8.x=ii*z3.x+(1.0-ii)*z4.x;
    z8.y=ii*z3.y+(1.0-ii)*z4.y;
    z7=divide(z7,direction);
    z8=divide(z8,direction);  
    z7=minus(z7,center);
    z8=minus(z8,center);
    tcl_spt(file,z7,z8,2);

    min=get_corridor(2,X);
    max=get_corridor(1,X);
  for(i=X.l;i>=1;--i)
    {
     z5=vertex(1,X.T[i],i);
     z6=vertex(2,X.T[i],i);
     test=area(z1,z3,z5)/fabs(area(z1,z2,z3));;
     if(fabs(test-max)<.00000001) leader1=i;
     test=area(z1,z3,z6)/fabs(area(z1,z2,z3));
     if(fabs(test-min)<.00000001) leader2=i;
    }


    /*record leading vertices*/
     z5=vertex(1,X.T[leader1],leader1);
     z6=vertex(2,X.T[leader2],leader2);
     z5=divide(z5,direction);
     z5=minus(z5,center);
     tcl_cpt(file,z5,1);
     z6=divide(z6,direction);
     z6=minus(z6,center);
     tcl_cpt(file,z6,2);

     /*record leading vertex numbers*/

     fprintf(file,"4\n");
     fprintf(file,"%d\n",leader1);
     z5=vertex(1,X.T[leader1],leader1);
     leader1=vertex_type(z5,X.T[leader1]);
     fprintf(file,"%d\n",leader1);
     fprintf(file,"5\n");
     fprintf(file,"%d\n",leader2);
     z6=vertex(2,X.T[leader2],leader2);
     leader2=vertex_type(z6,X.T[leader2]);
     fprintf(file,"%d\n",leader2);  
}



/*this routine converts a word into a path along
  the hexagonal grid.  Each of the 6 two-letter
  combinations 12 23 31 21 32 13 are is converted
  into a 6th root of unity and then these roots
  are all concatenated to make the path.  The
  routine makes two passes.  On the first pass,
  it computes the bounding box for the path.
  On the second pass, it scales the path to
  fit optimally into the unit square. Finally,
  it multiplies by a fudge factor of 12.0 so
  as to draw nicely on the interface.*/


void tcl_path(file,w,comp)
     word w;
     FILE *file;
     complex comp;
{
  int i,m1,m2;
  complex z0,z1,z2,w1,w2,w3;
  complex ww1,ww2,ww3;
  double a1,a2,a3;
  complex aa1,aa2,aa3;
  triangle T,U;
  triangle_list X;
  double scale;
  complex direction,center;

  //roots of unity
  w3=convert(cos(2.0*Pi/3.0),sin(2.0*Pi/3.0));
  w2=convert(cos(4.0*Pi/3.0),sin(4.0*Pi/3.0));
  w1=convert(cos(6.0*Pi/3.0),sin(6.0*Pi/3.0));
  ww1=convert(cos(Pi/6.0),sin(Pi/6.0));
  w1=times(ww1,w1);
  w2=times(ww1,w2);
  w3=times(ww1,w3);

  T=triangle_make(comp);
  T=assign_labels(w.n[1],T);

  X=apply(w,T);

  z0=convert(0.0,0.0);
  scale=1.0;
  fprintf(file,"%lf\n",scale);




  /*the wrap-around problem
      a1=1.0*X.T[w.l].a1;
      a2=1.0*X.T[w.l].a3;
      a3=1.0*X.T[w.l].a2;
      aa1=times(convert(a1,0.0),w1);
      aa2=times(convert(a2,0.0),w2);
      aa3=times(convert(a3,0.0),w3);
      z0=plus(plus(aa1,aa2),aa3);
  */

      a1=1.0*T.a1;
      a2=1.0*T.a3;
      a3=1.0*T.a2;
      aa1=times(convert(a1,0.0),w1);
      aa2=times(convert(a2,0.0),w2);
      aa3=times(convert(a3,0.0),w3);
      z0=plus(plus(aa1,aa2),aa3);

  for(i=1;i<=w.l;++i)
    {
      a1=1.0*X.T[i].a1;
      a2=1.0*X.T[i].a3;
      a3=1.0*X.T[i].a2;
      aa1=times(convert(a1,0.0),w1);
      aa2=times(convert(a2,0.0),w2);
      aa3=times(convert(a3,0.0),w3);
      z1=plus(plus(aa1,aa2),aa3);
      X.T[i].center=z1;
      tcl_spt(file,z0,z1,0);
      z0=z1;
    }



  /*normalizing constants*/
  ww2=get_endpoint(1,X);
  ww3=get_endpoint(3,X);
  direction=unit(minus(ww2,ww3));
  direction.x=.4*get_width(X)*direction.x;
  direction.y=.4*get_width(X)*direction.y;
  center=get_corridor_center(X);
  center=divide(center,direction); 




 /*draw triangles*/
  for(i=1;i<=X.l;++i) {

    U.z1=divide(X.T[i].z1,direction);
    U.z2=divide(X.T[i].z2,direction);
    U.z3=divide(X.T[i].z3,direction);
    U.z1=convert(-U.z1.x,U.z1.y);
    U.z2=convert(-U.z2.x,U.z2.y);
    U.z3=convert(-U.z3.x,U.z3.y);


    center=plus(plus(U.z1,U.z2),U.z3);
    center.x=center.x/3.0;
    center.y=center.y/3.0;
    center=minus(center,X.T[i].center);

    U.z1=minus(U.z1,center);
    U.z2=minus(U.z2,center);
    U.z3=minus(U.z3,center);
    U.a1=X.T[i].a1;
    U.a2=X.T[i].a2;
    U.a3=X.T[i].a3;
    tcl_tri(5,file,U,1);
  }
}







