// This runs a quick test on the triangle to see if a balanced word w 
// passes the strong test with triangle T.
// returns true=1 if passes false=0 if does not
int general_strong_test(w,T)
  word w;
  triangle T;
{
  reflection r;
  matrix m;
  Pletter l;
  pcomplex c;
  int sign, orient;
  double a,b, temp;

  // Set m=identity
  matrix_identity(&m);

  // Get the matrices corresponding to reflections in the sides of the 
  // triangle
  reflect_from_triangle(T,&r);

  l=w.first;
  while (l!=NULL){
    timesEquals(&m,&(r.m[l->l]));
    l=l->next;
  }

  c.x=-m.m[1][2];
  c.y=m.m[0][2]; // vector orthogonal to axis. 

  l=w.first;
  a=pcomplex_dot(c,T.z[(l->l+1)%3]);
  b=pcomplex_dot(c,T.z[(l->l+2)%3]);
  if (a<b)
    sign=1;
  else if (b<a)
    sign=-1;
  else return 0; // the two points lie along the axis
  // Note: now sign*a<sign*b


  // Set m=identity
  matrix_identity(&m);
  timesEquals(&m,&(r.m[l->l]));
  orient=1;

  while (l!=w.last){
    temp=pcomplex_dot(c,eucTimes(&m,T.z[l->l]));
    l=l->next;
    timesEquals(&m,&(r.m[l->l]));
    if ((l->prev->l+orient)%3==l->l){
      if (sign*a<sign*temp){
	a=temp;
	if (sign*a>=sign*b) return 0; // fails
      }
    } else {
      if (sign*temp<sign*b){
	b=temp;
	if (sign*a>=sign*b) return 0; //fails
      }
    }
    orient=3-orient;
  }
  return 1;
}

// This runs a quick test on the triangle to see if a balanced word w 
// passes the strong test with triangle T.
// returns true=1 if passes false=0 if does not
int general_strong_test_tol(w,T, tol)
  word w;
  triangle T;
  double tol;
{
  reflection r;
  matrix m;
  Pletter l;
  pcomplex c;
  int sign, orient;
  double a,b, temp;

  // Set m=identity
  matrix_identity(&m);

  // Get the matrices corresponding to reflections in the sides of the 
  // triangle
  reflect_from_triangle(T,&r);

  l=w.first;
  while (l!=NULL){
    timesEquals(&m,&(r.m[l->l]));
    l=l->next;
  }

  c.x=-m.m[1][2];
  c.y=m.m[0][2]; // vector orthogonal to axis. 

  l=w.first;
  a=pcomplex_dot(c,T.z[(l->l+1)%3]);
  b=pcomplex_dot(c,T.z[(l->l+2)%3]);
  if (a<b)
    sign=1;
  else if (b<a)
    sign=-1;
  else return 0; // the two points lie along the axis
  // Note: now sign*a<sign*b


  // Set m=identity
  matrix_identity(&m);
  timesEquals(&m,&(r.m[l->l]));
  orient=1;

  while (l!=w.last){
    temp=pcomplex_dot(c,eucTimes(&m,T.z[l->l]));
    l=l->next;
    timesEquals(&m,&(r.m[l->l]));
    if ((l->prev->l+orient)%3==l->l){
      if (sign*a<sign*temp){
	a=temp;
	if (sign*a>=sign*b-tol) return 0; // fails
      }
    } else {
      if (sign*temp<sign*b){
	b=temp;
	if (sign*a>=sign*b-tol) return 0; //fails
      }
    }
    orient=3-orient;
  }
  return 1;
}

// This sees if the given list of triangles is contained in a tile
// of the word_link
int redundancy_check(T,num,wl)
     triangle T[];  // triangle list
     int num;       // the number of triangles 
     word_link wl;
{
  word_link temp;
  int i;

  temp=wl;
  while (temp!=NULL){
    i=0;
    while ((i<num)&&(general_strong_test(temp->w,T[i])))
      i++;
    if (i==num)
      return 1; // there is a redundancy
    temp=temp->next;
  }
  return 0;
}
