// This code uses the Multi Slalom search algorithm to 
// attempt to fill a region of the space of triangles with
// tiles.

#include <stdlib.h>
#include <stdio.h>
#include <math.h>
#define Pi 3.141592653589
#include "plist.c"

void write_tile_data(file,w, z)
     FILE *file;
     word w;
     pcomplex z;
{
  fprintf(file,"BEGIN TILE\n");
  fprintf(file,"word\n");
  word_print_file(file,&w);
  fprintf(file,"center\n");
  fprintf(file,"%.16f\n",z.x);
  fprintf(file,"%.16f\n",z.y);
  fprintf(file,"color\n");
  fprintf(file,"aaa\n");
  fprintf(file,"END TILE\n");
  fflush(file);
}

int main(int argc, char *argv[]){
  FILE *file1, *file2, *fopen();
  int s,i,DEPTH,count;
  char out[50];
  triangle T, list[3];
  double area1,area2;
  triangle_queue tq;
  word w;
  word_link wl;

  if (argc<=1){
    printf("Argument expected- a filename\n");
    exit(0);
  }
  printf("Reading from file: %s\n",argv[1]);

  file1=fopen(argv[1],"r"); // We read in data from this file
  
  if (argc>=3)
    strcpy(out,argv[2]);
  else {
    strcpy(out,argv[1]);
    strcat(out,".mem");
  }
  printf("Writing to file: %s\n",out);
  file2=fopen(out,"w");
  if (file2==NULL){
    printf("Error opening file for writing.");
    exit(0);
  }

  fscanf(file1,"%d",&s); // Ignoring option

  fscanf(file1,"%d",&s); // Ignoring number

  // read the three triangles
  for (i=0; i<3; i++){
    fscanf(file1,"%lf",&(T.z[i].x)); // the first angle of our triangle
    fscanf(file1,"%lf",&(T.z[i].y)); // the second angle of our triangle
  }

  printf("Triangle 1: (%lf, %lf)\n", T.z[0].x, T.z[0].y);
  printf("Triangle 2: (%lf, %lf)\n", T.z[1].x, T.z[1].y);
  printf("Triangle 3: (%lf, %lf)\n", T.z[2].x, T.z[2].y);

  fscanf(file1,"%d",&DEPTH);    // the depth to search to


  // *****Set up some things 

  area1=triangle_area(&T);
  area2=0;

  tq_initialize(&tq);
  tq_push(&tq,T);

  wl=NULL;

  count=0;

  // *******End setting up

  while(tq.l>0){
    printf("----------------------------------------------\n");
    printf("%d parameter triangles remaining.\n",tq.l);
    printf("Area covered so far: %lf\%\n",area2/area1*100);
    printf("Using %d tiles.\n",count);    
    printf("Begin search.\n");

    T=tq_pop(&tq); // get the search triangle
    
    list[0]=triangle_make2(T.z[0]);
    list[1]=triangle_make2(T.z[1]);
    list[2]=triangle_make2(T.z[2]);
    
    //check for redundancies
    if (redundancy_check(list,3,wl)){
      printf("The parameter triangle lies in a tile we already found!\n");
      area2+=triangle_area(&T);     
    } else {
      w=fill_search(list,3,DEPTH);
      if (w.l==0){
	printf("No tile found. Subdivide triangle.\n");
	tq_push_division(&tq,T);
      } else {
	printf("Tile found! Word is of length %d.\n",w.l);
	printf("Writing data to file.\n");
	write_tile_data(file2,w,triangle_center(&T));
	wl=word_insert(wl,&w);
	area2+=triangle_area(&T);
	count++;
      }
    }
  }

  printf("----------------------------------------------\n");
  printf("Fill completed successfully.\n");

  word_link_destroy(wl);

  fclose(file1);
  fclose(file2);

  return 0;
}
