// Checks to see if w is a power of an even word
// Such a word is considered to be redunant even though it might
// pass the strong test
// word is assumed to of even length, though it will not fail if it is not
// returns 0 if fails 1 if passes
int power_test(w)
     word *w;
{
  Pletter l,m,n;
  
  //Make the word cyclic
  w->first->prev=w->last;
  w->last->next=w->first;

  l=w->first->next->next;
  while (l!=w->first){
    if (l->l==w->first->l){
      m=l->next;
      n=w->first->next;
      while ((m->l==n->l)&&(n!=w->first)){
	m=m->next;
	n=n->next;
      }
      if (n==w->first){
	// Fails test the cyclic word starting at l is the same word as w

	// Remove the cyclic structure to the word
	w->first->prev=w->last->next=NULL;

	return 0;
      }
    }	
    l=l->next->next;
  }

  // Remove the cyclic structure to the word
  w->first->prev=w->last->next=NULL;
  return 1;
}

 
int plexi_test(w)
     pword *w;
{
  Pletter l,m;
  int i;
  if (w->w.l<=2){
    if (w->w.l==2){
      w->lexi=w->w.first;
      w->lexi_count=0;
    }
    return 0;
  }
    
  if (w->lexi->l > w->w.last->l)
    return 1;  //fails

  //passes w.first part of test!
  if (w->lexi->l == w->w.last->l){
    w->lexi=w->lexi->next;
    w->lexi_count++;
  } else {
    // otherwise (w->lexi->l < w->w.last->l)
    w->lexi_count=0; 
    w->lexi=w->w.first;
  }

  //start the second part
  l=w->w.first;
  m=w->w.last;
  i=0;
  while ((l->l == m->l)&&(i++<w->w.l/2)){
    l=l->next;
    m=m->prev;
  }
  if (l->l > m->l)
    return 1; //fails
  return 0;
}

// checks to see if would pass the lexi test
// returns -1 fails test
//          0 passes, but you should reset the lexi pointer to w.first
//          1 passes, and you should set lexi=lexi->next
int future_plexi_test(w, l)
     pword *w; 
     int l;   
{
  int ret,i;
  Pletter n,m;

  if ((w->w.l<=1)||(w->lexi==NULL)){
    return 0; //passes
  }
  
  if (w->lexi->l > l){
    //fprintf(stdout,"fails w.first part of plexi\n"); 
    return -1;  //fails
  }
  //passes w.first part of test!

  if (w->lexi->l == l)
    ret=1;
  else 
    ret=0;


  //start the second part
  if (w->w.first->l == l){
    i=0;
    n=w->w.first->next;
    m=w->w.last;
    while ((n->l == m->l)&&(i++<(w->w.l-1)/2)){
      n=n->next;
      m=m->prev;
    }
    if (n->l > m->l)
      return -1; //fails
    return ret; //passes
  } else if (w->w.first->l > l)
    return -1; //fails
  return ret; //passes
}

// pbalance test with relation rel
int pbalance_wRel(w,rel)
     pword *w;
     int rel[3];
{
  int ret=0, comp=0;
  if (w->count[0]<0)
    ret-=w->count[0];
  else 
    ret+=w->count[0];
  if (w->count[1]<0)
    ret-=w->count[1];
  else 
    ret+=w->count[1];
  if (w->count[2]<0)
    ret-=w->count[2];
  else 
    ret+=w->count[2];

  if (w->count[0]<rel[0])
    comp+=rel[0]-w->count[0];
  else
    comp-=rel[0]-w->count[0];
  if (w->count[1]<rel[1])
    comp+=rel[1]-w->count[1];
  else
    comp-=rel[1]-w->count[1];
  if (w->count[2]<rel[2])
    comp+=rel[2]-w->count[2];
  else
    comp-=rel[2]-w->count[2];
  if (comp<ret){ // closer to rel than to 0
    w->count[0]-=rel[0];
    w->count[1]-=rel[1];
    w->count[2]-=rel[2];
    return comp;
  } else {
    comp=0;
    if (w->count[0]<-rel[0])
      comp+=-rel[0]-w->count[0];
    else
      comp-=-rel[0]-w->count[0];
    if (w->count[1]<-rel[1])
      comp+=-rel[1]-w->count[1];
    else
      comp-=-rel[1]-w->count[1];
    if (w->count[2]<-rel[2])
      comp+=-rel[2]-w->count[2];
    else
      comp-=-rel[2]-w->count[2];
    if (comp<ret){ // closer to -rel than to 0
      w->count[0]+=rel[0];
      w->count[1]+=rel[1];
      w->count[2]+=rel[2];
      return comp;
    }
  }
  return ret;
}

int pbalance(w)
     pword *w;
{
  int ret=0;
  if (w->count[0]<0)
    ret-=w->count[0];
  else 
    ret+=w->count[0];
  if (w->count[1]<0)
    ret-=w->count[1];
  else 
    ret+=w->count[1];
  if (w->count[2]<0)
    ret-=w->count[2];
  else 
    ret+=w->count[2];
  return ret;
}

int future_pbalance(w,l)
     pword *w;
     int l;
{
  if (w->mod2==1){
    if (w->count[l]>=0)
      return pbalance(w)+1;
    else
      return pbalance(w)-1;
  } 
  if (w->count[l]<=0)
    return pbalance(w)+1;
  else
    return pbalance(w)-1;  
  
}

// returns 0, throw out- return 1 keep.
int det_test(p)
     Ppoint p;
{
  int i=det(&(p->prev->z),&(p->z), &(p->next->z));
  if (i ==(p->prev->side)*(p->side)*(p->next->side))
    return 0;
  //if (i==2)
  //return 2;
  return 1;
}
 
Ppoint check_convexity(h)
     phull *h;
{
  Ppoint p=h->last_left, q=p->next;
  while (q!=p){
    if (det_test(q)==0)
      return q; //fails;
    q=q->next;
  }
  if (det_test(q)==0)
    return q; //fails;
  return NULL;
}

Ppoint on_right_test(z,h)
     pcomplex z; 
     phull *h;
{
  Ppoint p=h->last_right;
  while (p->prev->side==1){
    if (det(&(p->prev->z),&(p->z),&z)==1)
      return p;
    p=p->prev;
  }
  return NULL;
}

Ppoint on_left_test(z,h)
     pcomplex z;
     phull *h;
{
  Ppoint p=h->last_left;
  while (p->prev->side==-1){
    if (det(&(p->prev->z),&(p->z),&z)==-1)
      return p;
    p=p->prev;
  }
  return NULL;
}


// There must be at least 3 points in the phull
// 0 passes
// 1 fails
// 2 throws flag
int pweak_test(w)
     pword *w;
{
  Ppoint p;

  if (w->h.current==NULL) //already thrown out
    return 0; //passes
  if (det_test(w->h.current)==0){ //throwout the new point
    delete_from_hull(&(w->h),w->h.current);
    w->h.current=NULL;
    return 0; //passes
  } 
 //now assume this point is still here
  p=w->h.current->next;
  while (det_test(p)==0){
    if (delete_from_hull(&(w->h),p)==1)
      return 1;
    p=w->h.current->next;
  } 
  
  p=w->h.current->prev;
  while (det_test(p)==0){
    if (delete_from_hull(&(w->h),p)==1)
      return 1;
    p=w->h.current->prev;
  }
  if ((w->h.last_left->side!=-1)||(w->h.last_right->side!=1))
    return 1;
  // also throw out if only two points left
  if (w->h.last_left->next==w->h.last_left->prev)
    return 1;
  
  /*
  setAllDir(&(w->h));
  double a=computeArea(&(w->h));
  if ((a<0)||(a>w->h.area)){
    //fprintf(stdout,"weak area: %lf, previous: %lf\n", 
    //	    computeArea(&(w->h)),
    //    w->h.area);
    return 1;
  }
  w->h.area=a;*/
  
  return 0;
}

/*
int debug_pweak_test(debug,w)
     FILE *debug;
     pword *w;
{
  fprintf(debug,"attempting weak test\n");
  fflush(debug);
  if (w->h.current==NULL) //already thrown out
    return 0; //passes
  if (det_test(w->h.current)==0){ //throwout the new point
    delete_from_hull(&(w->h),w->h.current);
    w->h.current=NULL;
    return 0; //passes
  } //now assume this point is still here
  fprintf(debug,"reached midpoint of weak test\n");
  fflush(debug);  

  Ppoint p=w->h.current->next;
  int s=w->h.current->side;
  while ((p->side!=s)&&(det_test(p)==0)){
    delete_from_hull(&(w->h),p);
    p=w->h.current->next;
  }
  fprintf(debug,"reached midpoint 2 of weak test\n");
  fflush(debug);  
  if (p->side==s) //if we've eliminated the whole opposite side
    return 1; //fails the weak test
  p=w->h.current->prev;
  fprintf(debug,"reached point 3 of weak test\n");
  fflush(debug);  
  while (det_test(p)==0){
    fprintf(debug,"calling delete from hull\n");
    fflush(debug);  
    delete_from_hull(&(w->h),p);
    fprintf(debug,"finished delete from hull\n");
    fflush(debug);  
    if (w->h.last_left->side!=-1){
      fprintf(debug,"last_left has wrong side\n");
      fflush(debug);  
      return 1; //fails the weak test
    }
    if (w->h.last_right->side!=1){
      fprintf(debug,"last_right has wrong side\n");
      fflush(debug);  
      return 1; //fails the weak test
    }
    if (w->h.current==NULL){
      fprintf(debug,"i didn't think this could happen but it does\n");
      fflush(debug);  
      return 1; //fails the weak test
    }
    p=w->h.current->prev;
    fprintf(debug,"end of loop\n");
    fflush(debug);  
  }
  fprintf(debug,"reached end of weak test\n");
  fflush(debug);  
  w->h.current=NULL;
  return 0;
}
  */

/*  
// 0 passes
// 1 fails
int pstrong_test(pword *w){
  double a,b,
    x=w->m.m[0][2],  // coordinates of translation
    y=w->m.m[1][2];
  //fprintf(stdout,"x=%lf, y=%lf\n", x, y);
  double val;
  Ppoint p=w->h.last_left;
  a=p->z.x-x/y*p->z.y;
  p=p->prev;
  while (p->side==-1){
    if ((val=p->z.x-x/y*p->z.y)>a){
      a=val;
      //fprintf(stdout,"a=%lf", a);
    }
    p=p->prev;
  }
  p=w->h.last_right;
  b=p->z.x-x/y*p->z.y;
  p=p->prev;
  while (p->side==1){
    if ((val=p->z.x-x/y*p->z.y)<b){
      b=val;
      //fprintf(stdout,"p->z.x=%lf, p->z.y=%lf, b=%lf\n", 
      //	      p->z.x, p->z.y, b);
    }
    p=p->prev;
  }
  if (a<b)
    return 0;
  return 1;
}
*/


// 0 passes
// 1 fails
int pstrong_test(w)
     pword *w;
{
  double a,b,
    x=w->m.m[0][2],  // coordinates of translation
    y=w->m.m[1][2];
  //fprintf(stdout,"x=%lf, y=%lf\n", x, y);
  double val;
  Ppoint p=w->h.last_left;
  a=p->z.x*(y)+p->z.y*(-x);
  p=p->prev;
  while (p->side==-1){
    if ((val=p->z.x*(y)+p->z.y*(-x))>a){
      a=val;
      //fprintf(stdout,"a=%lf", a);
    }
    p=p->prev;
  }
  p=w->h.last_right;
  b=p->z.x*(y)+p->z.y*(-x);
  p=p->prev;
  while (p->side==1){
    if ((val=p->z.x*(y)+p->z.y*(-x))<b){
      b=val;
      //fprintf(stdout,"p->z.x=%lf, p->z.y=%lf, b=%lf\n", 
      //	      p->z.x, p->z.y, b);
    }
    p=p->prev;
  }
  if (a<b)
    return 0;
  return 1;
}
