#include "math.h"

typedef struct
{
  double x,y;
}   
pcomplex;

void pcomplex_sum_equals(c1,c2)
     pcomplex *c1,*c2;
{
  c1->x+=c2->x;
  c1->y+=c2->y;
}

pcomplex pcomplex_times_double(c1,d)
     pcomplex c1;
     double d;
{
  pcomplex ret;
  ret.x=c1.x*d;
  ret.y=c1.y*d;
  return ret;
}


double pcomplex_dot(c1,c2)
     pcomplex c1,c2;
{
  return c1.x*c2.x+c1.y*c2.y;
}

double pcomplex_norm(c1)
     pcomplex c1;
{
  return sqrt(c1.x*c1.x+c1.y*c1.y);
}

pcomplex pcomplex_unit(c1)
     pcomplex c1;
{
  pcomplex ret;
  double n;
  n=pcomplex_norm(c1);
  ret.x=c1.x/n;
  ret.y=c1.y/n;
  return ret;
}

pcomplex pcomplex_rotate(z,theta)
     pcomplex z;
     double theta;
{
  pcomplex ret;
  ret.x=cos(theta)*z.x-sin(theta)*z.y;
  ret.y=sin(theta)*z.x+cos(theta)*z.y;
  return ret;
}
