#include <float.h>
#include <stdlib.h>
int DIGITS=(int)DBL_MANT_DIG;

// couples a double and a magnitude
typedef struct
{
  double d;
  int mag;
} doubleMag;

// this struct stores a list of DM
typedef struct
{
  doubleMag *d;
  int n;
} doubleList;

// the comparison function for sorting
int compare_doubleMag (a,b)
     const void *a, *b;
{
  const doubleMag *da = (const doubleMag *) a;
  const doubleMag *db = (const doubleMag *) b;

  return (da->mag<=db->mag);
}




// This splits a double into n pieces-
// each of size about DIGITS/n
doubleList splitDouble(d,n)
     double d;
     int n;
{
  doubleList dl;
  int exp, i;

  dl.d = (doubleMag *)malloc(n * sizeof(doubleMag));
  dl.n=n;
  d=frexp(d,&exp);
  if (d>=0)
    for (i=0; i<n; i++){
      dl.d[i].d=ldexp(floor(ldexp(d, (DIGITS*(i+1)/n))),
		      -(DIGITS*(i+1)/n));
      d=d-dl.d[i].d;
      dl.d[i].d=ldexp(dl.d[i].d,exp);
    }
  else {   // d<0
    d=-d;
     for (i=0; i<n; i++){
      dl.d[i].d=ldexp(floor(ldexp(d, (DIGITS*(i+1)/n))),
		      -(DIGITS*(i+1)/n));
      d=d-dl.d[i].d;
      dl.d[i].d=-ldexp(dl.d[i].d,exp);
    }
  } 
  return dl;
}

void DLdestroy(doubleList *dl){
  free(dl->d);
}

// stores the product of two DLs
doubleList DLtimes(dl1,dl2)
     doubleList *dl1, *dl2;
{
  doubleList dl;
  int i,j;

  dl.n=dl1->n*dl2->n;
  dl.d = (doubleMag *)malloc(dl.n * sizeof(doubleMag));
  for (i=0; i<dl1->n; i++)
    for (j=0; j<dl2->n; j++)
      dl.d[i+j*dl1->n].d=dl1->d[i].d*dl2->d[j].d;
  return dl;
} 



// stores the product of two doubles
doubleList storeProduct(d1,d2)
     double d1, d2;
{
  doubleList 
    dl1=splitDouble(d1, 2),
    dl2=splitDouble(d2, 3), ret;
  ret=DLtimes(& dl1, & dl2);
  DLdestroy(&dl1);
  DLdestroy(&dl2);
  return ret;
} 

// "sum" up the members of an array of doubleLists into a new doubleList
doubleList DLsum(a,num)
     doubleList a[]; 
     int num;
{
  doubleList dl;
  int i,j,k;

  dl.n=0;
  for (i=0; i<num; i++)
    dl.n+=a[i].n;
  dl.d = (doubleMag *)malloc(dl.n * sizeof(doubleMag));
  k=0;
  for (i=0;i<num;i++)
    for (j=0;j<a[i].n;j++)
      dl.d[k++].d=a[i].d[j].d;
  return dl;
}



// same as DLsum, but destroys the elements of a[] as it goes through
doubleList DLsumDestroy(a,num)
     doubleList a[]; 
     int num;
{
  doubleList dl;
  int i,j,k;

  dl.n=0;
  for (i=0; i<num; i++)
    dl.n+=a[i].n;
  dl.d = (doubleMag *)malloc(dl.n * sizeof(doubleMag));
  k=0;
  for (i=0;i<num;i++){
    for (j=0;j<a[i].n;j++)
      dl.d[k++].d=a[i].d[j].d;
    DLdestroy(&(a[i]));
  }
  return dl;
}


// creates the list of magnitudes
// and deletes any elements equal to zero
void DLmag(dl)
     doubleList *dl;
{
  int i;

  for (i=0; i<dl->n; i++){
    if (dl->d[i].d==0)
      dl->d[i--].d=dl->d[--(dl->n)].d;
    else 
      frexp(dl->d[i].d,&(dl->d[i].mag));
  }
}





// this sorts the DL in order of decreasing magnitude
// this assumes DLmag has already been called

void DLsort(dl)
     doubleList *dl;
{
  qsort (dl->d, dl->n, sizeof (doubleMag), compare_doubleMag);
}







// returns a double that keeps only the bits of dm->d
// 
double chunkDoubleMag(dm,start,length)
     doubleMag *dm;
     int start, length;
{
  if (dm->d>=0){
    if (start>=dm->mag)
      return ldexp(floor(ldexp(dm->d,-start+length)),start-length);
    if (start-length<=dm->mag-DIGITS)
      return dm->d - 
	(ldexp(floor(ldexp(dm->d,-start)),start));
    return ldexp(floor(ldexp(dm->d,-start+length)),start-length) -
      (ldexp(floor(ldexp(dm->d,-start)),start));
  } else {
    if (start>=dm->mag)
      return -ldexp(floor(ldexp(-dm->d,-start+length)),start-length);
    if (start-length<=dm->mag-DIGITS)
      return dm->d + 
	(ldexp(floor(ldexp(-dm->d,-start)),start));
    return -ldexp(floor(ldexp(-dm->d,-start+length)),start-length) +
      (ldexp(floor(ldexp(-dm->d,-start)),start));
  }
}

// assumes DLmag and DLsort already called.
int DLsign(dl)
     doubleList *dl;
{
  double max_carry=dl->n-1; // this is the maximum value carried over by a sum of
                            // n values less than 1
  int chunk_size, start, end, start_index, i;
  double carry=0;

  frexp(max_carry,&chunk_size);
  chunk_size=DIGITS-(chunk_size+1); // this is the size of the chunks
                                    // we will use when doing addition
 
  start=dl->d[0].mag;
  start_index=0;
  end=dl->d[dl->n-1].mag-DIGITS;
  while (start>end){
    // first add the applicable chunks to carry
    carry+=chunkDoubleMag(&(dl->d[start_index]),start,chunk_size);
    i=start_index+1;
    while ((i<dl->n)&&(dl->d[i].mag>start-chunk_size)){
      carry+=chunkDoubleMag(&(dl->d[i++]),start,chunk_size);
    }
    // now compute the next place to start
    start-=chunk_size;
    while ((start_index<dl->n)&&(start<=dl->d[start_index].mag-DIGITS))
      start_index++;
    if ((start_index<dl->n)&&(start>dl->d[start_index].mag))
      start=dl->d[start_index].mag;

    // check to see if total of carry is to big to be canceled by further addition
    if (carry>ldexp(max_carry,start))
      return 1;
    if (carry<-ldexp(max_carry,start))
      return -1;
  }
  if (carry>0)
    return 1;
  if (carry<0)
    return -1;
  return 0;  
}








// a function for testing
void printOctal(file, d)
     FILE *file;
     double d;
{
  int n,i,j;
  if (d==0){
    fprintf(file, "0.");
    return;
  }
  if (d<0){
    fprintf(file, "-");
    d=-d;
  }
  frexp(d,&n);
  i=3*((n+2)/3);
  if (i<=0){
    fprintf(file, "0.");
    for (j=0; j>i;j-=3)
      fprintf(file, "0");
  } 
  d=ldexp(d,-(i-3));
  for (j=i; j>n-DBL_MANT_DIG; j-=3){
    fprintf(file, "%1.0lf",floor(d));
    d=ldexp(d-floor(d),3);
    if (j==3)
      fprintf(file, ".");
  }
  fprintf(file, "o");
}

void DLprintOctal(file, dl)
     FILE *file;
     doubleList *dl;
{
  int i;
  for (i=0; i<dl->n; i++){
    printOctal(file,dl->d[i].d);
    fprintf(file," : %d\n", dl->d[i].mag);
  }
}

