#include <stdlib.h>
#include <stdio.h>
#include <math.h>
#define Pi 3.141592653589
#include "plist.c"

//returns complex numbers for the end points of the tile
pcomplex[] rat_plot(z,line,w, mesh)
     pcomplex z; 
     int line[3];
     word w;
     int mesh;
{
  triangle T;
  pcomplex ret[2], end[2], temp;
  double d;
  int i;

  T=triangle_make2(z);
  if (!general_strong_test(w,T)){
    printf("rat_plot: Bad call... the point does not lie within the tile.\n");
    exit(0);
  }

  // Determine the end points of the line
  if (line[0]==0){
    end[0].x=0;
    end[0].y=((double)line[2])/line[1];
    end[0].x=.5;
    end[0].y=((double)line[2])/line[1];
  } else if (line[0]==0){
    end[0].y=0;
    end[0].x=((double)line[2])/line[0];
    end[0].y=.5;
    end[0].x=((double)line[2])/line[0];
  } else {
    i=0;
    // alpha=0 beta=
    d=((double)line[2])/line[1];
    if ((d>=0)&&(d<.5)){
      end[i].x=0;
      end[i].y=d;
      i++;
    }    
    // beta=0 alpha=
    d=((double)line[2])/line[0];
    if ((d>=0)&&(d<.5)){
      end[i].x=d;
      end[i].y=0;
      i++;
    }    
    // alpha=.5 beta=
    d=(((double)line[2])-((double)line[0])/2)/line[1];
    if ((d>=0)&&(d<.5)){
      end[i].x=.5;
      end[i].y=d;
      i++;
    }
    // beta=.5 alpha=
    d=(((double)line[2])-((double)line[1])/2)/line[0];
    if ((d>=0)&&(d<.5)){
      end[i].x=d;
      end[i].y=.5;
      i++;
    }
    if (i!=2){
      printf("Error rat_plot: unable to determine endpoints of line");
      exit(0);
    }
  }
  // End determining end points
  
  ret[0]=ret[1]=z;
  for (i=0; i<2; i++)
    for (j=1; j<mesh; i++){
      temp.x=(ret[i].x+end[i].x)/2;
      temp.y=(ret[i].y+end[i].y)/2;
      T=triangle_make2(temp);
      if (general_strong_test(w,T)) // if passes strong test
	ret[i]=temp;
      else
	end[i]=temp;
    }

}
     
