// This code uses the Multi Slalom search algorithm to 
// attempt to fill a ray of the space of triangles

#include <stdlib.h>
#include <stdio.h>
#include <math.h>
#define Pi 3.141592653589
#include "plist.c"

void write_tile_data(file,w, z,done)
     FILE *file;
     word w;
     pcomplex z;
     double done;
{
  word_print_file(file,&w);
  fprintf(file,"%0.16lf\n",z.x);
  fprintf(file,"%0.16lf\n",z.y);
  fprintf(file,"%0.16lf\n",done);
  fflush(file);
}

// returns the end point of the ray starting at a and ending at b
pcomplex get_end(a,b)
     pcomplex a,b;
{
  double t,s;
  pcomplex end;

  if (a.x!=b.x){
    t=-a.x/(b.x-a.x);
    if (t>0){
      end.x=0;
      end.y=a.y+t*(b.y-a.y);
      if ((end.y>=-0.0000001)&&(end.y<=1.0))
	return end;
    } else{
      t=(1-a.x)/(b.x-a.x);
      end.x=1;
      end.y=a.y+t*(b.y-a.y);
      if ((end.y>=-0.0000001)&&(end.y<=1))
	return end;
    }
  }
  if (a.y!=b.y){
    t=-a.y/(b.y-a.y);
    if (t>0){
      end.y=0;
      end.x=a.x+t*(b.x-a.x);
       if ((end.x>=-0.0000001)&&(end.x<=1))
	return end;
    } else{
      t=(1-a.y)/(b.x-a.x);
      end.y=1;
      end.x=a.x+t*(b.y-a.y);
      if ((end.x>=-0.0000001)&&(end.x<=1))
	return end;
    }
  }
  printf("Error: Failed to find endpoint of ray.\n");
  exit(0);
  return end;
}

// a is assumed to be in the tile w end is a point on the boundary
// we return an end point of the ray inside w
pcomplex zoom_to_end(w,a,end,n)
  word w;
  pcomplex a,end;
  int n;
{
  triangle T;
  int i;
  pcomplex b;

  for (i=0; i<n; i++){
    b.x=(a.x+end.x)/2;
    b.y=(a.y+end.y)/2;
    T=triangle_make2(b);
    if (general_strong_test(w,T)){
      a.x=b.x;
      a.y=b.y;
    } else {
      end.x=b.x;
      end.y=b.y;
    }      
  }
  return a;
}

// Finds (c-a)/(b-a) which should be a real number
double done(a, b, c)
     pcomplex a,b,c;
{
  pcomplex diff,delta;
  diff.x=b.x-a.x;
  diff.y=b.y-a.y;
  delta.x=c.x-a.x;
  delta.y=c.y-a.y;
  if (diff.x == 0)
    return delta.y/diff.y;
  return delta.x/diff.x;
}

int main(){
  //FILE *file1, *file2, *fopen();
  int s,i,DEPTH,count,opt;
  char out[50];
  triangle list[2];
  pcomplex a,b,c,end,start;
  word w;
  word_link wl;

  scanf("%d",&opt); // opt=0 => infinite ray
  if (opt>1) opt=0;        // opt=1 => finite ray
  
  // read the two triangles
  fscanf(stdin,"%lf",&(a.x)); // the first angle of our triangle
  fscanf(stdin,"%lf",&(a.y)); // the second angle of our triangle
  fscanf(stdin,"%lf",&(b.x)); // the first angle of our triangle
  fscanf(stdin,"%lf",&(b.y)); // the second angle of our triangle

  //printf("Triangle 1: (%.16lf, %.16lf)\n", a.x, a.y);
  //printf("Triangle 2: (%.16lf, %.16lf)\n", b.x, b.y);
  
  start.x=a.x;
  start.y=a.y;
  if (opt==0){
    end=get_end(a,b);
    //printf("End Triangle: (%.16lf, %.16lf)\n", end.x, end.y);
  } else { // opt==1
    end.x=b.x;
    end.y=b.y;
    //printf("Operating with finite end point\n");   
  }
  printf("%.16lf\n",a.x);
  printf("%.16lf\n",a.y);
  printf("%.16lf\n",end.x);
  printf("%.16lf\n",end.y);


  fscanf(stdin,"%d",&DEPTH);    // the depth to search to

  // *****Set up some things 

  wl=NULL;

  // *******End setting up

  while((a.x!=b.x)||(a.y!=b.y)){
    //printf("----------------------------------------------\n");
    //printf("Using %d tiles.\n",count);    
    //printf("Triangle 1: (%.16lf, %.16lf)\n", a.x, a.y);
    //printf("Triangle 2: (%.16lf, %.16lf)\n", b.x, b.y);
    //printf("Begin search.\n");

    list[0]=triangle_make2(a);
    list[1]=triangle_make2(b);
    
    w=fill_search(list,2,DEPTH);
    if (w.l==0){
      //printf("No tile found. Halve segment.\n");
      b.x=(b.x-a.x)/2+a.x;
      b.y=(b.y-a.y)/2+a.y;
    } else {
      //printf("Tile found! Word is of length %d.\n",w.l);
      //printf("Writing data to file.\n");
      a.x=(a.x+b.x)/2;
      a.y=(a.y+b.y)/2;	
      c=zoom_to_end(w,b,end,100);
      write_tile_data(stdout,w,a,done(start,end,c));
      a.x=c.x;
      a.y=c.y;
      wl=word_insert(wl,&w);
      count++;
      if (opt==0){
	b.x=(a.x+end.x)/2;
	b.y=(a.y+end.y)/2;
      } else { // opt==1
	b.x=end.x;
	b.y=end.y;
      }
    }
  }

  //printf("----------------------------------------------\n");
  //printf("Fill completed successfully.\n");

  word_link_destroy(wl);

  return 0;
}
