typedef struct Triangle_Holder
{ struct Triangle_Holder *next, *prev;
  triangle T;
}
*triangle_holder;

typedef struct
{
  triangle_holder first,last;
  int l;
}
triangle_queue;

void tq_initialize(tq)
     triangle_queue *tq; 
{
  tq->first=tq->last=NULL;
  tq->l=0;
}

triangle tq_pop(tq)
     triangle_queue *tq;
{
  triangle T;

  //if (tq->l==0){
  //printf("Error in tq_pop... asked to pop from empty list\n");
  //exit(1);
  //}
  
  T=tq->first->T;
  tq->first=tq->first->next;
  if (tq->first==NULL){ // then this is the last triangle
    free(tq->last);
    tq->last=NULL;
  } else {
    free(tq->first->prev);
    tq->first->prev=NULL;
  }
  tq->l--;
  return T;
}

void tq_push(tq,T)
     triangle_queue *tq;
     triangle T;
{
  if (tq->l==0){
    tq->first=(triangle_holder) malloc (sizeof(struct Triangle_Holder));
    tq->first->T=T;
    tq->first->prev=tq->first->next=NULL;
    tq->last=tq->first;
  } else {
    tq->last->next=(triangle_holder) malloc (sizeof(struct Triangle_Holder));
    tq->last->next->T=T;
    tq->last->next->next=NULL;
    tq->last->next->prev=tq->last;
    tq->last=tq->last->next;
  }
  tq->l++;
}

// Divide the triangle into 4 similar pieces and push them on the stack
void tq_push_division(tq,T)
     triangle_queue *tq;
     triangle T;
{
  triangle a[4];
  
  triangle_subdivide(&T,a);

  tq_push(tq,a[0]);
  tq_push(tq,a[1]);
  tq_push(tq,a[2]);
  tq_push(tq,a[3]);
}
 
