
import java.applet.Applet;
import java.awt.event.*;
import java.awt.*;

public class FareyRational {
    int p;  //numerator
    int q;  //denominator
    int code;
    int level;

    public FareyRational(int p,int q) {
	this.p=p;
	this.q=q;
	this.code=0;
	this.level=0;
    }

    public FareyRational() {}


    //first number should be bigger

    public static int[] euclideanAlgorithmStep(int[] E) {
	int[] G=new int[2];
	G[0]=E[1];
	G[1]=E[0]%E[1];
	return(G);
    }

    //reorder so that first number is bigger and both are nonnegative
    public static int greatestCommonDivisor(int a,int b) {
	int[] F=new int[2];
	int a2=a;
	int b2=b;
	if(a<0) a2=-a;
	if(b<0) b2=-b;
	if(a==0) return(1);
	if(b==0) return(1);
	if(a2==b2) return(1);
	int a3=a2;
	int b3=b2;
	if(a2<b2) {a3=b2;b3=a2;}
	//at this point a3 and b3 are positive and a3>b3
	F[0]=a3;
	F[1]=b3;
	while(F[1]>0) {   
           F=euclideanAlgorithmStep(F);  
	}


	return(F[0]);
    }

    public static FareyRational reduce(FareyRational F) {
	int k=greatestCommonDivisor(F.p,F.q);
	FareyRational G=new FareyRational(F.p/k,F.q/k);
	return(G);
    }

    public static FareyRational average(FareyRational F1,FareyRational F2) {
	FareyRational G1=reduce(F1);
	FareyRational G2=reduce(F2);
	FareyRational H=new FareyRational(G1.p+G2.p,G1.q+G2.q);
	H=reduce(H);
	return(H);
    }

    public static FareyRational[] subdivide(int k,FareyRational[] F) {
	FareyRational[] G=new FareyRational[2];
	G[0]=new FareyRational(0,1);
	G[1]=new FareyRational(1,1);
	if(k==0) {
	    G[0]=new FareyRational(F[0].p,F[0].q);
	    G[1]=average(F[0],F[1]);
	}

	if(k==1) {
            G[0]=average(F[0],F[1]);
	    G[1]=new FareyRational(F[1].p,F[1].q);
	}
	G[0].code=k;
	return(G);
    }



    /*
    1 means (nearly) equals left endpoint
    2 means inside
    3 means (nearly) equals right endpoint
    0 means outside
    */


    public static int isInside(double x,FareyRational[] F) {
	double f0=1.0*F[0].p/F[0].q;
	double f1=1.0*F[1].p/F[1].q;
	double cutoff=0.000000000000001;
	if(x<f0-cutoff) return(0);
	if(x>f1+cutoff) return(0);
	if(Math.abs(x-f0)<=cutoff) return(1);
	if(Math.abs(x-f1)<=cutoff) return(3);
	return(2);
    }


    public static FareyRational[] subdivide(double x,FareyRational[] F) {
	FareyRational[] G1=subdivide(0,F);
	FareyRational[] G2=subdivide(1,F);
	int test=isInside(x,G2);
	if(test!=0) return(G2);
	return(G1);
    }

    public static int whichHalf(double x,FareyRational[] F) {
	FareyRational[] G1=subdivide(0,F);
	FareyRational[] G2=subdivide(1,F);
	int test=isInside(x,G2);
	if(test!=0) return(1);
	return(0);
    }

    public static FareyRational approximate(double x,int k) {
	FareyRational[] F=new FareyRational[2];
	int code=0;
	F[0]=new FareyRational(0,1);
	F[1]=new FareyRational(1,1);
	for(int i=1;i<=k;++i) {
              F=subdivide(x,F);
	      code=code+F[0].code*(int)(Math.pow(2,k-i));
	}
	FareyRational G=average(F[0],F[1]);
	double d1=1.0*G.p/G.q-x;
	F[0].code=code;
	F[1].code=code+1;
	F[0].level=k;
	F[1].level=k;
	if(d1>0) return(F[0]);
	return(F[1]);
    }



    public static FareyRational approximate(int[] q) {
	FareyRational[] F=new FareyRational[2];
	F[0]=new FareyRational(0,1);
	F[1]=new FareyRational(1,1);
	for(int i=0;i<q.length;++i) F=subdivide(q[i],F);
	return(F[0]);
    }


    public static int[] getBinary(int n,int k) {
	int[] q=new int[k];
	int kk=n;
	for(int i=0;i<k;++i) {
	    int bit=kk&1;
	    q[k-i-1]=bit;
	    kk=kk>>1;
	}
	    return(q);
    }


    public static FareyRational approximateUp(double x,int k) {
	FareyRational F=approximate(x,k);
	int CODE=F.code;
	if(CODE<Math.pow(2,k)) ++CODE;
	if(CODE<Math.pow(2,k)) {
	int[] q=getBinary(CODE,k);
	return(approximate(q)); }
	   F.p=1;
	   F.q=1;
	   return(F);


    }

    public static FareyRational approximateDn(double x,int k) {
	FareyRational F=approximate(x,k);
	int CODE=F.code;
	if(CODE>0) --CODE;
	int[] q=getBinary(CODE,k);
	return(approximate(q));
    }


}
