import java.applet.Applet;
import java.awt.event.*;
import java.awt.*;
import java.math.*;

public class Function {
    public Function() {}


    /**Section 1:  Function definitions.

      for a generic word, the functions have a numerator and a denominator.
      One tricky part of this business is getting the sign right.  So,
      we have a separate routine for computing the sign.*/


   public static int[][] computeNumerator(VertexPair V,CombinatorialTriangle[] CT) {
      int[] n=Spine.computeSpine(V,CT);
      int spine=n[n[0]+2];
      int[][] m=new int[4][n[0]+2];
      for(int j=1;j<=n[0];++j) {
        m[1][j]=CT[n[j]].d[spine][0];
        m[2][j]=CT[n[j]].d[spine][1];
        m[3][j]=(2*(j%2)-1)*n[n[0]+1];
     }
      m[0][0]=n[0];      //length
      m[0][1]=n[1];      //start
      return(m);
   }


    public static int[][] computeDenominator(int spine,CombinatorialTriangle[] CT) {
      int[] n=Spine.fullSpine(spine,CT);
      int[][] m=new int[4][n[0]+1];
      for(int j=1;j<=n[0];++j) {
        m[0][j]=n[j];
        m[1][j]=CT[n[j]].d[spine][0];
        m[2][j]=CT[n[j]].d[spine][1];
        m[3][j]=2*(j%2)-1;
      }
      m[0][0]=n[0];
      return(m);
    }


    public static int[][] computeDenominator(VertexPair V,CombinatorialTriangle[] CT) {
	int spine=Spine.spineNumber(V,CT);
	return(computeDenominator(spine,CT));
    }


    public static int getSign(int nn,int[][] d) {
       if(d[0][d[0][0]]<nn) return(1);   //a special case
       if(d[0][d[0][0]]==nn) return(0);  //another special case

       int count=1;
       while(d[0][count]<nn) ++count;
       if(d[0][count]!=nn) --count;
       if(count%2==0) return(1);
       return(-1);
    }

    
    public static int[][] getSignedNumerator(int[][] d,VertexPair V,CombinatorialTriangle[] CT) {
       int[][] n=computeNumerator(V,CT); 
       int sign=getSign(n[0][1],d);
       for(int i=0;i<=n[0][0];++i) n[3][i]=sign*n[3][i];
       return(n);
    }


    /**Section 2:  Basic computations */

    /*In one place in our plotting algorithm we need to take the
      product of the numerator and the (conjugate of the) denominator.
      We do this using the foil method, which is slow but reliable.
      We don't know a better way to get the bounds which use this
      method*/
    

public static int[][] foil(int[][] f1,int[][] f2) {
  int[][] f3=new int[4][1000];
  int i,j,imax,imin,jmax,jmin,sign,v1,v2,count;
  int[][] a=new int[200][400];

  for(i=0;i<=199;++i) {
    for(j=0;j<=399;++j) {
      a[i][j]=0;
    }}

  imin=1000;
  imax=-1000;
  jmin=1000;
  jmax=-1000;

  for(i=1;i<=f1[0][0];++i) {
    for(j=1;j<=f2[0][0];++j) {
      sign=f1[3][i]*f2[3][j];
      v1=f1[1][i]-f2[1][j];
      v2=f1[2][i]-f2[2][j];
      if((v1<=0)&&(imax<-v1)) imax=-v1;
      if((v1>=0)&&(imax<v1)) imax=v1;

      if(v1>=0) {
	a[v1][200+v2]=a[v1][200+v2]+sign;
      } 
      if(v1<0) {
	a[-v1][200-v2]=a[-v1][200-v2]-sign;
      }
    }
  }

  a[0][200]=0;
    count=1;
    for(i=0;i<=imax;++i) {
      for(j=1;j<=399;++j) {
	if(a[i][j]>0) {
	  f3[0][count]=i;
	  f3[1][count]=j-200;
	  f3[2][count]=a[i][j];
	  ++count;
	}
	if(a[i][j]<0) {
          f3[0][count]=-i;
	  f3[1][count]=-j+200;
	  f3[2][count]=-a[i][j];

	  ++count;
	}
      }
    }
    f3[0][0]=count-1;
    return(f3);
}


    /**this routine gets the result of doing the foil*/

    public static int[][] getFunction(VertexPair V,CombinatorialTriangle[] CT) {
       int[][] d=computeDenominator(V,CT);
       int[][] n=getSignedNumerator(d,V,CT);
       int[][] f=foil(n,d);
       return(f);
  }


    /**these first 3 routines require the function to be foiled.  We only
       use the third one in our plotting algorithm*/

    //McScaled during routine
   public static double evaluate(int[][] f,Complex zz) {      
    double total=0.0;
    Complex z=new Complex(Math.PI*zz.x/2.0,Math.PI*zz.y/2.0);
    for(int i=1;i<=f[0][0];++i) {
      int a=f[2][i];
      int b=f[0][i];
      int c=f[1][i];
    total=total+a*Math.sin(b*z.x+c*z.y);
    }
    return(total);
   }

    //McScaled during routine
   public static double gradient(int q,int[][] f,Complex zz) {
      double total=0.0;
      Complex z=new Complex(Math.PI*zz.x/2.0,Math.PI*zz.y/2.0);

      for(int i=1;i<=f[0][0];++i) {
        int a=f[2][i];
        int b=f[0][i];
        int c=f[1][i];
        if(q==1)  total=total+a*b*Math.cos(b*z.x+c*z.y);
        if(q==2)  total=total+a*c*Math.cos(b*z.x+c*z.y);
      }
     return(total);
   }


    /**This is the bound which requires the foil method*/

  public static int absoluteSecondDerivative(int[][] f,int n1,int n2) {
    int a,b,c,d;
    int total=0;
    d=0;
    for(int i=1;i<=f[0][0];++i) {
      a=f[0][i];
      b=f[1][i];
      c=f[2][i];
      if((n1==2)&&(n2==0)) d=c*a*a;
      if((n1==1)&&(n2==1)) d=c*a*b;
      if((n1==0)&&(n2==2)) d=c*b*b;
      if(d<0) d=-d;
      total=total+d;
    }
    return(total);
  }








    /**these routines work with the unfoiled version and run faster.  We 
       have set things up so that one can take arbitrarily high partial
       derivatives of the defining functions.  Right now, this is much
       more than we need.*/

    //McScaled during routine
  public static Complex derivative(int[][] g,int a,int b,Complex zz) {
       Complex total=new Complex();
       Complex z=new Complex(Math.PI*zz.x/2.0,Math.PI*zz.y/2.0);
       int cong=(a+b)%4;
       for(int i=1;i<=g[0][0];++i) {
	   double coeff=g[3][i]*Math.pow(g[1][i],a)*Math.pow(g[2][i],b);
	   if(cong==0) {
	       total.x=total.x+coeff*Math.cos(g[1][i]*z.x+g[2][i]*z.y);
	       total.y=total.y+coeff*Math.sin(g[1][i]*z.x+g[2][i]*z.y);
	   }
	   if(cong==1) {
	       total.x=total.x-coeff*Math.sin(g[1][i]*z.x+g[2][i]*z.y);
	       total.y=total.y+coeff*Math.cos(g[1][i]*z.x+g[2][i]*z.y);
	   }
	   if(cong==2) {
	       total.x=total.x-coeff*Math.cos(g[1][i]*z.x+g[2][i]*z.y);
	       total.y=total.y-coeff*Math.sin(g[1][i]*z.x+g[2][i]*z.y);
	   }
	   if(cong==3) {
	       total.x=total.x+coeff*Math.sin(g[1][i]*z.x+g[2][i]*z.y);
	       total.y=total.y-coeff*Math.cos(g[1][i]*z.x+g[2][i]*z.y);
	   }
       }
       return(total);
  }


    /**This routine is used in the product formula for partial derivatives.
       If you ever write the chain rule for the product rule in 2
       variables, you will see that it requires a routine like the
       following one.*/

    public static int[] partialContent(int k,int[] a) {
	int b=a[0]+a[1];
	int kk=k;
	int[] c=new int[2];
	c[0]=0;
	c[1]=0;
	for(int i=0;i<b;++i) {
	    int bit=kk&1;
	    if((bit==1)&&(i<a[0])) ++c[0];
	    if((bit==1)&&(i>=a[0])) ++c[1];
	    kk=kk>>1;
	}
	    return(c);
    }


    public static double termInProductRule(int[][] n,int[][] d,int k,int[] a,Complex z) {
	int[] b=partialContent(k,a);
	int[] c=new int[2];
	c[0]=a[0]-b[0];
	c[1]=a[1]-b[1];
	Complex z1=derivative(n,b[0],b[1],z);
	Complex z2=derivative(d,c[0],c[1],z);
	Complex z3=Complex.times(z1,Complex.conjugate(z2));
	return(z3.y);
    }

    /**Here is the routine which evaluates arbitrary partial derivatives*/

    public static double evaluate(int[][] n,int[][] d,int a0,int a1,Complex z) {
	double w=0;
	int[] a=new int[2];
	a[0]=a0;
	a[1]=a1;
	for(int k=0;k<Math.pow(2,a0+a1);++k) {
	    w=w+termInProductRule(n,d,k,a,z);
	}
	return(w);
    }



    /**Here are a few special cases we use with the unfold window*/

     public static double evaluate(int[][] f1,int[][] f2,Complex zz) {
        return(evaluate(f1,f2,0,0,zz));
     }

     public static double evaluate(int sign,int[][] f1,int[][] f2,Complex zz) {
        return(sign*evaluate(f1,f2,0,0,zz));
     }

     public static double gradient(int q,int[][] f1,int[][] f2,Complex zz) {
        if(q==1) return(evaluate(f1,f2,1,0,zz));
        if(q==2) return(evaluate(f1,f2,0,1,zz));
     return(0);
     }




    /**when we do our plotting algorithm we will have the denominator
       functions precomputed.  This routine evaluates these functions
       at some commonly sampled points.*/

    public static Complex[] assignData(int[][]f,DyadicSquare Q) {
    Complex z=Q.getCenter();
    int diam=Q.k;
    Complex[] zz=new Complex[10];
    int pos1,pos2;
    double max,min,width;
    for(int i=1;i<=8;++i) zz[i]=new Complex();
    width=Math.pow(0.5,diam+1);
    zz[1].x=z.x+width;
    zz[1].y=z.y+width;
    zz[2].x=z.x;
    zz[2].y=z.y+2.0*width;
    zz[3].x=z.x-width;
    zz[3].y=z.y+width;
    zz[4].x=z.x-2.0*width;
    zz[4].y=z.y;
    zz[5].x=z.x-width;
    zz[5].y=z.y-width;
    zz[6].x=z.x;
    zz[6].y=z.y-2.0*width;
    zz[7].x=z.x+width;
    zz[7].y=z.y-width;
    zz[8].x=z.x+2.0*width;
    zz[8].y=z.y;
    Complex[] Z=new Complex[11];
    Z[0]=derivative(f,0,0,z);
    for(int i=1;i<=8;++i) Z[i]=derivative(f,0,0,zz[i]);
    Z[9]=derivative(f,1,0,z);
    Z[10]=derivative(f,0,1,z);
    return(Z);
    }

}
