import java.applet.Applet;
import java.awt.event.*;
import java.awt.*;



public class FunctionCanvas extends DBCanvas implements MouseListener, 
MouseMotionListener, HearingParameter {
    Color C0,C1,C2,C3;
    double START,END;
    double A;
    Complex B;
    Manager M;
    int[][] n=new int[4][1000];
    int[][] d=new int[4][1000];
    int[][] f=new int[3][1000];
    Integer[][] N=new Integer[4][1000];
    Integer[][] D=new Integer[4][1000];
    Integer[][] F=new Integer[3][1000];
    ListenSquare[] L=new ListenSquare[4];
    int form;
    int palindrome;
    int dyadic;

   public FunctionCanvas(Manager M) {
       // add the manager
       this.M=M;
       palindrome=0;
       START=0;
       END=0;
       A=0;
       B=new Complex();
       C0=Color.white;
       C1=Color.blue;
       C2=Color.red;
       C3=Color.black;
       START=0;
       END=0;
       n[0][0]=0;
       d[0][0]=0;
       n[0][1]=0;
       form=1;
       addMouseListener(this);
       addMouseMotionListener(this);  
       M.hearParameter(this);
       L[0]=new ListenSquare(67,0,12,12,Color.white);
       L[1]=new ListenSquare(67,49,12,12,new Color(80,150,255));
       L[1].on=1;
       L[2]=new ListenSquare(67,34,12,12,new Color(80,150,255));
   }
 
    public void mousePressed(MouseEvent e) {
      e.consume();
      START=e.getX();
   }

    public void parameterChanged(){repaint();}

    
  public void mouseReleased(MouseEvent e) {
  }


   public void mouseEntered(MouseEvent e) {}
   public void mouseExited(MouseEvent e) {}
   public void mouseClicked(MouseEvent e) {
       e.consume();
       Point X=new Point();
       X.x=e.getX();
       X.y=e.getY();
       if(L[0].inside(X)==1) document();
       if(L[1].inside(X)==1) {L[2].on=0;L[1].on=1;form=1;}
       if(L[2].inside(X)==1) {L[1].on=0;L[2].on=1;form=2;}
       repaint();
   }

   public void mouseMoved(MouseEvent e) {}
   public void mouseDragged(MouseEvent e) {

      Point X=new Point();
      e.consume();
      int test=e.getY();
      if(test>15) {
      END=e.getX();
      B.x=B.x+END-START;
      START=END;
      repaint();
      }
   }



    public void paint(Graphics gfx) {
      Graphics2D g=(Graphics2D) gfx;
      g.setRenderingHint(RenderingHints.KEY_ANTIALIASING,
                         RenderingHints.VALUE_ANTIALIAS_ON);
      Dimension D=this.getSize();
      g.setColor(new Color(0,0,150)); 
      g.fillRect(80,0,D.width-79,31);
      g.setColor(new Color(0,80,0));
      g.fillRect(224,0,80,31);   
      g.setColor(new Color(80,0,0));
      g.fillRect(174,0,70,31);
      g.setColor(new Color(80,0,0));
      g.fillRect(304,0,50,31);



      g.setColor(new Color(80,150,255));
      g.drawRect(80,0,D.width-79,31);


      g.translate(70,0);
      if(form==1) drawFunction1(g);
      if(form==2) drawFunction2(g);
	drawEvaluation(g,form);
	System.out.println(form+" "+palindrome);
        g.translate(-70,0);
	drawGradient(g);
        g.setColor(Color.white);
        g.drawRect(0,0,D.width-1,D.height-1);
	L[0].infoRender(g);
	L[1].render(g,Color.blue);
	L[2].render(g,Color.blue);
    }





    public void drawEvaluation(Graphics g,int q) {

	if(palindrome==0) {
	if(n[0][0]>0) {
	    double x=0;	
            if(q==1) x=Function.evaluate(n,d,M.getZ());
            if(q==2) x=Function.evaluate(f,M.getZ());
            g.setFont(new Font("Monospaced",Font.PLAIN,12));
	    g.setColor(Color.white);
	    Double X=new Double(x);
	    String SX=X.toString();
	    if(SX.length()<12) g.drawString(SX,13,19);
	    if(SX.length()>=12) {
		g.drawString(SX.substring(0,11),13,14);
		g.drawString(SX.substring(12,SX.length()),32,28);
	    }
	}}

	if(palindrome==1) {
	if(n[0][0]>0) {
	    double x=0;	
            x=PalindromeFunction.evaluate(f,M.getZ());
            g.setFont(new Font("Monospaced",Font.PLAIN,12));
	    g.setColor(Color.white);
	    Double X=new Double(x);

            String SX=X.toString();
	    if(SX.length()<12) g.drawString(SX,13,19);
	    if(SX.length()>=12) {
		g.drawString(SX.substring(0,11),13,14);
		g.drawString(SX.substring(12,SX.length()),32,28);
	    }



	}}


    }




    public void drawGradient(Graphics2D g) {
	if(n[0][0]>0) {

            double x=0;	
	    double y=0;
	    int x20,x11,x02;
	    x20=0;
	    x11=0;
	    x02=0;

	    if(palindrome==0) {

	    if(form==1) {
               x=Function.gradient(1,f,M.getZ());
               y=-Function.gradient(2,f,M.getZ());

               g.setFont(new Font("Monospaced",Font.PLAIN,10));
	       g.setColor(Color.white);
	       Double X=new Double(x);
	       Double Y=new Double(y);
               if(Math.abs(x)<.000000000001) X=new Double(0);
	       String SX=X.toString();
	       if(SX.length()>10) SX=SX.substring(0,9);  
               if(Math.abs(x)<.000000000001) Y=new Double(0);
	       String SY=Y.toString();
	       if(SY.length()>10) SY=SY.substring(0,9);
	       g.drawString(SX,180,11);
	       g.drawString(SY,180,27);

               g.setFont(new Font("Monospaced",Font.PLAIN,8));
	       x20=Function.absoluteSecondDerivative(f,2,0);
	       Integer X20=new Integer(x20);
	       g.drawString(X20.toString(),248,9);
	       x11=Function.absoluteSecondDerivative(f,1,1);
	       Integer X11=new Integer(x11);
	       g.drawString(X11.toString(),248,18);
	       x02=Function.absoluteSecondDerivative(f,0,2);
	       Integer X02=new Integer(x02);
	       g.drawString(X02.toString(),248,27);

	    }



	    if(form==2) {
	    x=Function.gradient(1,n,d,M.getZ());
	    y=-Function.gradient(2,n,d,M.getZ());

            g.setFont(new Font("Monospaced",Font.PLAIN,10));
	    g.setColor(Color.white);
	    Double X=new Double(x);
	    Double Y=new Double(y);

               if(Math.abs(x)<.000000000001) X=new Double(0);
	       String SX=X.toString();
	       if(SX.length()>10) SX=SX.substring(0,9);  
               if(Math.abs(x)<.000000000001) Y=new Double(0);
	       String SY=Y.toString();
	       if(SY.length()>10) SY=SY.substring(0,9);
	       g.drawString(SX,180,11);
	       g.drawString(SY,180,26);
	    }
	    }


	    if(palindrome==1) {

            x=PalindromeFunction.gradient(1,f,M.getZ());
            y=PalindromeFunction.gradient(2,f,M.getZ());y=-y;
            g.setFont(new Font("Monospaced",Font.PLAIN,10));
	    g.setColor(Color.white);
	    Double X=new Double(x);
	    Double Y=new Double(y);
            String SX=X.toString();
	    if(SX.length()>10) SX=SX.substring(0,9);  
            if(Math.abs(x)<.000000000001) Y=new Double(0);
	    String SY=Y.toString();
	    if(SY.length()>10) SY=SY.substring(0,9);
	    g.drawString(SX,180,11);
	    g.drawString(SY,180,26);
            g.setFont(new Font("Monospaced",Font.PLAIN,8));
	    x20=PalindromeFunction.absoluteSecondDerivative(f,2,0);
	    Integer X20=new Integer(x20);
	    g.drawString(X20.toString(),248,9);
	    x11=PalindromeFunction.absoluteSecondDerivative(f,1,1);
	    Integer X11=new Integer(x11);
	    g.drawString(X11.toString(),248,18);
	    x02=PalindromeFunction.absoluteSecondDerivative(f,0,2);
	    Integer X02=new Integer(x02);
	    g.drawString(X02.toString(),248,27);
	    }


	    double d20=0;
	    double d11=0;
	    double d02=0;

	    if((form==1)&&(dyadic>0)) {
		double rad=Math.PI*Math.pow(0.5,dyadic+2);
		d20=x20*rad;
		d11=x11*rad;
		d02=x02*rad;
		Double D20=new Double(d20);
		Double D11=new Double(d11);
		Double D02=new Double(d02);
		String s20=D02.toString();
		String s11=D11.toString();
		String s02=D02.toString();
                if(s20.length()>10) s20=s20.substring(0,9);
                if(s11.length()>10) s11=s11.substring(0,9);
                if(s02.length()>10) s02=s02.substring(0,9);
                g.drawString(s20,308,9);  
                g.drawString(s11,308,18);
                g.drawString(s02,308,27);
	    }


            int[] a={(int)(x20),(int)(x11),(int)(x02)};
	    int cert=Certify.doMainStep(x,y,a,dyadic);

	    Complex z=new Complex(x,y);
	    z=Complex.unit(z);
	    g.setColor(new Color(80,0,0));
	    g.fillOval(2,2,60,60);
	    g.setColor(new Color(200,0,0));

	    if(cert==1) g.fillArc(2,2,60,60,270,90);
	    if(cert==2) g.fillArc(2,2,60,60,225,90);
	    if(cert==3) g.fillArc(2,2,60,60,180,90);
            if(cert==4) g.fillArc(2,2,60,60,135,90);
	    if(cert==5) g.fillArc(2,2,60,60,90,90);
            if(cert==6) g.fillArc(2,2,60,60,45,90);
	    if(cert==7) g.fillArc(2,2,60,60,0,90);
            if(cert==8) g.fillArc(2,2,60,60,-45,90);



	    Complex zz=new Complex(-z.y,z.x);
	    int x1=(int)(32-30*zz.x);
	    int y1=(int)(32-30*zz.y);
	    int x2=(int)(32+30*zz.x);
	    int y2=(int)(32+30*zz.y);
	    g.setColor(Color.white);
            g.drawOval(2,2,60,60);

	    g.drawLine(x1,y1,x2,y2);
	    x1=(int)(32+30*z.x);
	    y1=(int)(32+30*z.y);
	    g.drawLine(32,32,x1,y1);

	}
    }







    public void drawFunction2(Graphics g) {
        g.setFont(new Font("Monospaced",Font.PLAIN,10));
	g.setColor(Color.white);

	g.translate((int)(B.x),0);

	g.setColor(new Color(100,170,255));
	g.drawString("P",13,41);
	g.drawLine(22,34,22,59);
	for(int i=1;i<=n[0][0];++i) {
	    g.setColor(Color.white);  
	    g.setColor(new Color(100,170,255));
	    g.drawString(N[3][i].toString(),30*i,41);
	    g.setColor(Color.white);
	    g.drawString(N[1][i].toString(),30*i,51);
	    g.drawString(N[2][i].toString(),30*i,61);
	}

	g.setColor(new Color(100,170,255));
	g.drawLine(25+30*n[0][0],34,25+30*n[0][0],59);

	g.translate(50+30*n[0][0],0);

        g.setColor(new Color(255,100,170));
	g.drawString("Q",10,41);
	g.drawLine(20,34,20,59);


	for(int i=1;i<=d[0][0];++i) {
            g.setColor(new Color(255,100,170));
	    g.drawString(D[3][i].toString(),30*i,41);
            g.setColor(Color.white);  
	    g.drawString(D[1][i].toString(),30*i,51);
	    g.drawString(D[2][i].toString(),30*i,61);
	}   

        g.setColor(new Color(255,100,170));
	g.drawLine(25+30*d[0][0],34,25+30*d[0][0],59);

	g.translate(-50-30*n[0][0],0);
	g.translate((int)(-B.x),0);
    }


    public void drawFunction1(Graphics g) {
        g.setFont(new Font("Monospaced",Font.PLAIN,10));
	g.setColor(Color.white);

	g.translate((int)(B.x),0);

	g.setColor(new Color(100,170,255));
	for(int i=1;i<=f[0][0];++i) {
	    g.setColor(Color.white);  
	    g.setColor(new Color(100,170,255));
	    g.drawString(F[2][i].toString(),30*i,41);
	    g.setColor(Color.white);
	    g.drawString(F[0][i].toString(),30*i,51);
	    g.drawString(F[1][i].toString(),30*i,61);
	}

	g.translate((int)(-B.x),0);
    }







    public void document() {
	M.setExplain("This window displays the defining functions for pairs of vertices which can be selected using the unfolding window.  Up to a positive constant, the defining function measures the difference in heights of the two vertices.  The defining functions all have the form \n\n Im(P times Q-conjugate).\n\n  Each of P and Q is an exponential sum.  A typical term in either of these sums has the form \n\n a exp(Pi i(bx+cy)/2) \n\n where a is 1 or -1 and b,c are integers.  The point (x,y) in the unit square is point which described the selected triangle. When we list the terms in P and Q we just list the triples of integers in columns. If the function is long, then it will be written off the end of the screen. You can see all of the function by dragging the text back and forth with the middle mouse button. \n\n Along the bar above the function display we print out some information about the function. \n\n The first number is the function value.\n\nThe pair of numbers is the gradient\n\nThe triple of numbers are absolute bounds on the second derivatives, derived from the fact that the sine and cosine functions and all their derivatives have absolute value at most 1.");
    }



}

