/*
 * GridManager.java
 *
 * Created on December 10, 2005, 1:44 PM
 */

import java.awt.*;
import java.awt.geom.*;

/**
 *
 * @author  pat
 */
public class GridManager implements ParameterSpaceRenderer {
    
    public final RationalGrid[] grids=new RationalGrid[2];
    private static Color grid_color=new Color(127,127,127,127);
    
    Manager M;
    boolean draw=true;
    
    public GridManager(Manager M) {
        this.M=M;
        grids[0]=RationalGrid.standardHorizontal();
        grids[0].computeLines();
        grids[1]=RationalGrid.standardVertical();
        grids[1].computeLines();

        M.addRendererTop(this);
    }
    
    public void render(Graphics2D g, AffineTransform T) {
	if(draw) {
        g.setColor(grid_color);
        for (int j=0; j<2; j++) {
            for (int i=0; i<grids[j].lines.length; i++) {
                if (grids[j].lines[i]!=null) {
                     g.draw(T.createTransformedShape(grids[j].lines[i]));
                } else {
                    System.out.println("Warning null line");
                }
            }
        }
	}
    }
        
}
