/*
 * HearingSpaceTile.java
 *
 * Created on October 30, 2005, 5:19 PM
 */

/**
 * A HearingSpaceTile is an object that wants to plot tiles looked at 
 * by McBilliards.
 * @author  pat
 */
public interface HearingSelectTile {
    /**
     * Called when a new tile has been selected.
     */
    public void selectTile(Tile t);
    
    /** 
     * Called when a property of the selected tile has been changed.
     * For example, this might be called when the color of a tile has been
     * changed.
     */    
    public void selectedTileModified();
    
}
