/*
 * LineSelectorCanvas.java
 *
 * Created on December 10, 2005, 10:24 AM
 */

import java.awt.*;
import java.awt.event.*;
import java.awt.geom.*;
import javax.swing.BoxLayout;

/**
 *
 * @author  pat
 */
public class LineSelector extends Container implements ParameterSpaceRenderer, HearingParameter {
    static final int padding=4;
    
    // Colors
    static final Color
    buttonBg=new Color(127,204,255),
    buttonFg=Color.black,
    selectedBg=Color.white,
    selectedFg=Color.black,
    modeBg=new Color(255,255,128),
    //optionBg=new Color(255,200,128);
    optionBg=new Color(0,100,0);
    
    private static Color[] grab_color={Color.red, Color.orange};
    
    private class GrabCanvas extends DBCanvas implements MouseListener {
        ListenString[] grabLS=new ListenString[8];
        public static final int zero=0;
        
        public GrabCanvas(){
            setBackground(optionBg);
            setFont(new Font("sanserif", Font.PLAIN, 12));
            
            double x=padding,y=padding;
            grabLS[0]=new ListenString("999999", this);
            grabLS[0].setLeft(x); grabLS[0].setTop(y);
            grabLS[0].setColors(buttonFg,grab_color[0]);
            grabLS[0].showBorder=false;
            
            y=grabLS[0].getBottom()+zero;
            grabLS[1]=new ListenString("999999", this);
            grabLS[1].setLeft(x); grabLS[1].setTop(y);
            grabLS[1].setColors(buttonFg,grab_color[0]);
            grabLS[1].showBorder=false;
            
            y=padding;
            x=grabLS[0].getRight()+10;
            grabLS[2]=new ListenString("999999", this);
            grabLS[2].setLeft(x); grabLS[2].setTop(y);
            grabLS[2].setColors(buttonFg,grab_color[0]);
            grabLS[2].showBorder=false;
            
            y=grabLS[2].getBottom()+zero;
            grabLS[3]=new ListenString("999999", this);
            grabLS[3].setLeft(x); grabLS[3].setTop(y);
            grabLS[3].setColors(buttonFg,grab_color[0]);
            grabLS[3].showBorder=false;
            
            x=padding;
            y=grabLS[1].getBottom()+10;
            grabLS[4]=new ListenString("999999", this);
            grabLS[4].setLeft(x); grabLS[4].setTop(y);
            grabLS[4].setColors(buttonFg,grab_color[1]);
            grabLS[4].showBorder=false;
            
            y=grabLS[4].getBottom()+zero;
            grabLS[5]=new ListenString("999999", this);
            grabLS[5].setLeft(x); grabLS[5].setTop(y);
            grabLS[5].setColors(buttonFg,grab_color[1]);
            grabLS[5].showBorder=false;
            
            y=grabLS[1].getBottom()+10;
            x=grabLS[4].getRight()+10;
            grabLS[6]=new ListenString("999999", this);
            grabLS[6].setLeft(x); grabLS[6].setTop(y);
            grabLS[6].setColors(buttonFg,grab_color[1]);
            grabLS[6].showBorder=false;
            
            y=grabLS[6].getBottom()+zero;
            grabLS[7]=new ListenString("999999", this);
            grabLS[7].setLeft(x); grabLS[7].setTop(y);
            grabLS[7].setColors(buttonFg,grab_color[1]);
            grabLS[7].showBorder=false;
            
            addMouseListener(this);
            setSize();
            setGrab(0);
            setGrab(1);
        }
        
        public void setGrab(int i) {
            if (grab[i]!=null) {
                int[] str=grab[i].toMcbRational();
                for (int j=0; j<4; j++)
                    grabLS[4*i+j].str=""+str[j];
            } else {
                for (int j=0; j<4; j++)
                    grabLS[4*i+j].str="grab";
            }
        }
        
        public void grab(int i) {
            grab[i]=M.getRationalTriangle();
            setGrab(i);
            if ((grab[0]!=null) && (grab[1]!=null)) {
                L=new RationalLine(grab[0], grab[1]);
                if (! updateLine()) {
                    M.spaceChanged();
                }
                return;
            } else {
                M.spaceChanged();
                repaintAll();
            }
        }
        
        public void setSize(){
            int x=0,y=0,temp;
            for (int i=0; i<grabLS.length; i++){
                temp=(int)(grabLS[i].getRight());
                if (temp>x)
                    x=temp;
                temp=(int)(grabLS[i].getBottom());
                if (temp>y)
                    y=temp;
            }
            //temp=(int)(doc.getRight());
            //if (temp>x)
            //    x=temp;
            setSize(x+padding,y+padding);
        }
        
        
        public void paint(Graphics gfx) {
            Graphics2D g=(Graphics2D) gfx;
            
            g.setRenderingHint(RenderingHints.KEY_ANTIALIASING,
            RenderingHints.VALUE_ANTIALIAS_ON);
            
            
            for (int i=0; i<grabLS.length; i++) {
                grabLS[i].render(g);
            }
            
            g.setColor(Color.black);
            for (int i=1; i<8; i+=2) {
                g.draw(new Line2D.Double(
                grabLS[i].getLeft()+3,grabLS[i].getTop(),
                grabLS[i].getRight()-3,grabLS[i].getTop()));
            }
            
            //Dimension D=this.getSize();
            //g.setColor(new Color(100,255,100));
            //g.drawRect(0,0,D.width-1,D.height-1);
        }
        
        public void mouseClicked(MouseEvent e) {
            for (int i=0; i<grabLS.length; i++) {
                if (grabLS[i].contains(e.getX(),e.getY())){
                    grab(i/4);
                    return;
                }
            }
        }
        
        
        public void mouseEntered(MouseEvent e) {
        }
        
        public void mouseExited(MouseEvent e) {
        }
        
        public void mousePressed(MouseEvent e) {
        }
        
        public void mouseReleased(MouseEvent e) {
        }
        
    }
    
    private class Equation1Canvas extends DBCanvas
    implements MouseListener, FocusListener, KeyListener {
        ListenString[] eq=new ListenString[6];
        
        int selected=-1;
        
        public Equation1Canvas() {
            setBackground(optionBg);
            setFont(new Font("sanserif", Font.PLAIN, 12));
            
            eq[0]=new ListenString("a", this);
            eq[0].setLeft(4);
            eq[1]=new ListenString("x+", this);
            eq[2]=new ListenString("b", this);
            eq[3]=new ListenString("y+", this);
            eq[4]=new ListenString("c", this);
            eq[5]=new ListenString("z=0", this);
            
            eq[1].showBorder=false;
            eq[3].showBorder=false;
            eq[5].showBorder=false;
            
            for (int i=0; i<eq.length; i++) {
                eq[i].setTop(4);
                eq[i].setColors(Color.black,Color.white);
            }
            
            setSize(200,(int)(eq[0].getBottom())+4);
            addMouseListener(this);
            addFocusListener(this);
            addKeyListener(this);
        }
        
        public void paint(Graphics gfx) {
            Graphics2D g=(Graphics2D) gfx;
            
            g.setRenderingHint(RenderingHints.KEY_ANTIALIASING,
            RenderingHints.VALUE_ANTIALIAS_ON);
            
            eq[0].str=Integer.toString(L.x[0]);
            eq[0].size();
            eq[2].str=Integer.toString(L.x[1]);
            eq[2].size();
            eq[4].str=Integer.toString(L.x[2]);
            eq[4].size();
            
            double x=padding-1;
            for (int i=0; i<eq.length; i++) {
                eq[i].makeIntegral();
                eq[i].setLeft(x);
                eq[i].render(g);
                x=eq[i].getRight()+1;
            }
            
            //Dimension D=this.getSize();
            //g.setColor(new Color(100,255,100));
            //g.drawRect(0,0,D.width-1,D.height-1);
        }
        
        public void deselect(){
            E1C.eq[E1C.selected].setColors(Color.black, Color.white);
            E1C.selected=-1;
        }
        
        public void mouseClicked(MouseEvent e) {
            boolean clicked=false;
            for (int i=0; i<5; i+=2) {
                if (eq[i].contains(e.getX(),e.getY())) {
                    if (selected==i) {
                        deselect();
                        repaint();
                        return;
                    }
                    if (selected!=-1)
                        deselect();
                    clicked=true;
                    selected=i;
                    eq[selected].setColors(Color.black, Color.yellow);
                    repaint();
                    return;
                }
            }
            if (selected!=-1) {
                deselect();
                repaint();
            }
        }
        
        public void mouseEntered(MouseEvent e) {
        }
        
        public void mouseExited(MouseEvent e) {
        }
        
        public void mousePressed(MouseEvent e) {
        }
        
        public void mouseReleased(MouseEvent e) {
        }
        
        public void focusGained(java.awt.event.FocusEvent focusEvent) {
        }
        
        public void focusLost(java.awt.event.FocusEvent focusEvent) {
            if (selected!=-1) {
                deselect();
                repaint();
            }
        }
        
        public void keyPressed(KeyEvent E) {
        }
        
        public void keyReleased(KeyEvent E) {
        }
        
        public void keyTyped(KeyEvent e) {
            if (e.getKeyChar()==KeyEvent.VK_TAB) {
                if (selected!=-1) {
                    int temp=selected;
                    deselect();
                    selected=(temp+2)%6;
                } else {
                    selected=0;
                }
                eq[selected].setColors(Color.black, Color.yellow);
                repaint();
                return;
            }
            if (e.getKeyChar()==KeyEvent.VK_ENTER) {
                if (selected!=-1) {
                    deselect();
                    repaint();
                }
                return;
            }
            if (selected!=-1) {
                int x=L.x[selected/2];
                int temp=x;
                if (e.getKeyChar()==KeyEvent.VK_BACK_SPACE) {
                    temp=temp/10;
                }
                if (e.getKeyChar()==KeyEvent.VK_DELETE) {
                    temp=0;
                }
                int ch=(int)(e.getKeyChar()-'0');
                if ((ch>=0)&&(ch<10)){
                    if (temp>=0) {
                        temp=10*temp+ch;
                    } else {
                        temp=10*temp-ch;
                    }
                }
                if (e.getKeyChar()=='-')
                    temp=-temp;
                //System.out.println("x="+x+" temp="+temp);
                
                if (x!=temp) {
                    L.x[selected/2]=temp;
                    updateLine();
                }
            }
        }
    }
    int mode;
    
    Manager M;
    
    //ModeCanvas MC;
    GrabCanvas GC;
    Equation1Canvas E1C;
    RationalTriangle[] grab=new RationalTriangle[2];
    RationalLine L;
    
    /** Creates a new instance of LineSelectorCanvas */
    public LineSelector(Manager M) {
        this.M=M;
        
        setBackground(Color.black);
        setLayout(new BoxLayout(this,BoxLayout.Y_AXIS));
        // this allows us to detect the TAB key
        //setFocusTraversalKeys(KeyboardFocusManager.FORWARD_TRAVERSAL_KEYS,
        //java.util.Collections.EMPTY_SET);
        
        //MC=new ModeCanvas();
        //MC.setSize();
        GC=new GrabCanvas();
        add(GC);
        E1C=new Equation1Canvas();
        add(E1C);
        
        
        L=M.getRationalLine();
        if (L==null)
            L=new RationalLine(1,-1,0);
        
        M.addRendererTop(this);
        M.hearParameter(this);
        updateLine();
        M.spaceChanged();
    }
    
    public void repaintAll(){
        GC.repaint();
        E1C.repaint();
    }
    
    /** return true if the space is told to change */
    public boolean updateLine() {
        if (L.isBoundaryValid()) {
            //System.out.println("valid line");
            if (! L.equals(M.getRationalLine())) {
                M.setRationalLine(L);
                M.spaceChanged();
                repaintAll();
                //System.out.println("updated canvases");
                return true;
            } else {
                //System.out.println("line already up to date");
            }
        } else {
            //System.out.println("invalid line");
            if (M.getRationalLine()!=null) {
                M.setRationalLine(null);
                M.spaceChanged();
                repaintAll();
                return true;
                //System.out.println("updated canvases2");
            }
        }
        repaintAll();
        return false;
    }
    
    public void removeManagement(){
        M.remove(this);
        M.spaceChanged();
    }
    
    private static void renderPoint(Graphics2D g, AffineTransform transform,
    Complex Z, Color C) {
        Point2D.Double pt=new Point2D.Double();
        transform.transform(new Point2D.Double(Z.x,Z.y),pt);
        
        Stroke temp=g.getStroke();
        g.setStroke(new BasicStroke(3));
        g.setColor(Color.black);
        g.draw(new Line2D.Double(pt.getX()-4, pt.getY()-4, pt.getX()+4, pt.getY()+4));
        g.draw(new Line2D.Double(pt.getX()-4, pt.getY()+4, pt.getX()+4, pt.getY()-4));
        g.setStroke(temp);
        
        g.setColor(C);
        g.draw(new Line2D.Double(pt.getX()-4, pt.getY()-4, pt.getX()+4, pt.getY()+4));
        g.draw(new Line2D.Double(pt.getX()-4, pt.getY()+4, pt.getX()+4, pt.getY()-4));
    }
    
    public void render(Graphics2D g, AffineTransform T){
        RationalLine L=M.getRationalLine();
        if (L!=null) {
            Line2D.Double l=L.toLineSegment();
            if (l!=null) {
                
                //All this awful nonsense tells Java to draw dashed lines
                Stroke prev=g.getStroke();
                float[] dash={(float)5,(float)5};
                g.setStroke(new BasicStroke(1,BasicStroke.CAP_SQUARE,
                BasicStroke.JOIN_ROUND,1,dash,0));
                
                
                g.setColor(Color.white);
                g.draw(T.createTransformedShape(l));
                
                //return drawing to normal
                g.setStroke(prev);
            } else {
                System.err.println("Warning attempted to render invalid line");
            }
        }
        
        for (int i=0; i<2; i++) {
            if (grab[i]!=null) {
                renderPoint(g, T, grab[i].toComplex(),  grab_color[i]);
            }
        }
    }
    
    public void parameterChanged() {
        if ((M.getRationalLine()!=null) && (!M.getRationalLine().equals(L))) {
            L=new RationalLine(M.getRationalLine());
            M.spaceChanged();
            repaintAll();
        }
    }
    
}
