import java.applet.Applet;
import java.awt.event.*;
import java.awt.*;
import java.awt.geom.*;
import java.util.*;
import java.lang.ref.WeakReference;

/**
 * This class offers a communications channel for different components of
 * McBilliards to talk to each other.
 *
 * Let me discuss these channels now:<ul>
 * <li> HearingBasicResults: communications about search results,
 * (that is a list of words) </li>
 * <li> HearingColor: communications about the current color </li>
 * <li> HearingExplain: communications for the help window </li>
 * <li> HearingObjects: This can be used for generic communication between
 * components. Communications of this type are expected to be extremely
 * inefficient.</li>
 * <li> HearingParameter: Choice of a triangle (also a choice of a point in
 * the parameter space) </li>
 * <li> HearingSelectTile: Tell canvases that a new tile has been selected.
 * <li> HearingSpaceChange: When the parameter space needs to be redrawn </li>
 * Tiles contain information such as the word.</li>
 * </ul>
 */
public class Manager
implements HearingBasicResults, HearingColor, HearingExplain,
HearingObjects, HearingSelectTile, HearingSpaceChange,
ParameterSpaceRenderer {
    


    //added by Rich for his 100 degree result
    int n;
    public int getN() {
	return(n);
    }

    Complex[][] POLY=new Complex[1][10];
    public Complex[] getPOLY() {
	return(POLY[0]);
    }

    public Complex[][] getAllPOLY() {
	return(POLY);
    }
    int depth,boxes,time;
    int[][] exceptions=new int[20][2];

    //end of stuff added by Rich




    
    ///////////////// The MOUSE
    
    /** if mouse=1 we are in 3 button mode, if mouse=0 we are in one button mode */
    int mouse;
    /** if mouse=0, then emulate button=mode presses for mode equal 1,2,3*/
    int mode;
    
    ///////////////// SUBMANAGERS
    
    public GridManager GM;
    public SpaceTileManager STM;
    private ParameterManager PM;
    public ParameterSpaceManager PSM;
    
    ///////////////// Stored objects
    
    /** The current color selected */
    public Color CurrentColor;
    
    /** The Current Tile */
    public Tile selectedTile;
    
    //// this is the viewing rectangle
    Rectangle2D.Double view;
    
    ///////////////// References and lists of references of objects to canvases
    
    /** The documentation canvas */
    WeakReference hExplain;
    
    /** Set of WeakReferences to HearingParameters */
    private LinkedList hParameter;
    
    /** This class listens to the basic search results */
    private WeakReference hBasicResults;
    
    /** This class selects SpaceTiles */
    private LinkedList hSelectTile;
    
    /** This class keeps track of parameter space changes */
    private LinkedList hSpaceChange;
    
    /*** A linked list of references to HearingObjects ****/
    private LinkedList hObjects;
    
    
    public Manager() {
        /* set some default values */
        CurrentColor=new Color(255,255,255);
        
        //default to 3 button mouse
        mouse=1;
        // if 1 button mouse default to middle button
        mode=2;
        view=new Rectangle2D.Double(0,0,1,1);
        
        /// submanagers (order is important)
        PM=new ParameterManager();
        PSM=new ParameterSpaceManager(this);
        STM=new SpaceTileManager(this);
        GM=new GridManager(this);
        
        // default to the fagnano curve
        selectedTile=new SearchTile("123123");
        
        hExplain=new WeakReference(null);
        hParameter=new LinkedList();
        hSelectTile=new LinkedList();
        hSpaceChange=new LinkedList();
        hObjects=new LinkedList();
        hBasicResults=new WeakReference(null);
    }
    
    /*********** COLORS ************/
    
    /** Process a color change */
    public void setColor(Color C) {
        CurrentColor=C;
    }
    
    /** get the current color */
    public Color getColor() {
        return CurrentColor;
    }
    
    
    /*********** POINT IN PARAMETER SPACE ************/
    
    /** Add me to the list of objects we notify when the parameter changes */
    public void hearParameter(HearingParameter me){
        hParameter.add(new WeakReference(me));
    }
    
    private void updateParameterListeners(){
        Object o;
        for (ListIterator it=hParameter.listIterator();it.hasNext();){
            o=((WeakReference)it.next()).get();
            if (o==null) {
                //System.out.println("Non-manual removal of HearingParameter");
                it.remove();
            } else
                ((HearingParameter)o).parameterChanged();
        }
        o=null;
    }
    
    //////////////// The Complex Parameter
    
    /** Call this to change the point in the parameter space */
    public void setParameter(double X, double Y) {
        PM.setParameter(X,Y);
        updateParameterListeners();
    }
    
    /** Call this to change the point in the parameter space */
    public void setParameter(Complex Z) {
        PM.setParameter(Z);
        updateParameterListeners();
    }
    
    /** Get the current x coordinate in the parameter space */
    public double getX(){
        return PM.getX();
    }
    
    /** Get the current y coordinate in the parameter space */
    public double getY(){
        return PM.getY();
    }
    
    /** Return the current McBilliards coordinate as a complex number */
    public Complex getZ(){
        return PM.getZ();
    }
    
    //////////////////// The Rational Triangle
    
    /** set the rational triangle */
    public void setRationalTriangle(RationalTriangle t) {
        PM.setRationalTriangle(t);
        updateParameterListeners();
    }
    
    /** get the rational triangle */
    public RationalTriangle getRationalTriangle() {
        return PM.getRationalTriangle();
    }
    
    /////////////////// The Rational Line
    
    /** set the rational line */
    public void setRationalLine(RationalLine l) {
        PM.setRationalLine(l);
        updateParameterListeners();
    }
    
    /** get the rational line */
    public RationalLine getRationalLine() {
        return PM.getRationalLine();
    }
    
    //////////// Combined
    /** this avoids two calls to each listener to parameter changes. */
    public void setParameters(Complex z, RationalTriangle t) {
        PM.setParameter(z);
        PM.setRationalTriangle(t);
        updateParameterListeners();
    }
    
    /*********** DOCUMENTATION *********/
    
    /** Set me to be the documenting component */
    public void hearExplain(HearingExplain me){
        hExplain=new WeakReference(me);
    }
    
    /** Set the documenting text */
    public void setExplain(String doc) {
        if (hExplain.get()!=null)
            ((HearingExplain)hExplain.get()).setExplain(doc);
        else {
            //System.out.println("Sending Documentation failed");
        }
    }
    
    /*********** BASIC SEARCH RESULTS ************/
    
    /** Set me to be the component that handles basic search results */
    public void hearBasicResults(HearingBasicResults me){
        //System.out.println("Setting HearingBasicResults");
        hBasicResults=new WeakReference(me);
    }
    
    /** Set the search results */
    public void setBasicResults(BasicSearchResults results){
        if (hBasicResults.get()!=null) {
            ((HearingBasicResults)hBasicResults.get()).setBasicResults(results);
        } else {
            //System.out.println("Sending Basic Results failed");
        }
    }
    
    /************* Plot tiles *************/
    
    public void plotTile(Tile st){
        //System.out.println("Plot Tile");
        //System.out.flush();
        STM.plotTile(st);
        selectTile(st);
    }
    
    /************* Select tiles *************/
    
    /** Add me to the list of components that care about the
     * selected tile word
     */
    public void hearSelectTile(HearingSelectTile me){
        hSelectTile.add(new WeakReference(me));
    }
    
    /** Start thinking about the word w */

    public void selectTile(Tile T) {
        if (T==null) 
            return;
        
        //System.out.println("Select Tile");
        //System.out.flush();
        selectedTile=T;
        Object o;
        for (ListIterator it=hSelectTile.listIterator();it.hasNext();){
            o=((WeakReference)it.next()).get();
            if (o==null){
                //System.out.println("Non-manual removal of HearingParameter");
                it.remove();
            } else {
                //System.out.println("Thread \""+Thread.currentThread().getName()+"\" Notifying "+o.getClass().getName()+" of selected tile");
                ((HearingSelectTile)o).selectTile(T);
            }
        }
        o=null;
    }
    
    public void selectedTileModified() {
        Object o;
        for (ListIterator it=hSelectTile.listIterator();it.hasNext();){
            o=((WeakReference)it.next()).get();
            if (o==null){
                //System.out.println("Non-manual removal of HearingParameter");
                it.remove();
            } else
                ((HearingSelectTile)o).selectedTileModified();
        }
        o=null;
    }
    
    public Tile getSelectedTile() {
        return selectedTile;
    }
    
    /** return the current word */
    public String getWord(){
        return selectedTile.getStringWord();
    }
    
    /** return the current wordlength */
    public int getWordLength(){
        return selectedTile.getStringWord().length();
    }
    
    /************ Parameter Space ***********/
    
    /** Register to hear about parameter space changes */
    public void hearSpaceChange(HearingSpaceChange me) {
        hSpaceChange.add(new WeakReference(me));
    }
    
    /** notify all components that care, that the rendering of the parameter
     * space has changed (for example, maybe a tile has been added).
     * Generally, such a component would then repaint. */
    public void spaceChanged() {
        //System.out.println("Space Changed");
        //System.out.flush();
        Object o;
        for (ListIterator it=hSpaceChange.listIterator();it.hasNext();){
            o=((WeakReference)it.next()).get();
            if (o==null){
                //System.out.println("Non-manual removal of HearingParameter");
                it.remove();
            } else {
                //System.out.println("Thread \""+Thread.currentThread().getName()+"\" Notifying "+o.getClass().getName()+" of a space change");
                ((HearingSpaceChange)o).spaceChanged();
            }
        }
        o=null;
    }
    
    /** notify all components that care that the viewing rectangle
     * has changed*/
    public void setViewingRectangle(Rectangle2D.Double rect) {
        view=rect;
        Object o;
        for (ListIterator it=hSpaceChange.listIterator();it.hasNext();){
            o=((WeakReference)it.next()).get();
            if (o==null){
                //System.out.println("Non-manual removal of HearingParameter");
                it.remove();
            } else
                ((HearingSpaceChange)o).setViewingRectangle(rect);
        }
        o=null;
    }
    
    public Rectangle2D.Double getViewingRectangle() {
        return view;
    }
    
    public void render(Graphics2D g, java.awt.geom.AffineTransform T) {
        PSM.render(g,T);
    }
    /** Add me to the list of components that render to the canvas
     * I want to draw first! (meaning everything else will draw on top of me
     */
    
    public void addRendererBottom(ParameterSpaceRenderer me) {
        PSM.addRendererBottom(me);
    }
    
    /** Add me to the list of components that render to the canvas
     * I want to draw last! (meaning I draw on top of everything else)
     */
    public void addRendererTop(ParameterSpaceRenderer me) {
        PSM.addRendererTop(me);
    }
    
    
    /************ Objects ***************/
    
    /** Register to hear about discussed objects */
    public void hearObjects(HearingObjects me) {
        hObjects.add(new WeakReference(me));
    }
    
    /** send an object to all components that care */
    public void setObject(Object obj) {
        Object o;
        for (ListIterator it=hObjects.listIterator();it.hasNext();){
            o=((WeakReference)it.next()).get();
            if (o==null){
                //System.out.println("Non-manual removal of HearingParameter");
                it.remove();
            } else
                ((HearingObjects)o).setObject(obj);
        }
        o=null;
    }
    
    
    /*************** REMOVAL *******************/
    
    /** This is a function that removes all references of the given object */
    public void remove(Object obj){
        //System.out.println("Manager removing a "+obj.getClass().getName());
        
        // also remove from any sub-managers
        PSM.remove(obj);
        
        Object o;
        for (ListIterator it=hParameter.listIterator(); it.hasNext();){
            o=((WeakReference)it.next()).get();
            if (o==null) {
                it.remove();
                //System.out.println("Non-Manual removal of a HearingParameter");
            } else if (o==obj) {
                it.remove();
                //System.out.println("Manual removal of a HearingParameter");
            }
            
        }
        for (ListIterator it=hSelectTile.listIterator(); it.hasNext();){
            o=((WeakReference)it.next()).get();
            if (o==null) {
                it.remove();
                //System.out.println("Non-Manual removal of a HearingSelectTile");
            } else if (o==obj) {
                it.remove();
                //System.out.println("Manual removal of a HearingSelectTile");
            }
        }
        for (ListIterator it=hSpaceChange.listIterator(); it.hasNext();){
            o=((WeakReference)it.next()).get();
            if (o==null) {
                it.remove();
                //System.out.println("Non-Manual removal of a HearingSpaceChange");
            } else if (o==obj) {
                it.remove();
                //System.out.println("Manual removal of a HearingSpaceChange");
            }
        }
        if (obj==hExplain.get()){
            //System.out.println("Manual Removal of HearingExplain");
            hExplain.clear();
        }
        if (obj==hBasicResults.get()) {
            //System.out.println("Manual Removal of HearingBasicResults");
            hBasicResults.clear();
        }
        o=null;
        debugPrint();
    }
    
    public void debugPrint(){
        //System.out.println("Number of HearingParameters: "+hParameter.size());
        //System.out.println("Number of HearingWords: "+hWord.size());
    }
    
    
}
