/*
 * McbFile.java
 *
 * Created on December 1, 2005, 1:39 PM
 */

import java.awt.Color;
import java.util.*;
import java.io.*;
import java.net.URL;

/**
 *
 * @author  pat
 */
public class McbFile {
    public LinkedList tiles;
    
    /** Creates an empty McbFile */
    public McbFile() {
        tiles=new LinkedList();
    }
    
    /** Load a list of McbTiles into tiles from file name */
    public McbFile(String name) {
        tiles=new LinkedList();
        
        int num=0;
        String W=null;
        Color C=null;
        try {
            String thisLine;
            InputStream is = getClass().getResourceAsStream("Files/Memory/"+name);
            BufferedReader br = new BufferedReader(new InputStreamReader(is));
            
            String[] terms;
            while ((thisLine = br.readLine()) != null) {
                num++; // line number in file
                terms=thisLine.split(" ");
                if (terms[0].equals("BEGIN")) {
                    W=null;
                    C=null;
                } else if (terms[0].equals("word")) {
                    W=terms[1];
                } else if (terms[0].equals("color")) {
                    int[] x=new int[3];
                    char ch;
                    for (int i=0; i<3; i++) {
                        ch=terms[1].charAt(i);
                        if ((ch>='0')&&(ch<='9')) {
                            x[i]=(int)(ch-'0');
                        } else if ((ch>='a')&&(ch<='f')) {
                            x[i]=(int)(ch-'a'+10);
                        }
                    }
                    C=new Color((float)x[0]/15,
                    (float)x[1]/15,(float)x[2]/15);
                } else if (terms[0].equals("END")) {
                    if ((W!=null)&&(C!=null))
                        tiles.add(new McbTile(W,C));
                }
            }
        }
        catch (Exception e) {
            System.err.println("Error reading from Files/Memory/"+name+
            ". Here is some debugging info:");
            System.err.println("Error occured when reading line "+num+" from file.");
            System.err.flush();
            e.printStackTrace();
        }
    }
    
    
}
