/*
 * PopupListCanvas.java
 *
 * Created on October 30, 2005, 8:59 PM
 */

import java.awt.*;
import java.awt.event.*;

/**
 *
 * @author  pat
 */
public class MorePopupsCanvas extends DBCanvas implements HearingPopup, MouseListener {
    Manager M;
    SpaceTileManager STM;
    
    ListenString[] ls;
    Component[] c;
    PopupWindow[] p;
    
    // Colors
    Color buttonBg, buttonFg, selectedBg, selectedFg;
    
    // Constants
    int padding;
    
    /** Creates a new instance of PopupListCanvas */
    public MorePopupsCanvas(Manager M, SpaceTileManager STM) {
        this.M=M;
        this.STM=STM;
        
        // Colors
        setBackground(new Color(0,100,0));
        buttonFg=Color.black;
        selectedFg=Color.black;
        buttonBg=new Color(100,255,100);
        selectedBg=Color.yellow;
        
        
        // Buttons
        setFont(new Font("sanserif", Font.PLAIN, 12));
        padding=4;
        
        int N=3; //RICH: changed from 2 to 3
        ls=new ListenString[N];
        c=new Component[N];
        p=new PopupWindow[N];
        
        ls[0]=new ListenString("line selector", this);
        ls[1]=new ListenString("grid manager", this);  
        ls[2]=new ListenString("100 degree result", this); //RICH: added 
        
        double x=padding,y=padding;
        for (int i=0; i<ls.length; i++){
            ls[i].setLeft(x); ls[i].setTop(y);
            y=ls[i].getBottom()+padding;
            ls[i].setColors(buttonFg, buttonBg);
        }
        
        addMouseListener(this);
    }
    
    public void setSize(){
        int x=0,y=0,temp;
        for (int i=0; i<ls.length; i++){
            temp=(int)(ls[i].getRight());
            if (temp>x)
                x=temp;
            temp=(int)(ls[i].getBottom());
            if (temp>y)
                y=temp;
        }
        //temp=(int)(doc.getRight());
        //if (temp>x)
        //    x=temp;
        setSize(x+padding+1,y+padding+1);
    }
    
    public void paint(Graphics gfx) {
        Graphics2D g=(Graphics2D) gfx;
        
        g.setRenderingHint(RenderingHints.KEY_ANTIALIASING,
        RenderingHints.VALUE_ANTIALIAS_ON);
        
        for (int i=0; i<ls.length; i++) {
            ls[i].render(g);
        }
        //doc.render(g);
        Dimension D=this.getSize();
        g.setColor(new Color(100,255,100));
        g.drawRect(0,0,D.width-1,D.height-1);
    }
    
    public void popupClosed(Component C) {
        for (int i=0; i<c.length; i++) {
            if (c[i]==C) {
                p[i]=null;
                // process components that require specific attention
                switch (i){
                    case 0: // unfolding;
                        ((LineSelector)C).removeManagement();
                        break;
                    case 1:
                        ((GridManagerPopup)C).cleanup();
			break;                       
                }
                M.remove(C);
                c[i]=null;
                ls[i].setColors(buttonFg, buttonBg);
                repaint();
                return;
            }
        }
    }
    
    private void show(int i){
        switch (i){
            case 0: // unfolding
                LineSelector LS=new LineSelector(M);
                //LS.setSize();
                p[i]=new PopupWindow("Line Selector", LS, this);
                c[i]=LS;               
                break;
            case 1:
                GridManagerPopup gl=new GridManagerPopup(M);
                //LS.setSize();
                p[i]=new PopupWindow("Grid Manager", gl, this);
                c[i]=gl;
                break;
	   case 2:
	       Deg100Canvas DC=new Deg100Canvas(M);  //RICH: added
                p[i]=new PopupWindow("100 Degree Result", DC, this); 
                c[i]=DC;
                break;
        }
        ls[i].setColors(selectedFg, selectedBg);
    }
    
    public void closeAll() {
        for (int i=0; i<p.length; i++) {
            if (p[i]!=null) {
                p[i].forceClose();
            }
        }
    }
    
    public void mouseClicked(MouseEvent e) {
        for (int i=0; i<ls.length; i++) {
            if (ls[i].contains(e.getX(),e.getY())){
                if (c[i]==null) {
                    // create the popup
                    show(i);
                    repaint();
                }
            }
        }
        //if (doc.contains(e.getX(),e.getY()))
        //    document();
    }
    
    public void mouseEntered(MouseEvent e) {
    }
    
    public void mouseExited(MouseEvent e) {
    }
    
    public void mousePressed(MouseEvent e) {
    }
    
    public void mouseReleased(MouseEvent e) {
    }
    
    public void document(){
        M.setExplain("You can select a popup from this window. Press one of these buttons and a new window will appear.");
    }
}
