import java.applet.Applet;
import java.awt.event.*;
import java.awt.*;

public class MouseCanvas extends DBCanvas implements MouseListener {
    ListenSquare[] L=new ListenSquare[8];
    int mouse,mode;
    Manager M;
    
    public  MouseCanvas(Manager M) {
        // add the manager
        this.M=M;
        
        addMouseListener(this);
        L[1]=new ListenSquare(3,3,25,Color.white);
        L[2]=new ListenSquare(32,3,25,Color.white);
        L[3]=new ListenSquare(3,80,16,Color.white);
        L[4]=new ListenSquare(22,80,16,Color.white);
        L[5]=new ListenSquare(41,80,16,Color.white);
        L[6]=new ListenSquare(3,104,12,12,Color.black);
        L[6].on=1;
        L[2].on=1;
        L[4].on=1;
        mouse=1;
        mode=2;
    }
    
    public void paint(Graphics gfx) {
        Graphics2D g=(Graphics2D) gfx;
        g.setRenderingHint(RenderingHints.KEY_ANTIALIASING,
        RenderingHints.VALUE_ANTIALIAS_ON);
        
        Dimension D=this.getSize();
        g.setColor(new Color(100,0,100));
        g.fillRect(0,0,D.width-1,D.height-1);
        L[6].infoRender(g);
        for(int i=1;i<=2;++i) L[i].render(g,Color.blue);
        
        
        if(mouse==0) {
            for(int i=3;i<=5;++i) L[i].render(g,Color.blue);
        }
        g.setColor(Color.white);
        g.setFont(new Font("Helvetica",Font.PLAIN,12));
        g.drawString("1",13,19);
        g.drawString("3",42,19);
        g.drawString("mouse",12,42);
        if(mouse==0) g.drawString("mode",14,74);
        g.setColor(Color.white);
        g.drawRect(0,0,D.width-1,D.height-1);
    }
    
    
    public void mouseReleased(MouseEvent e) {}
    public void mousePressed(MouseEvent e) {}
    public void mouseEntered(MouseEvent e) {}
    public void mouseExited(MouseEvent e) {}
    public void mouseClicked(MouseEvent e) {
        Point X=new Point();
        e.consume();
        X.x=e.getX();
        X.y=e.getY();
        int test=0;
        for(int i=1;i<=6;++i) {
            if(L[i].inside(X)==1) test=i;
        }
        if(test==6) {document();}
        
        
        if(test==1) {
            mouse=0;
            mode=2;
            L[1].on=1;
            L[2].on=0;
            L[3].on=0;
            L[4].on=1;
            L[5].on=0;
        }
        if(test==2) {
            mouse=1;
            L[2].on=1;
            L[1].on=0;
        }
        if((mouse==0)&&(test>2)) {
            mode=test-2;
            L[3].on=0;
            L[4].on=0;
            L[5].on=0;
            L[test].on=1;
        }
        // notify the manager
        M.mouse=mouse;
        M.mode=mode;
        repaint();        
    }
    


    

    public void document() {
        M.setExplain("This is the mouse window.  We are writing web McBilliards so that it is best operated with a 3 button mouse.  However, some computers use 1 button mouses.  Also, some browsers do not handle 3 button mouse inputs correctly.  This window lets you tell the applet which kind of mouse you have.  If you select the 1 button option then 3 more buttons will appear.\n\n  Using the 3 mode buttons you can simulate the effect of having a 3 button mouse.  If you select the left button then the applet will think that you are clicking the left mouse button, etc. Many of the actions on the applet are button independent, and for these actions it doesn't matter which button mode you have selected.");
    }
    
    
    
    
}
