import java.applet.Applet;
import java.awt.event.*;
import java.awt.*;

public class PalindromeFunction {
    public PalindromeFunction() {}



    public static int[][] getFunction(VertexPair V,CombinatorialTriangle[] CT) {

       int[][] d=Function.computeDenominator(V,CT);
       int[][] n=Function.getSignedNumerator(d,V,CT);
       int[][] f=new int[3][n[0][0]+1];

       int a1=CT[1].c[0];
       int a2=CT[2].c[0];
       int a3=Spine.spineNumber(V,CT);

       int sign=-1;
       if((a1==1)&&(a2==2)) sign=-sign;
       if((a1==2)&&(a2==0)) sign=-sign;
       if((a1==2)&&(a2==1)&&(a3==0)) sign=-sign;
       if((a1==2)&&(a2==0)&&(a3==1)) sign=-sign;



       n[1][0]=sign;

       for(int j=0;j<3;++j) {
       for(int i=0;i<=n[0][0];++i) {
	   if(j!=2) f[j][i]=        n[j+1][i];
	   if(j==2) f[j][i]=n[1][0]*n[j+1][i];
       }}
       f[0][0]=n[0][0];
       return(f);
  }
    



    public static int[][] getFunction(int[][] d,VertexPair V,CombinatorialTriangle[] CT) {

       int[][] n=Function.getSignedNumerator(d,V,CT);
       int[][] f=new int[3][n[0][0]+1];

       int a1=CT[1].c[0];
       int a2=CT[2].c[0];
       int a3=Spine.spineNumber(V,CT);

       int sign=-1;
       if((a1==0)&&(a2==1)) sign=-sign;
       if((a1==1)&&(a2==2)) sign=-sign;
       if((a1==2)&&(a2==0)) sign=-sign;
       if((a1==2)&&(a2==1)&&(a3==0)) sign=-sign;
       if((a1==2)&&(a2==0)&&(a3==1)) sign=-sign;

       n[1][0]=sign;

       for(int j=0;j<3;++j) {
       for(int i=0;i<=n[0][0];++i) {
	   if(j!=2) f[j][i]=        n[j+1][i];
	   if(j==2) f[j][i]=n[1][0]*n[j+1][i];
       }}
       f[0][0]=n[0][0];
       return(f);
  }
    



    /**z McScaled during routine*/

public static double evaluate(int[][] f,Complex zz) {
  double total=0.0;
  Complex z=new Complex(Math.PI*zz.x/2.0,Math.PI*zz.y/2.0);

  for(int i=1;i<=f[0][0];++i) {
      int a=f[2][i];
      int b=f[0][i];
      int c=f[1][i];
    total=total+a*Math.cos(b*z.x+c*z.y);
  }
  return(total);
}


    /**z McScaled during routine*/

    public static double gradient(int q,int[][] f,Complex zz) {
  double total=0.0;
  Complex z=new Complex(Math.PI*zz.x/2.0,Math.PI*zz.y/2.0);

  for(int i=1;i<=f[0][0];++i) {
      int a=f[2][i];
      int b=f[0][i];
      int c=f[1][i];
      if(q==1)  total=total-a*b*Math.sin(b*z.x+c*z.y);
      if(q==2)  total=total-a*c*Math.sin(b*z.x+c*z.y);
  }
  return(total);
}





public static int absoluteSecondDerivative(int[][] f,int n1,int n2) {

  int a,b,c,d;
  int total=0;
  d=0;
  for(int i=1;i<=f[0][0];++i) {
   a=f[0][i];
   b=f[1][i];
   c=f[2][i];
   if((n1==2)&&(n2==0)) d=c*a*a;
   if((n1==1)&&(n2==1)) d=c*a*b;
   if((n1==0)&&(n2==2)) d=c*b*b;
   if(d<0) d=-d;
   total=total+d;
  }
  return(total);
}








    /**Uses the test method to test if a function is positive
       on a given square.  

       z is the center of the square and the radius is
       Pi/2* power(1/2,n).*/

    public static int testPositive(int[][] f,DyadicSquare Q) {
	int direction=certify(f,Q);
	int test=signEvaluate(f,Q,direction);
	if(test==2) return(1);
	return(0);
    }

    public static int testNegative(int[][] f,DyadicSquare Q) {
	int direction=certify(f,Q);
	int test=signEvaluate(f,Q,direction);
	if(test==1) return(1);
	return(0);
    }

    public static int crudePositiveTest(int[][] f,DyadicSquare Q) {
	double[] x=new double[20];
	Complex Z=Q.getCenter();
	x[0]=evaluate(f,Z);
	x[1]=Math.PI*Math.pow(0.5,Q.k+2);
	x[2]=x[1]*x[1];
	x[3]=Math.abs(gradient(1,f,Z));
	x[4]=Math.abs(gradient(2,f,Z));
	x[5]=x[1]*(x[3]+x[4]);
	x[6]=absoluteSecondDerivative(f,0,2);
	x[7]=absoluteSecondDerivative(f,1,1);
	x[8]=absoluteSecondDerivative(f,2,0);
	x[9]=x[2]*(x[6]+2*x[7]+x[8]);
	x[10]=x[5]+x[9];
	x[11]=x[0]-x[10];
	if(x[11]>0) return(1);
	return(0);
    }



    public static int crudeVanishingTest(int[][] f) {
	double x;
	for(int i=2;i<=9;++i) {
	    Complex Z=new Complex(.01*i,1.0-.01*i);
  	    x=evaluate(f,Z);
	    if(Math.abs(x)>0.000000000001) return(0);
	}
	return(1);
    }



    public static int crudeNegativeTest(int[][] f,DyadicSquare Q) {
	double[] x=new double[20];
	Complex Z=Q.getCenter();
	x[0]=evaluate(f,Z);
	x[1]=Math.PI*Math.pow(0.5,Q.k+2);
	x[2]=x[1]*x[1];
	x[3]=Math.abs(gradient(1,f,Z));
	x[4]=Math.abs(gradient(2,f,Z));
	x[5]=x[1]*(x[3]+x[4]);
	x[6]=absoluteSecondDerivative(f,0,2);
	x[7]=absoluteSecondDerivative(f,1,1);
	x[8]=absoluteSecondDerivative(f,2,0);
	x[9]=x[2]*(x[6]+2*x[7]+x[8]);
	x[10]=x[5]+x[9];
	x[11]=x[0]+x[10];
	if(x[11]<0) return(1);
	return(0);
    }







    /**not McScaled*/

public static int signEvaluate(int[][] f,DyadicSquare Q,int direction) {
if(direction==0) return(0);
  Complex[] Z=Spine.getRelevant(Q,direction);
  double min=evaluate(f,Z[1]);
  if(min>=0) return(2);
  double max=evaluate(f,Z[0]);
  if(max<=0) return(1);
  return(0);
}

public static int mixedEvaluate(int[][] f,DyadicSquare Q,int direction) {
if(direction==0) return(0);
  Complex[] Z=Spine.getRelevant(Q,direction);
  double min=evaluate(f,Z[1]);
  double max=evaluate(f,Z[0]);
  if(min*max<0) return(1);
  return(0);
}








/*the goal of this routine is to tell
  if the gradient of a function, as
  it varies over a square in the 
  parameter space, lies in a quadrant.
  The values (grad1,grad2)
  give the gradient at the center of
  the point.  The terms (b1,b2)
  are bounds on the 2nd derivatives.
  These bounds guarantee that:

  grad1-bb1*r < grad1(x) <grad1+bb1*r
  grad2-bb2*r < grad2(x) <grad2+bb2*r

  where r is either the diam of the
  box or twice the diam, depending on
  which test we are using.  Here are the
  returns of the function:

  0 not certified
  1 certified, grad in ++ quadrant
  2 certified, grad in 0+ quadrant
  3 certified, grad in -+ quadrant
  4 certified, grad in -0 quadrant
  5 certified, grad in -- quadrant
  6 certified, grad in 0- quadrant
  7 certified, grad in +- quadrant
  8 certified, grad in +0 quadrant
*/



    public static int certify(int[][] f,DyadicSquare Q) {
	return(certify(f,Q.getCenter(),Q.k));
    }




    public static int riskCertify(int[][] f,DyadicSquare Q) {
	return(riskCertify(f,Q.getCenter(),Q.k));
    }







/**z not McScaled during routine. uses McB coordinates for z*/


    public static int certify(int[][] f,Complex z,int k) {

	double[] x=new double[8];
        double step,grad1,grad2,a1,a2,b1,b2;
        int a20,a02,a11;
        double d20,d02,d11;

  /*first we compute the first derivatives*/

	grad1=gradient(1,f,z);
	grad2=gradient(2,f,z);

        a11=absoluteSecondDerivative(f,1,1);
        a02=absoluteSecondDerivative(f,0,2);
        a20=absoluteSecondDerivative(f,2,0);
        d20=1.0*a20;
        d11=1.0*a11;
        d02=1.0*a02;

   /*now we have all the quantities*/

   //test standard quadrant:

        step=Math.PI*Math.pow(0.5,k+2);  //square radius
        a1=d20+d11;
        a2=d02+d11;
        b1=step*a1;
        b2=step*a2;

        x[1]=0;x[2]=0;x[3]=0;x[4]=0;
        if((grad1+b1>0)&&(grad1-b1>0)) x[1]=1;
        if((grad2+b2>0)&&(grad2-b2>0)) x[2]=1;
        if((grad1+b1<0)&&(grad1-b1<0)) x[3]=1;
        if((grad2+b2<0)&&(grad2-b2<0)) x[4]=1;

        if((x[1]>0)&&(x[2]>0)) return(1);
        if((x[2]>0)&&(x[3]>0)) return(3);
        if((x[3]>0)&&(x[4]>0)) return(5);
        if((x[4]>0)&&(x[1]>0)) return(7);

       //standard quadrant test has failed.
       //now we look at a square twice as
       //large and try to show that the gradient
       //lies in some quadrant.

       step=Math.PI*Math.pow(0.5,k+1); //twice square radius
       a1=d11;
       if(a1<d20) a1=d20;
       a2=d11;
       if(a2<d02) a2=d02;
       b1=step*a1;
       b2=step*a2;

       x[1]=grad1+b1;
       x[2]=grad2+b2;
       x[3]=grad1-b1;
       x[4]=grad2-b2;

       x[5]=Math.abs(x[1]);
       if(x[5]<Math.abs(x[3])) x[5]=Math.abs(x[3]);
       x[6]=Math.abs(x[2]);
       if(x[6]<Math.abs(x[6])) x[6]=Math.abs(x[4]);
       if(( x[2]>x[5])&&( x[4]>x[5]))   return(2);
       if((-x[1]>x[6])&&(-x[3]>x[6])) return(4);
       if((-x[2]>x[5])&&(-x[4]>x[5]))   return(6);
       if(( x[1]>x[6])&&( x[3]>x[6])) return(8);
       return(0);
    }





/**z not McScaled during routine. uses McB coordinates for z*/
/**This version treats the defining function as linear.*/


    public static int riskCertify(int[][] f,Complex z,int k) {

	double[] x=new double[8];
        double step,grad1,grad2,a1,a2,b1,b2;
        double d20,d02,d11;

  /*first we compute the first derivatives*/

	grad1=gradient(1,f,z);
	grad2=gradient(2,f,z);

	//guess that the second derivatives are equal to the length of the word
        //this is incorrect but fairly reasonable, hence the term 'risk'.

        d20=f[0][0];
        d11=f[0][0];
        d02=f[0][0];

   /*now we have all the quantities*/

   //test standard quadrant:

        step=Math.PI*Math.pow(0.5,k+2);  //square radius
        a1=d20+d11;
        a2=d02+d11;
        b1=step*a1;
        b2=step*a2;

        x[1]=0;x[2]=0;x[3]=0;x[4]=0;
        if((grad1+b1>0)&&(grad1-b1>0)) x[1]=1;
        if((grad2+b2>0)&&(grad2-b2>0)) x[2]=1;
        if((grad1+b1<0)&&(grad1-b1<0)) x[3]=1;
        if((grad2+b2<0)&&(grad2-b2<0)) x[4]=1;

        if((x[1]>0)&&(x[2]>0)) return(1);
        if((x[2]>0)&&(x[3]>0)) return(3);
        if((x[3]>0)&&(x[4]>0)) return(5);
        if((x[4]>0)&&(x[1]>0)) return(7);

       //standard quadrant test has failed.
       //now we look at a square twice as
       //large and try to show that the gradient
       //lies in some quadrant.

       step=Math.PI*Math.pow(0.5,k+1); //twice square radius
       a1=d11;
       if(a1<d20) a1=d20;
       a2=d11;
       if(a2<d02) a2=d02;
       b1=step*a1;
       b2=step*a2;

       x[1]=grad1+b1;
       x[2]=grad2+b2;
       x[3]=grad1-b1;
       x[4]=grad2-b2;

       x[5]=Math.abs(x[1]);
       if(x[5]<Math.abs(x[3])) x[5]=Math.abs(x[3]);
       x[6]=Math.abs(x[2]);
       if(x[6]<Math.abs(x[6])) x[6]=Math.abs(x[4]);
       if(( x[2]>x[5])&&( x[4]>x[5]))   return(2);
       if((-x[1]>x[6])&&(-x[3]>x[6])) return(4);
       if((-x[2]>x[5])&&(-x[4]>x[5]))   return(6);
       if(( x[1]>x[6])&&( x[3]>x[6])) return(8);
       return(0);
    }
}
