/*
 * ParameterManager.java
 *
 * Created on December 10, 2005, 8:49 AM
 */

/**
 * This class manages the choice of the point in the parameter space.
 * It also maintains a rational triangle, and
 * a slected rational line (which may be null).
 *
 * I may eventually make this more powerful to take over some of the work
 * of RationalCanvas.
 *
 * @author  pat
 */
public class ParameterManager {
    /** in basic mode we don't update the rational location when the
     * point changes */
    public static final int BASICMODE=0;
    
    // currently we only use basic mode... this may change
    
    /** in rational mode we move to the nearest rational triangle */
    public static final int RATIONALMODE=1;
    /** in dyadic mode we move to the nearest rational triangle */
    public static final int DYADICMODE=2;
    
    
    private int mode=BASICMODE;
    private RationalTriangle T=new RationalTriangle(1,1,1);
    private RationalLine L=null;
    private Complex Z=new Complex(2.0/3,2.0/3);
    
    /** Creates a new instance of ParameterManager */
    public ParameterManager() {}
    
    //////////////// The Complex Parameter
    
    private void confineZ(){
        if (Z.x<0) Z.x=0;
        if (Z.x>1) Z.x=1;
        if (Z.y<0) Z.y=0;
        if (Z.y>1) Z.y=1;
    }
    
    /** set the current parameter */
    public void setParameter(double x, double y){
        Z=new Complex(x,y);
        confineZ();
    }
    
    /** set the current parameter */
    public void setParameter(Complex z) {
        this.Z=new Complex(z);
        confineZ();
    }
    
    /** get the x coordinate of the current parameter */
    public double getX() {
        return Z.x;
    }
    
    /** get the y coordinate of the current parameter */
    public double getY() {
        return Z.y;
    }
    
    /** get the current parameter as a Complex number */
    public Complex getZ() {
        return new Complex(Z);
    }
    
    //////////////////// The Rational Triangle
    
    /** set the rational triangle */
    public void setRationalTriangle(RationalTriangle t) {
        T=t;
    }
    
    /** get the rational triangle */
    public RationalTriangle getRationalTriangle() {
        return T;
    }
    
    /////////////////// The Rational Line
    
    /** set the rational line */
    public void setRationalLine(RationalLine l) {
        if (l==null)
            L=null;
        else
            L=new RationalLine(l);
    }
    
    /** get the rational line */
    public RationalLine getRationalLine() {
        return L;
    }
}
