/*
 * ParameterSpaceManager.java
 *
 * Created on December 10, 2005, 12:26 PM
 */

import java.util.*;
import java.lang.ref.WeakReference;
import java.awt.*;
import java.awt.geom.*;
/**
 * This component allows arbitrary components to render to the parameter
 * space at will.
 *
 * @author  pat
 */
public class ParameterSpaceManager implements ParameterSpaceRenderer {
    ////////// COLORS
    static final Color rightTriangleColor=Color.red;
    public boolean showBorder=true;
    
    private Manager M;
    
    // this is the bounding box for the parameter space.
    private final GeneralPath space=new GeneralPath();
    
    
    private LinkedList renderers;
    
    /** Creates a new instance of ParameterSpaceManager */
    public ParameterSpaceManager(Manager M) {
        this.M=M;
        
        renderers=new LinkedList();
        
        space.moveTo(0,0);
        space.lineTo(1,0);
        space.lineTo(1,1);
        space.lineTo(0,1);
        space.closePath();
        
    }
    
    /** Add me to the list of components that render to the canvas
     * I want to draw first! (meaning everything else will draw on top of me
     */
    public  void addRendererBottom(ParameterSpaceRenderer me) {
        //System.out.println("new renderer: "+me.getClass().getName());
        renderers.addFirst(new WeakReference(me));
    }
    
    /** Add me to the list of components that render to the canvas
     * I want to draw last! (meaning I draw on top of everything else)
     */
    public  void addRendererTop(ParameterSpaceRenderer me) {
        //System.out.println("new renderer: "+me.getClass().getName());
        renderers.addLast(new WeakReference(me));
    }
    
    /** This is a function that removes all references of the given object */
    public  void remove(Object obj){
        Object o;
        for (ListIterator it=renderers.listIterator(); it.hasNext();){
            o=((WeakReference)it.next()).get();
            if (o==null) {
                it.remove();
                System.err.println("Warning: ParameterSpaceManager removing something manually");
            } else if (o==obj) {
                //System.out.println("removing renderer: "+obj.getClass().getName());
                it.remove();
            }
        }
    }
    
    public  void render(Graphics2D g, AffineTransform T){
        //System.out.println("rendering parameter space");
        { // draw the bounding rectangle
            g.setColor(Color.black);
            g.fill(T.createTransformedShape(space));
        }
        if (showBorder) {
            {
                g.setColor(Color.white);
                g.draw(T.createTransformedShape(space));
            } { // draw the right triangle lines
                GeneralPath gp=new GeneralPath();
                gp.moveTo(1,0);
                gp.lineTo(1,1);
                gp.lineTo(0,1);
                gp.closePath();
                g.setColor(rightTriangleColor);
                g.draw(T.createTransformedShape(gp));
            }
        }
        
        // defer the rest of the drawing to the individual renderers
        Object o;
        for (ListIterator it=renderers.listIterator(); it.hasNext();){
            o=((WeakReference)it.next()).get();
            if (o==null) {
                it.remove();
                System.err.println("Warning: ParameterSpaceManager removing something manually");
            } else {
                ((ParameterSpaceRenderer)o).render(g,T);
            }
        }
    }
    
    public  void raise(String classname) {
        LinkedList ll=new LinkedList();
        Object o;
        for (ListIterator it=renderers.listIterator(); it.hasNext();){
            o=((WeakReference)it.next()).get();
            if (o==null) {
                it.remove();
                System.err.println("Warning: ParameterSpaceManager removing something manually");
            } else {
                if (o.getClass().getName().equals(classname)) {
                    it.remove();
                    ll.addLast(o);                   
                }
            }
        }
        for (ListIterator it=ll.listIterator(); it.hasNext(); ) {            
            renderers.addLast(new WeakReference(it.next()));
        }
    }
}