/*
 * PatList.java
 *
 * Created on October 19, 2005, 11:00 PM
 */

/**
 * This is a replacement for java.util.LinkedList as needed by the Slalom Search.
 * I hope it will run faster.
 * @author  pat
 */
public class PatList {
    Complex lst[]; // we think of this as ordered data 
    int first, // the first element is lst[first]
    last,      // the last element is lst[(last-1)%lst.length
    size;      // this is the same as (last-first)%lst.length
    
    /** Creates a new instance of PatList
     * @param sz the number of items this list can handle */
    public PatList(int sz) {
        lst=new Complex[sz];
        for (int i=0; i<sz; i++) {
            lst[i]=new Complex();
        }
        first=last=size=0;
    }
    
    public Complex[] extractData(){
        Complex ret[]=new Complex[size];
        for (int i=0; i<size; i++)
            ret[i]=new Complex(get(i));
        return ret;
    }
    
    /** replaces the data stored in this PatList with the data in
     * this array */
    public void replaceData(Complex data[]){
        for (last=0; last<data.length; last++) {
            lst[last].set(data[last]);
        }
        first=0;
        size=data.length;
    }
    
    /** add a copy of z */
    public void add(Complex z) {
        lst[last].set(z);
        last=(last+1)%lst.length;
        size=size+1;
    }
    
    public Complex get(int i) {
        return lst[(first+i)%lst.length];
    }
    
    public Complex getFirst(){
        return lst[first];
    }

    public Complex getSecond(){
        return lst[(first+1)%lst.length];
    }
    
    public Complex getLast(){
        return lst[(first+size-1)%lst.length];
    }
    
    public Complex getSecondToLast(){
        return lst[(first+size-2)%lst.length];
    }

    
    public void removeFirst(){
        first=(first+1)%lst.length;
        size--;
    }
    
    public void removeLast(){
        last=(last+lst.length-1)%lst.length;
        size--;
    }
    
    
    
}
