/*
 * PlottingInterphase.java
 *
 * Created on December 1, 2005, 7:10 AM
 */

import java.awt.event.*;
import java.awt.*;

/**
 * This interphase will be implemented to allows us to create many plotting options
 * which will ultimately share the same canvas.
 * @author  pat
 */
public interface PlottingInterface extends MouseListener {
    /** Return the name of the plot technique */
    public String name();
    
    /** This is the color used for the button */
    public Color getColor();
    
    /** Returns true if the plot can be run. This is useful for example
     * if the plot relies on C code which may or may not be available
     */
    public boolean canRun();
    
    /** draw the buttons etc. */
    public void paint(Graphics gfx);
    
    /** Return smallest area that the drawing will take up
     * @return an interger array of length 2 */
    public int[] getSize();
    
    /** Run the algorithm to plot the tile. */
    public Tile plot(String word, Interrupter I);
    
    /** Send documentation on this particular type of plotting
     * to the Explain Window. */
    public void document();
    
    /** These are taken from MouseListener */
    public void mouseClicked(MouseEvent e);
    
    public void mouseEntered(MouseEvent e);
    
    public void mouseExited(MouseEvent e);
    
    public void mousePressed(MouseEvent e);
    
    public void mouseReleased(MouseEvent e);
}
