
import java.awt.*;



public class PlottingZone extends PlottingDyadic {
    
    public PlottingZone(Manager M, Canvas C) {
        super(M,C);
    }


    public void document() {
        M.setExplain("This window is the McBilliards plotter. Given a word W, we are interesed in drawing the region O(W) in parameter space such that the corresponding triangles have a periodic billiard path with W as the combinatorial type. We call O(W) the 'orbit tile', or just the 'tile' for short. \n\n Right now the plotter is limited to plotting words of length 1000.  There are 4 plotting modes and 3 plotting styles.  Each of the plotting modes takes as its input an integer which controls the level of detail.  You can change this integer using the arrow keys. Once the integer D is fixed, there are 4 plotting modes: \n\nPack: produces a finite union P(D) of dyadic squares, each of which is guaranteed to be contained in O(W).\n\nCover: Produces a finite union C(D) of dyadic squares which is guaranteed to contain O(W). \n\nFill: (The main mode) Produces a set of the form \n\nF(D)= P(D) union L(D),\n\n where L(D) is obtained by taking each square in the set C(D)-P(D) and chopping it down according to the linearizations of the functions which define the edges of the tile.  As D increases, L(D) converges to O(W).\n\nZone: Produces a partition of F(D) into smaller pieces, each of which corresponds to a combinatorially stable configuration of the unfolding. To appreciate this mode you should open up the unfolding window and turn on the leaders function, then click on different pieces in the partition produced by the zone mode and watch the unfolding.\n\nFor each of the plotting modes there are 3 drawing styles:\n\nSolid: Produces a solid picture.\n\nSeams:Shows the breakdown of the above mentioned asets into their component squares.\n\nLocal: For all the modes except Zone, this plots the single box which contains the point in the tile on which you have clicked.  If you have clicked outside the tile, nothing is returned.For the Zone more, this style returns the piece of the partition which contains the clicked point. \n\nThere is one additional option you have when plotting.  This is a technical feature which we will document later.");    }


    
    public String name() {
        return "zone";
    }
    
    public Color getColor() {
        return new Color(50,255,50);
    }
    
    public int getRigor() {
	return 4;
    }
    
}
