/*
 * PopupWindow.java
 *
 * Created on October 30, 2005, 1:04 PM
 */

import java.awt.*;
import java.awt.event.*;
/**
 * This class is meant to hold a single canvas, which it places in a
 * popup window. Note that popup windows can be resized.
 *
 * @author  pat
 */
public class PopupMenu extends Frame implements ComponentListener, WindowListener, WindowFocusListener {
    Component parent;
    Component C;
    HearingPopup HP;
    
    /** Creates a new instance of PopupMenu */
    public PopupMenu(Component parent, Component C, int x, int y, HearingPopup HP) {
        //super();
        this.parent=parent;
        this.HP=HP;
        this.C=C;
        
        setUndecorated(true);
        
        // set the location to appear
        setPlace(x, y);
        
        // this allows us to detect the TAB key
        setFocusTraversalKeys(KeyboardFocusManager.FORWARD_TRAVERSAL_KEYS,
        java.util.Collections.EMPTY_SET);
        
        add(C);
        pack();
        
        addComponentListener(this);
        addWindowListener(this);
        addWindowFocusListener(this);
        open();
    }
    
    public void setPlace(int x, int y) {
        Point P=parent.getLocationOnScreen();
        super.setLocation(P.x+x,P.y+y);
    }
    
    
    /** Call this to actuall open the popup menu.
     * This should be the last thing you do in creation.
     */
    public void open(){
        // check to make sure the menu fits on the screen.
        Rectangle screen_bounds = parent.getGraphicsConfiguration().getBounds(),
        my_bounds=getBounds();
        //System.out.println("screen bounds=("+
        //screen_bounds.x+","+screen_bounds.y+","+
        //screen_bounds.width+","+screen_bounds.height+")");
        
        if (my_bounds.x<screen_bounds.x) {
            my_bounds.x=screen_bounds.x;
        }
        if (my_bounds.x+my_bounds.width>screen_bounds.x+screen_bounds.width) {
            my_bounds.x=screen_bounds.x+screen_bounds.width-my_bounds.width;
        }
        if (my_bounds.y<screen_bounds.y) {
            my_bounds.y=screen_bounds.y;
        }
        if (my_bounds.y+my_bounds.height>screen_bounds.y+screen_bounds.height) {
            my_bounds.y=screen_bounds.y+screen_bounds.height-my_bounds.height;
        }
        
        setSize(parent.getWidth() + (getInsets().left + getInsets().right),
        parent.getHeight() + (getInsets().top + getInsets().bottom));
        getLayout().layoutContainer(this);
        
        
        setBounds(my_bounds);
        
        setVisible(true);
    }
    
    /** call this to close the popup */
    public synchronized void forceClose() {
        if (HP !=null) {
            // dispose of the window
            dispose();
            // notify that the window has closed, so the component is no longer
            // displayed.
            HP.popupClosed(C);
            
            // remove all references to C
            C=null;
            //remove references to parent
            parent=null;
            // remove all references to HP
            HP=null;
            
            removeAll();
            System.gc();
        }
    }
    
    ////////////////// ComponentListener
    
    public void componentHidden(ComponentEvent e) {
    }
    
    public void componentMoved(ComponentEvent e) {
    }
    
    public void componentResized(ComponentEvent e) {
    }
    
    /* Resize the Window so the width and
     * height are as specified by the constructor */
    public void componentShown(ComponentEvent e) {
        Insets insets=getInsets();
        if ((insets.left!=0)||(insets.right!=0)||(insets.top!=0)||(insets.bottom!=0)) {
            Rectangle my_bounds=getBounds();
            my_bounds.x-=insets.left;
            //my_bounds.width+=insets.right+insets.left;
            my_bounds.y-=insets.top;
            //my_bounds.height+=insets.bottom+insets.top;
            setBounds(my_bounds);
        }
        //C.requestFocus();
    }
    
    
    
    public void windowActivated(java.awt.event.WindowEvent windowEvent) {
    }
    
    public void windowClosed(java.awt.event.WindowEvent windowEvent) {
    }
    
    public void windowClosing(java.awt.event.WindowEvent windowEvent) {
        forceClose();
    }
    
    public void windowDeactivated(java.awt.event.WindowEvent windowEvent) {
    }
    
    public void windowDeiconified(java.awt.event.WindowEvent windowEvent) {
    }
    
    public void windowIconified(java.awt.event.WindowEvent windowEvent) {
    }
    
    public void windowOpened(java.awt.event.WindowEvent windowEvent) {
    }
    
    public void windowGainedFocus(java.awt.event.WindowEvent windowEvent) {
    }    
    
    public void windowLostFocus(java.awt.event.WindowEvent windowEvent) {
        forceClose();
    }    
    
}
