/*
 * Projection3D.java
 *
 * Created on November 11, 2005, 8:15 AM
 */

import java.lang.Math;

/**
 * This class handles a projection from R^3 to R^2.
 * @author  pat
 */
public class Projection3D {
    public double m[][]=new double[3][4]; // Matrix determining affine projection to plane
    
    public final static double rt3=Math.sqrt(3);
    
    static Projection3D Standard(){
        Projection3D m=new Projection3D();
        m.m[0][0]=rt3/2; m.m[0][1]=-rt3/2; m.m[0][2]=0; m.m[0][3]=0;
        m.m[1][0]=0.5; m.m[1][1]=0.5; m.m[1][2]=-1; m.m[1][3]=0;
        m.m[2][0]=0; m.m[2][1]=0; m.m[2][2]=0; m.m[2][3]=1;
        return m;
    }
    
    static Projection3D Normal(Complex z){
        double a=z.x,b=z.y,c=2-a-b;
        double
        s2=Math.sqrt(2*c*c+(a+b)*(a+b)),
        s1=s2*Math.sqrt(a*a+b*b+c*c);
        Projection3D m=new Projection3D();
        
        m.m[0][0]=(c*c+b*(a+b))/s1; m.m[0][1]=-(c*c+a*(a+b))/s1; m.m[0][2]=(c*(b-a))/s1; m.m[0][3]=0;
        m.m[1][0]=c/s2; m.m[1][1]=c/s2; m.m[1][2]=(-a-b)/s2; m.m[1][3]=0;
        m.m[2][0]=0; m.m[2][1]=0; m.m[2][2]=0; m.m[2][3]=1;
        return m;
        
    }
    
    static Projection3D Dot(Complex z){
        double a=z.x,b=z.y,c=2-a-b;
        Projection3D m=new Projection3D();
        m.m[0][0]=a*rt3/2; m.m[0][1]=-b*rt3/2; m.m[0][2]=0; m.m[0][3]=0;
        m.m[1][0]=a/2; m.m[1][1]=b/2; m.m[1][2]=-c; m.m[1][3]=0;
        m.m[2][0]=0; m.m[2][1]=0; m.m[2][2]=0; m.m[2][3]=1;
        return m;
    }
    
    
    Complex act(HolonomyPosition hp){
        double
        x=m[0][0]*hp.p[0]+m[0][1]*hp.p[1]+m[0][2]*hp.p[2]+m[0][3],
        y=m[1][0]*hp.p[0]+m[1][1]*hp.p[1]+m[1][2]*hp.p[2]+m[1][3],
        z=m[2][0]*hp.p[0]+m[2][1]*hp.p[1]+m[2][2]*hp.p[2]+m[2][3];
        return new Complex(x/z, y/z);
    }
    
    Complex[] act(HolonomyPosition[] hp){
        Complex[] ret=new Complex[hp.length];
        for (int i=0; i<hp.length; i++) {
            ret[i]=act(hp[i]);
        }
        return ret;
    }
    
    
}
