/*
 * RationalGrid.java
 *
 * Created on December 9, 2005, 7:04 PM
 */

import java.awt.geom.*;
import java.io.*;

/**
 * A rational grid is a integral linear map from the integers to
 * rational lines.
 * Here x -> zero+x*infinite
 * where the right hand side is coordinates for RationalLines as descdibed in
 * RationalLine.java.
 *
 * In principle, we render from start to end-1
 *
 * @author  pat
 */
public class RationalGrid {
    public int start, end;
    public int p=1,q=1;
    public RationalLine zero,infinite;
    
    public Line2D.Double[] lines;
    
    public RationalGrid() {
        start=1;
        end=20;
    }
    
    public static RationalGrid standardVertical() {
        RationalGrid g=new RationalGrid();
        g.start=1;
        g.infinite=new RationalLine(-1,0,0);
        g.zero=new RationalLine(-1,1,1);
        return g;
    }
    public static RationalGrid standardHorizontal() {
        RationalGrid g=new RationalGrid();
        g.start=1;
        g.infinite=new RationalLine(0,-1,0);
        g.zero=new RationalLine(1,-1,1);
        return g;
    }
    public void save(PrintWriter out) {
        out.println(zero.toSaveString());
        out.println(infinite.toSaveString());
        out.println(""+start+" "+end);
        out.println(""+p+" "+q);
    }
    public static RationalGrid load(BufferedReader br) 
    throws java.io.IOException {
        RationalGrid G=new RationalGrid();
        
        String s=br.readLine();
        String[] A=s.split(" ");
        G.zero=new RationalLine(
        Integer.parseInt(A[0]),
        Integer.parseInt(A[1]),
        Integer.parseInt(A[2]));
        
        s=br.readLine();
        A=s.split(" ");
        G.infinite=new RationalLine(
        Integer.parseInt(A[0]),
        Integer.parseInt(A[1]),
        Integer.parseInt(A[2]));
        
        s=br.readLine();
        A=s.split(" ");
        G.start=Integer.parseInt(A[0]);
        G.end=Integer.parseInt(A[1]);
        
        s=br.readLine();
        A=s.split(" ");
        G.p=Integer.parseInt(A[0]);
        G.q=Integer.parseInt(A[1]);
        
        G.computeLines();
        
        return G;
    }
    
    public RationalLine getLine(int i){
        RationalLine l=new RationalLine(
        q*infinite.x[0]*i+p*zero.x[0],
        q*infinite.x[1]*i+p*zero.x[1],
        q*infinite.x[2]*i+p*zero.x[2]);
        //System.out.println("line="+l);
        return l;
    }
    
    public double[] getLine(double i) {
        double[] ret=new double[3];
        ret[0]=q*infinite.x[0]*i+p*zero.x[0];
        ret[1]=q*infinite.x[1]*i+p*zero.x[1];
        ret[2]=q*infinite.x[2]*i+p*zero.x[2];
        return ret;
    }
    
    public double getI(Complex z) {
        try {
            return -p*zero.dot(z)/infinite.dot(z)/q;
        } catch (Exception e) {
            // probably division by zero was caught
            return Double.NaN;
        }
    }
    
    public RationalLine getParams(int i) {
        if (i==0)
            return zero;
        return infinite;
    }
    
    public void computeLines() {
        if (end-start<0) {
            lines=new Line2D.Double[0];
            return;
        }
        lines=new Line2D.Double[end-start];
        for (int i=start; i<end; i++) {
            lines[i-start]=getLine(i).toLineSegment();
        }
    }
}
