import java.lang.Thread;

public class ScaledSearch extends Thread {
    
    private Complex tri; // coordinates for triangle
    private int depth;
    private BasicSearcher bs;
    private boolean interrupt;
    
    private class SearchData {
        SlalomUnfolding.DataBackup db;
        int lexi, next;
        double len;
        
        public SearchData(SlalomUnfolding SU, int LEXI, int NEXT, double LEN) {
            db=SU.backup();
            lexi=LEXI;
            next=NEXT;
            len=LEN;
        }
    }
    
    /** The BasicSearcher is the class that handles the responses */
    public ScaledSearch(Complex tri, int depth, BasicSearcher BS){
        bs=BS;
        this.tri=new Complex(tri);
        this.depth=depth;
        start();
    }
    
    /** Return true if the word w (from 0 up to l-1) is less or equal
     * lexigraphically than the word obtained by starting with next and
     * adding letters of w in reverse order (from l-1 down to 0)
     **/
    public static boolean reverseLexiTest(int w[], int l, int next) {
        if (w[0]<next)
            return true;
        if (w[0]>next)
            return false;
        for (int i=1; i<(l+1)/2; i++){
            if (w[i]<w[l-i])
                return true;
            if (w[i]>w[l-i])
                return false;
        }
        return true;
    }
    
    public void interrupt() {
        interrupt=true;
    }
    
    /** Start the search! */
    public void run(){
        interrupt=false;
        //int languish=0;
        // for storing the results:
        StringWordOrganizer results=new StringWordOrganizer();
        
        // backup the depth (it may change otherwise)
        int d=depth;
        
        /** Information used when searching */
        int w[]=new int[d];     // array of letters in the word
        w[0]=0;
        w[1]=1;
        
        int l=2;                  // current word length
        int lexi=0;               // lexi-test data
        HolonomyPosition hp=new HolonomyPosition(0); // current position in hol grid
        hp.shift(1);
        
        SlalomUnfolding su=new SlalomUnfolding(tri,0);
        if (!su.addEdge(1)) {
            l=5/0;
        }
        
        SearchData sd[]=new SearchData[d+1];
        
        int next,next2;
        double dist,dist2,dist3;
        double min=tri.x;
        if (tri.y<min)
            min=tri.y;
        if (2-tri.x-tri.y<min) 
            min=2-tri.x-tri.y;        
        
        double len=3*(2-tri.x-tri.y)/2;
        
        
        while (l>1){
            if (interrupt)
                return;
            
            //           System.out.println("Statistics: length="+l+" size="+su.size());
            //            if (l==151)
            //                System.out.println("help");
            if ((hp.futureDist(0)==0) &&
            (su.strongTest()) &&
            (lexi<=l/2) &&
            ((lexi<l/2)||(lexi%2==1))) {
                StringBuffer temp=new StringBuffer(l);
                for (int i=0; i<l; i++){
                    temp.append((char)('1'+w[i]));
                }
                results.add(temp.toString());
            }
            dist=hp.scaledDist(tri);
            
            next=(w[l-1]+1)%3;
            dist2=hp.futureScaledDist(tri,next);
            
            
            
            if ((next>=w[lexi])&&           // lexi-test
            (len+dist2<d)&&                 // distance test
            (su.survivesAdd(next)) &&       // slalom test
            (reverseLexiTest(w,l,next))) {   //reverse lexi test
                next2=(w[l-1]+2)%3;
                dist3=hp.futureScaledDist(tri,next2);
                
                
                if ((next2>=w[lexi])&&           // lexi-test
                (len+dist3<d)&&               // distance test
                (su.survivesAdd(next2)) &&       // slalom test
                (reverseLexiTest(w,l,next2))) {   //reverse lexi test
                    // we need to add both
                    // copy to backup
                    sd[l-1]=new SearchData(su,lexi,next2,len+Math.abs(dist3-dist));
                    
                    // add next
                    if (w[lexi]<next)
                        lexi=0;
                    else
                        lexi++;
                    if (!su.addEdge(next)) {
                        l=5/0;
                    }
                    len+=Math.abs(dist2-dist);
                    hp.shift(next);
                    w[l++]=next;
                } else {
                    // we only need to add next
                    if (w[lexi]<next)
                        lexi=0;
                    else
                        lexi++;
                    if (!su.addEdge(next)) {
                        l=5/0;
                    }
                    len+=Math.abs(dist2-dist);
                    hp.shift(next);
                    w[l++]=next;
                }
            } else {
                next2=(w[l-1]+2)%3;
                dist3=hp.futureScaledDist(tri,next2);
                
                
                if ((next2>=w[lexi])&&           // lexi-test
                (len+dist3<d)&&                    // distance test
                (su.survivesAdd(next2)) &&       // slalom test
                (reverseLexiTest(w,l,next2))) {   //reverse lexi test
                    // we only need to add next2
                    if (w[lexi]<next2)
                        lexi=0;
                    else
                        lexi++;
                    if (!su.addEdge(next2)) {
                        l=5/0;
                    }
                    hp.shift(next2);
                    len+=Math.abs(dist3-dist);
                    w[l++]=next2;
                } else {
                    l=l-1;
                    hp.shift(w[l]);
                    while ((l>1)&&(sd[l-1]==null)){
                        l=l-1;
                        hp.shift(w[l]);
                    }
                    if (l>1) {
                        next=sd[l-1].next;
                        lexi=sd[l-1].lexi;
                        len=sd[l-1].len;
                        su.recover(sd[l-1].db);
                        sd[l-1]=null;
                        
                        if (w[lexi]<next)
                            lexi=0;
                        else
                            lexi++;
                        if (!su.addEdge(next)) {
                            l=5/0;
                        }
                        hp.shift(next);
                        w[l++]=next;
                    }
                }
            }
        }
        //System.out.println("Languishing words="+languish);
        bs.doneBasicSearch(new BasicSearchResults(results.toArray(),tri));
    }
}