import java.util.LinkedList;
import java.awt.geom.GeneralPath;
import java.util.ListIterator;
import java.awt.geom.Point2D;
import java.awt.Dimension;
import java.awt.geom.AffineTransform;

/**
 * This is a version of the unfolding used in searching.
 * It only keeps track of enough information to run
 * the slalom test.
 */
public class SlalomUnfolding {
    SlalomHull sh;
    private ListenTriangle t;
    int last_side;
    boolean even;
    
    public class DataBackup{
        ListenTriangle t;
        int last_side;
        boolean even;
        SlalomHull.DataBackup db;
        
        public DataBackup(SlalomUnfolding su){
            t=new ListenTriangle(su.t);
            last_side=su.last_side;
            even=su.even;
            db=su.sh.backup();
        }
    }
    
    /** Compute an unfolding using the given triangle.
     * Add the triangle obtained by reflection in edge i (i=0,1,2)
     */
    public SlalomUnfolding(Complex z, int i){
        t=ListenTriangle.init2(z);
        sh=new SlalomHull(new Complex(t.z[(i+2)%3]),new Complex(t.z[(i+1)%3]));
        even=true;
        last_side=i;
        //t=t.reflect(i);
        t.reflectMe(i);
    }
    
    public DataBackup backup(){
        return new DataBackup(this);
    }
    
    public void recover(DataBackup db){
        t=db.t;
        last_side=db.last_side;
        even=db.even;
        sh.recover(db.db);        
    }
    
    /** Copy Constructor */
    //    public SlalomUnfolding(SlalomUnfolding su){
    //        sh=new SlalomHull(su.sh);
    //        t=new ListenTriangle(su.t);
    //
    //        even=su.even;
    //        last_side=su.last_side;
    //    }
    
    
    /** Return the size of the SlalomHull */
    public int size(){
        return sh.size();
    }
    
    /**
     * add the triangle obtained by reflection in edge i (i=0,1,2)
     */
    public boolean addEdge(int i){
        int ls=last_side;
        t.reflectMe(i);
        //t=t.reflect(i);
        
        even=!even;
        if (even) {
            if (i==(last_side+1)%3) {
                last_side=i;
                return sh.addToLeft(t.z[ls]);
            } else {
                last_side=i;
                return sh.addToRight(t.z[ls]);
            }
        } else {
            if (i==(last_side+1)%3) {
                last_side=i;
                return sh.addToRight(t.z[ls]);
            } else {
                last_side=i;
                return sh.addToLeft(t.z[ls]);
            }
        }
    }
    
    
    /** Return false if the hull will be destroyed
     * when i is added.
     */
    public boolean survivesAdd(int i){
        if (even) {
            if (i==(last_side+1)%3) {
                return sh.survivesRightAdd(t.z[last_side]);
            } else {
                return sh.survivesLeftAdd(t.z[last_side]);
            }
        } else {
            if (i==(last_side+1)%3) {
                return sh.survivesLeftAdd(t.z[last_side]);
            } else {
                return sh.survivesRightAdd(t.z[last_side]);
            }
        }
    }
    
    /** Return a polygonal line visiting all
     * the vertices on the left */
    //    public GeneralPath leftChain() {
    //        return sh.leftChain();
    //    }
    
    
    /** Return a polygonal line visiting all
     * the vertices on the right */
    //    public GeneralPath rightChain() {
    //        return sh.rightChain();
    //    }
    
    
    /** z is a vector pointing in the direction of holonomy of the unfolding */
    public boolean strongTest(){
        // this depends on the fact that the initial triangle satisfies t.z[0]=0
        return sh.strongTest(new Complex(t.z[0]));
    }
}